/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.summary;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.summary.SumOfLogs;
import org.junit.Assert;
import org.junit.Test;

public class SumLogTest
extends StorelessUnivariateStatisticAbstractTest {
    public SumOfLogs getUnivariateStatistic() {
        return new SumOfLogs();
    }

    @Override
    public double expectedValue() {
        return this.sumLog;
    }

    @Test
    public void testSpecialValues() {
        SumOfLogs sum = this.getUnivariateStatistic();
        Assert.assertEquals((double)0.0, (double)sum.getResult(), (double)0.0);
        sum.increment(1.0);
        Assert.assertFalse((boolean)Double.isNaN(sum.getResult()));
        sum.increment(0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)sum.getResult(), (double)0.0);
        sum.increment(Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)Double.isNaN(sum.getResult()));
        sum.clear();
        Assert.assertEquals((double)0.0, (double)sum.getResult(), (double)0.0);
        sum.increment(Double.POSITIVE_INFINITY);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)sum.getResult(), (double)0.0);
        sum.increment(-2.0);
        Assert.assertTrue((boolean)Double.isNaN(sum.getResult()));
    }

    @Override
    protected void checkClearValue(StorelessUnivariateStatistic statistic) {
        Assert.assertEquals((double)0.0, (double)statistic.getResult(), (double)0.0);
    }
}

