/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.summary;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.junit.Assert;
import org.junit.Test;

public class SumTest
extends StorelessUnivariateStatisticAbstractTest {
    public Sum getUnivariateStatistic() {
        return new Sum();
    }

    @Override
    public double expectedValue() {
        return this.sum;
    }

    public double expectedWeightedValue() {
        return this.weightedSum;
    }

    @Test
    public void testSpecialValues() {
        Sum sum = this.getUnivariateStatistic();
        Assert.assertEquals((double)0.0, (double)sum.getResult(), (double)0.0);
        sum.increment(1.0);
        Assert.assertEquals((double)1.0, (double)sum.getResult(), (double)0.0);
        sum.increment(Double.POSITIVE_INFINITY);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)sum.getResult(), (double)0.0);
        sum.increment(Double.NEGATIVE_INFINITY);
        Assert.assertTrue((boolean)Double.isNaN(sum.getResult()));
        sum.increment(1.0);
        Assert.assertTrue((boolean)Double.isNaN(sum.getResult()));
    }

    @Test
    public void testWeightedSum() {
        Sum sum = new Sum();
        Assert.assertEquals((double)this.expectedWeightedValue(), (double)sum.evaluate(this.testArray, this.testWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assert.assertEquals((double)this.expectedValue(), (double)sum.evaluate(this.testArray, this.unitWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
    }

    @Override
    protected void checkClearValue(StorelessUnivariateStatistic statistic) {
        Assert.assertEquals((double)0.0, (double)statistic.getResult(), (double)0.0);
    }
}

