/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.vector;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.vector.VectorialStorelessStatistic;
import org.junit.Assert;
import org.junit.Test;

public class VectorialStorelessStatisticTest {
    private double[][] points = new double[][]{{1.2, 2.3, 4.5}, {-0.7, 2.3, 5.0}, {3.1, 0.0, -3.1}, {6.0, 1.2, 4.2}, {-0.7, 2.3, 5.0}};

    protected VectorialStorelessStatistic createStatistic(int dimension) {
        return new VectorialStorelessStatistic(dimension, (StorelessUnivariateStatistic)new Mean());
    }

    @Test
    public void testMismatch() {
        try {
            this.createStatistic(8).increment(new double[5]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException dme) {
            Assert.assertEquals((long)5L, (long)((Integer)dme.getParts()[0]).intValue());
            Assert.assertEquals((long)8L, (long)((Integer)dme.getParts()[1]).intValue());
        }
    }

    @Test
    public void testSimplistic() {
        VectorialStorelessStatistic stat = this.createStatistic(2);
        stat.increment(new double[]{-1.0, 1.0});
        stat.increment(new double[]{1.0, -1.0});
        double[] mean = stat.getResult();
        Assert.assertEquals((double)0.0, (double)mean[0], (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)mean[1], (double)1.0E-12);
    }

    @Test
    public void testBasicStats() {
        VectorialStorelessStatistic stat = this.createStatistic(this.points[0].length);
        for (int i = 0; i < this.points.length; ++i) {
            stat.increment(this.points[i]);
        }
        Assert.assertEquals((long)this.points.length, (long)stat.getN());
        double[] mean = stat.getResult();
        double[] refMean = new double[]{1.78, 1.62, 3.12};
        for (int i = 0; i < mean.length; ++i) {
            Assert.assertEquals((double)refMean[i], (double)mean[i], (double)1.0E-12);
        }
    }

    @Test
    public void testSerial() {
        VectorialStorelessStatistic stat = this.createStatistic(this.points[0].length);
        for (int i = 0; i < this.points.length; ++i) {
            stat.increment(this.points[i]);
        }
        Assert.assertEquals((Object)stat, (Object)UnitTestUtils.serializeAndRecover((Object)stat));
    }
}

