/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.stat.inference.ChiSquareTest;
import org.hipparchus.stat.inference.InferenceTestUtils;
import org.hipparchus.stat.inference.KolmogorovSmirnovTestTest;
import org.hipparchus.stat.inference.OneWayAnova;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class InferenceTestUtilsTest {
    private double[] classA = new double[]{93.0, 103.0, 95.0, 101.0};
    private double[] classB = new double[]{99.0, 92.0, 102.0, 100.0, 102.0};
    private double[] classC = new double[]{110.0, 115.0, 111.0, 117.0, 128.0};
    private List<double[]> classes = new ArrayList<double[]>();
    private OneWayAnova oneWayAnova = new OneWayAnova();
    private double[] tooShortObs = new double[]{1.0};
    private double[] emptyObs = new double[0];
    private StreamingStatistics emptyStats = new StreamingStatistics();

    @Test
    public void testChiSquare() {
        long[] observed = new long[]{10L, 9L, 11L};
        double[] expected = new double[]{10.0, 10.0, 10.0};
        Assert.assertEquals((String)"chi-square statistic", (double)0.2, (double)InferenceTestUtils.chiSquare((double[])expected, (long[])observed), (double)1.0E-11);
        Assert.assertEquals((String)"chi-square p-value", (double)0.904837418036, (double)InferenceTestUtils.chiSquareTest((double[])expected, (long[])observed), (double)1.0E-10);
        long[] observed1 = new long[]{500L, 623L, 72L, 70L, 31L};
        double[] expected1 = new double[]{485.0, 541.0, 82.0, 61.0, 37.0};
        Assert.assertEquals((String)"chi-square test statistic", (double)9.023307936427388, (double)InferenceTestUtils.chiSquare((double[])expected1, (long[])observed1), (double)1.0E-10);
        Assert.assertEquals((String)"chi-square p-value", (double)0.06051952647453607, (double)InferenceTestUtils.chiSquareTest((double[])expected1, (long[])observed1), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test reject", (boolean)InferenceTestUtils.chiSquareTest((double[])expected1, (long[])observed1, (double)0.07));
        Assert.assertTrue((String)"chi-square test accept", (!InferenceTestUtils.chiSquareTest((double[])expected1, (long[])observed1, (double)0.05) ? 1 : 0) != 0);
        try {
            InferenceTestUtils.chiSquareTest((double[])expected1, (long[])observed1, (double)95.0);
            Assert.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[] tooShortObs = new long[]{0L};
        double[] tooShortEx = new double[]{1.0};
        try {
            InferenceTestUtils.chiSquare((double[])tooShortEx, (long[])tooShortObs);
            Assert.fail((String)"arguments too short, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[] unMatchedObs = new long[]{0L, 1L, 2L, 3L};
        double[] unMatchedEx = new double[]{1.0, 1.0, 2.0};
        try {
            InferenceTestUtils.chiSquare((double[])unMatchedEx, (long[])unMatchedObs);
            Assert.fail((String)"arrays have different lengths, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        expected[0] = 0.0;
        try {
            InferenceTestUtils.chiSquareTest((double[])expected, (long[])observed, (double)0.01);
            Assert.fail((String)"bad expected count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        expected[0] = 1.0;
        observed[0] = -1L;
        try {
            InferenceTestUtils.chiSquareTest((double[])expected, (long[])observed, (double)0.01);
            Assert.fail((String)"bad expected count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testChiSquareIndependence() {
        long[][] counts = new long[][]{{40L, 22L, 43L}, {91L, 21L, 28L}, {60L, 10L, 22L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)22.709027688, (double)InferenceTestUtils.chiSquare((long[][])counts), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)1.44751460134E-4, (double)InferenceTestUtils.chiSquareTest((long[][])counts), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test reject", (boolean)InferenceTestUtils.chiSquareTest((long[][])counts, (double)2.0E-4));
        Assert.assertTrue((String)"chi-square test accept", (!InferenceTestUtils.chiSquareTest((long[][])counts, (double)1.0E-4) ? 1 : 0) != 0);
        long[][] counts2 = new long[][]{{10L, 15L}, {30L, 40L}, {60L, 90L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)0.168965517241, (double)InferenceTestUtils.chiSquare((long[][])counts2), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)0.918987499852, (double)InferenceTestUtils.chiSquareTest((long[][])counts2), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test accept", (!InferenceTestUtils.chiSquareTest((long[][])counts2, (double)0.1) ? 1 : 0) != 0);
        long[][] counts3 = new long[][]{{40L, 22L, 43L}, {91L, 21L, 28L}, {60L, 10L}};
        try {
            InferenceTestUtils.chiSquare((long[][])counts3);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[][] counts4 = new long[][]{{40L, 22L, 43L}};
        try {
            InferenceTestUtils.chiSquare((long[][])counts4);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[][] counts5 = new long[][]{{40L}, {40L}, {30L}, {10L}};
        try {
            InferenceTestUtils.chiSquare((long[][])counts5);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[][] counts6 = new long[][]{{10L, -2L}, {30L, 40L}, {60L, 90L}};
        try {
            InferenceTestUtils.chiSquare((long[][])counts6);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.chiSquareTest((long[][])counts, (double)0.0);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testChiSquareLargeTestStatistic() {
        double[] exp = new double[]{3389119.5, 649136.6, 285745.4, 2.535736476E7, 1.129118978E7, 543628.0, 232921.0, 437665.75};
        long[] obs = new long[]{2372383L, 584222L, 257170L, 17750155L, 7903832L, 489265L, 209628L, 393899L};
        ChiSquareTest csti = new ChiSquareTest();
        double cst = csti.chiSquareTest(exp, obs);
        Assert.assertEquals((String)"chi-square p-value", (double)0.0, (double)cst, (double)0.001);
        Assert.assertEquals((String)"chi-square test statistic", (double)114875.90421929007, (double)InferenceTestUtils.chiSquare((double[])exp, (long[])obs), (double)1.0E-9);
    }

    @Test
    public void testChiSquareZeroCount() {
        long[][] counts = new long[][]{{40L, 0L, 4L}, {91L, 1L, 2L}, {60L, 2L, 0L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)9.67444662263, (double)InferenceTestUtils.chiSquare((long[][])counts), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)0.0462835770603, (double)InferenceTestUtils.chiSquareTest((long[][])counts), (double)1.0E-9);
    }

    @Test
    public void testOneSampleT() {
        double[] observed = new double[]{93.0, 103.0, 95.0, 101.0, 91.0, 105.0, 96.0, 94.0, 101.0, 88.0, 98.0, 94.0, 101.0, 92.0, 95.0};
        double mu = 100.0;
        StreamingStatistics sampleStats = new StreamingStatistics();
        for (int i = 0; i < observed.length; ++i) {
            sampleStats.addValue(observed[i]);
        }
        Assert.assertEquals((String)"t statistic", (double)-2.81976445346, (double)InferenceTestUtils.t((double)mu, (double[])observed), (double)1.0E-9);
        Assert.assertEquals((String)"t statistic", (double)-2.81976445346, (double)InferenceTestUtils.t((double)mu, (StatisticalSummary)sampleStats), (double)1.0E-9);
        Assert.assertEquals((String)"p value", (double)0.0136390585873, (double)InferenceTestUtils.tTest((double)mu, (double[])observed), (double)1.0E-9);
        Assert.assertEquals((String)"p value", (double)0.0136390585873, (double)InferenceTestUtils.tTest((double)mu, (StatisticalSummary)sampleStats), (double)1.0E-9);
        try {
            InferenceTestUtils.t((double)mu, (double[])null);
            Assert.fail((String)"arguments too short, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.t((double)mu, (StatisticalSummary)((StreamingStatistics)null));
            Assert.fail((String)"arguments too short, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.t((double)mu, (double[])this.emptyObs);
            Assert.fail((String)"arguments too short, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.t((double)mu, (StatisticalSummary)this.emptyStats);
            Assert.fail((String)"arguments too short, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.t((double)mu, (double[])this.tooShortObs);
            Assert.fail((String)"insufficient data to compute t statistic, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.tTest((double)mu, (double[])this.tooShortObs);
            Assert.fail((String)"insufficient data to perform t test, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.t((double)mu, (StatisticalSummary)((StreamingStatistics)null));
            Assert.fail((String)"insufficient data to compute t statistic, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.tTest((double)mu, (StatisticalSummary)((StreamingStatistics)null));
            Assert.fail((String)"insufficient data to perform t test, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOneSampleTTest() {
        double[] oneSidedP = new double[]{2.0, 0.0, 6.0, 6.0, 3.0, 3.0, 2.0, 3.0, -6.0, 6.0, 6.0, 6.0, 3.0, 0.0, 1.0, 1.0, 0.0, 2.0, 3.0, 3.0};
        StreamingStatistics oneSidedPStats = new StreamingStatistics();
        for (int i = 0; i < oneSidedP.length; ++i) {
            oneSidedPStats.addValue(oneSidedP[i]);
        }
        Assert.assertEquals((String)"one sample t stat", (double)3.86485535541, (double)InferenceTestUtils.t((double)0.0, (double[])oneSidedP), (double)1.0E-9);
        Assert.assertEquals((String)"one sample t stat", (double)3.86485535541, (double)InferenceTestUtils.t((double)0.0, (StatisticalSummary)oneSidedPStats), (double)1.0E-10);
        Assert.assertEquals((String)"one sample p value", (double)5.21637019637E-4, (double)(InferenceTestUtils.tTest((double)0.0, (double[])oneSidedP) / 2.0), (double)1.0E-9);
        Assert.assertEquals((String)"one sample p value", (double)5.21637019637E-4, (double)(InferenceTestUtils.tTest((double)0.0, (StatisticalSummary)oneSidedPStats) / 2.0), (double)1.0E-4);
        Assert.assertTrue((String)"one sample t-test reject", (boolean)InferenceTestUtils.tTest((double)0.0, (double[])oneSidedP, (double)0.01));
        Assert.assertTrue((String)"one sample t-test reject", (boolean)InferenceTestUtils.tTest((double)0.0, (StatisticalSummary)oneSidedPStats, (double)0.01));
        Assert.assertTrue((String)"one sample t-test accept", (!InferenceTestUtils.tTest((double)0.0, (double[])oneSidedP, (double)1.0E-4) ? 1 : 0) != 0);
        Assert.assertTrue((String)"one sample t-test accept", (!InferenceTestUtils.tTest((double)0.0, (StatisticalSummary)oneSidedPStats, (double)1.0E-4) ? 1 : 0) != 0);
        try {
            InferenceTestUtils.tTest((double)0.0, (double[])oneSidedP, (double)95.0);
            Assert.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.tTest((double)0.0, (StatisticalSummary)oneSidedPStats, (double)95.0);
            Assert.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoSampleTHeterscedastic() {
        double[] sample1 = new double[]{7.0, -4.0, 18.0, 17.0, -3.0, -5.0, 1.0, 10.0, 11.0, -2.0};
        double[] sample2 = new double[]{-1.0, 12.0, -1.0, -3.0, 3.0, -5.0, 5.0, 2.0, -11.0, -1.0, -3.0};
        StreamingStatistics sampleStats1 = new StreamingStatistics();
        for (int i = 0; i < sample1.length; ++i) {
            sampleStats1.addValue(sample1[i]);
        }
        StreamingStatistics sampleStats2 = new StreamingStatistics();
        for (int i = 0; i < sample2.length; ++i) {
            sampleStats2.addValue(sample2[i]);
        }
        Assert.assertEquals((String)"two sample heteroscedastic t stat", (double)1.60371728768, (double)InferenceTestUtils.t((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic t stat", (double)1.60371728768, (double)InferenceTestUtils.t((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic p value", (double)0.128839369622, (double)InferenceTestUtils.tTest((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic p value", (double)0.128839369622, (double)InferenceTestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertTrue((String)"two sample heteroscedastic t-test reject", (boolean)InferenceTestUtils.tTest((double[])sample1, (double[])sample2, (double)0.2));
        Assert.assertTrue((String)"two sample heteroscedastic t-test reject", (boolean)InferenceTestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, (double)0.2));
        Assert.assertTrue((String)"two sample heteroscedastic t-test accept", (!InferenceTestUtils.tTest((double[])sample1, (double[])sample2, (double)0.1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"two sample heteroscedastic t-test accept", (!InferenceTestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, (double)0.1) ? 1 : 0) != 0);
        try {
            InferenceTestUtils.tTest((double[])sample1, (double[])sample2, (double)0.95);
            Assert.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, (double)0.95);
            Assert.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.tTest((double[])sample1, (double[])this.tooShortObs, (double)0.01);
            Assert.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)((StreamingStatistics)null), (double)0.01);
            Assert.fail((String)"insufficient data, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.tTest((double[])sample1, (double[])this.tooShortObs);
            Assert.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)((StreamingStatistics)null));
            Assert.fail((String)"insufficient data, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.t((double[])sample1, (double[])this.tooShortObs);
            Assert.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            InferenceTestUtils.t((StatisticalSummary)sampleStats1, (StatisticalSummary)((StreamingStatistics)null));
            Assert.fail((String)"insufficient data, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoSampleTHomoscedastic() {
        double[] sample1 = new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 97.0};
        double[] sample2 = new double[]{4.0, 6.0, 8.0, 10.0, 16.0};
        StreamingStatistics sampleStats1 = new StreamingStatistics();
        for (int i = 0; i < sample1.length; ++i) {
            sampleStats1.addValue(sample1[i]);
        }
        StreamingStatistics sampleStats2 = new StreamingStatistics();
        for (int i = 0; i < sample2.length; ++i) {
            sampleStats2.addValue(sample2[i]);
        }
        Assert.assertEquals((String)"two sample homoscedastic t stat", (double)0.73096310086, (double)InferenceTestUtils.homoscedasticT((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample homoscedastic p value", (double)0.4833963785, (double)InferenceTestUtils.homoscedasticTTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertTrue((String)"two sample homoscedastic t-test reject", (boolean)InferenceTestUtils.homoscedasticTTest((double[])sample1, (double[])sample2, (double)0.49));
        Assert.assertTrue((String)"two sample homoscedastic t-test accept", (!InferenceTestUtils.homoscedasticTTest((double[])sample1, (double[])sample2, (double)0.48) ? 1 : 0) != 0);
    }

    @Test
    public void testSmallSamples() {
        double[] sample1 = new double[]{1.0, 3.0};
        double[] sample2 = new double[]{4.0, 5.0};
        Assert.assertEquals((double)-2.2360679775, (double)InferenceTestUtils.t((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((double)0.198727388935, (double)InferenceTestUtils.tTest((double[])sample1, (double[])sample2), (double)1.0E-10);
    }

    @Test
    public void testPaired() {
        double[] sample1 = new double[]{1.0, 3.0, 5.0, 7.0};
        double[] sample2 = new double[]{0.0, 6.0, 11.0, 2.0};
        double[] sample3 = new double[]{5.0, 7.0, 8.0, 10.0};
        Assert.assertEquals((double)-0.3133, (double)InferenceTestUtils.pairedT((double[])sample1, (double[])sample2), (double)1.0E-4);
        Assert.assertEquals((double)0.774544295819, (double)InferenceTestUtils.pairedTTest((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((double)0.001208, (double)InferenceTestUtils.pairedTTest((double[])sample1, (double[])sample3), (double)1.0E-6);
        Assert.assertFalse((boolean)InferenceTestUtils.pairedTTest((double[])sample1, (double[])sample3, (double)0.001));
        Assert.assertTrue((boolean)InferenceTestUtils.pairedTTest((double[])sample1, (double[])sample3, (double)0.002));
    }

    @Test
    public void testOneWayAnovaUtils() {
        this.classes.add(this.classA);
        this.classes.add(this.classB);
        this.classes.add(this.classC);
        Assert.assertEquals((double)this.oneWayAnova.anovaFValue(this.classes), (double)InferenceTestUtils.oneWayAnovaFValue(this.classes), (double)1.0E-11);
        Assert.assertEquals((double)this.oneWayAnova.anovaPValue(this.classes), (double)InferenceTestUtils.oneWayAnovaPValue(this.classes), (double)1.0E-11);
        Assert.assertEquals((Object)this.oneWayAnova.anovaTest(this.classes, 0.01), (Object)InferenceTestUtils.oneWayAnovaTest(this.classes, (double)0.01));
    }

    @Test
    public void testGTestGoodnesOfFit() throws Exception {
        double[] exp = new double[]{0.54, 0.4, 0.05, 0.01};
        long[] obs = new long[]{70L, 79L, 3L, 4L};
        Assert.assertEquals((String)"G test statistic", (double)13.144799, (double)InferenceTestUtils.g((double[])exp, (long[])obs), (double)1.0E-5);
        double p_gtgf = InferenceTestUtils.gTest((double[])exp, (long[])obs);
        Assert.assertEquals((String)"g-Test p-value", (double)0.004333, (double)p_gtgf, (double)1.0E-5);
        Assert.assertTrue((boolean)InferenceTestUtils.gTest((double[])exp, (long[])obs, (double)0.05));
    }

    @Test
    public void testGTestIndependance() throws Exception {
        long[] obs1 = new long[]{268L, 199L, 42L};
        long[] obs2 = new long[]{807L, 759L, 184L};
        double g = InferenceTestUtils.gDataSetsComparison((long[])obs1, (long[])obs2);
        Assert.assertEquals((String)"G test statistic", (double)7.300817, (double)g, (double)1.0E-4);
        double p_gti = InferenceTestUtils.gTestDataSetsComparison((long[])obs1, (long[])obs2);
        Assert.assertEquals((String)"g-Test p-value", (double)0.0259805, (double)p_gti, (double)1.0E-4);
        Assert.assertTrue((boolean)InferenceTestUtils.gTestDataSetsComparison((long[])obs1, (long[])obs2, (double)0.05));
    }

    @Test
    public void testRootLogLikelihood() {
        Assert.assertTrue((InferenceTestUtils.rootLogLikelihoodRatio((long)904L, (long)21060L, (long)1144L, (long)283012L) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((InferenceTestUtils.rootLogLikelihoodRatio((long)36L, (long)21928L, (long)60280L, (long)623876L) < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)FastMath.sqrt((double)2.772589), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)1L, (long)0L, (long)0L, (long)1L), (double)1.0E-6);
        Assert.assertEquals((double)(-FastMath.sqrt((double)2.772589)), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)0L, (long)1L, (long)1L, (long)0L), (double)1.0E-6);
        Assert.assertEquals((double)FastMath.sqrt((double)27.72589), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)10L, (long)0L, (long)0L, (long)10L), (double)1.0E-5);
        Assert.assertEquals((double)FastMath.sqrt((double)39.33052), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)5L, (long)1995L, (long)0L, (long)100000L), (double)1.0E-5);
        Assert.assertEquals((double)(-FastMath.sqrt((double)39.33052)), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)0L, (long)100000L, (long)5L, (long)1995L), (double)1.0E-5);
        Assert.assertEquals((double)FastMath.sqrt((double)4730.737), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)1000L, (long)1995L, (long)1000L, (long)100000L), (double)0.001);
        Assert.assertEquals((double)(-FastMath.sqrt((double)4730.737)), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)1000L, (long)100000L, (long)1000L, (long)1995L), (double)0.001);
        Assert.assertEquals((double)FastMath.sqrt((double)5734.343), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)1000L, (long)1000L, (long)1000L, (long)100000L), (double)0.001);
        Assert.assertEquals((double)FastMath.sqrt((double)5714.932), (double)InferenceTestUtils.rootLogLikelihoodRatio((long)1000L, (long)1000L, (long)1000L, (long)99000L), (double)0.001);
    }

    @Test
    public void testKSOneSample() throws Exception {
        NormalDistribution unitNormal = new NormalDistribution(0.0, 1.0);
        double[] sample = KolmogorovSmirnovTestTest.gaussian;
        double tol = 1.0E-9;
        Assert.assertEquals((double)0.3172069207622391, (double)InferenceTestUtils.kolmogorovSmirnovTest((RealDistribution)unitNormal, (double[])sample), (double)1.0E-9);
        Assert.assertEquals((double)0.0932947561266756, (double)InferenceTestUtils.kolmogorovSmirnovStatistic((RealDistribution)unitNormal, (double[])sample), (double)1.0E-9);
    }

    @Test
    public void testKSTwoSample() throws Exception {
        double tol = 1.0E-9;
        double[] smallSample1 = new double[]{6.0, 7.0, 9.0, 13.0, 19.0, 21.0, 22.0, 23.0, 24.0};
        double[] smallSample2 = new double[]{10.0, 11.0, 12.0, 16.0, 20.0, 27.0, 28.0, 32.0, 44.0, 54.0};
        Assert.assertEquals((double)0.105577085453247, (double)InferenceTestUtils.kolmogorovSmirnovTest((double[])smallSample1, (double[])smallSample2, (boolean)false), (double)1.0E-9);
        double d = InferenceTestUtils.kolmogorovSmirnovStatistic((double[])smallSample1, (double[])smallSample2);
        Assert.assertEquals((double)0.5, (double)d, (double)1.0E-9);
        Assert.assertEquals((double)0.105577085453247, (double)InferenceTestUtils.exactP((double)d, (int)smallSample1.length, (int)smallSample2.length, (boolean)false), (double)1.0E-9);
    }
}

