/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.inference.MannWhitneyUTest;
import org.junit.Assert;
import org.junit.Test;

public class MannWhitneyUTestTest {
    protected MannWhitneyUTest testStatistic = new MannWhitneyUTest();

    @Test
    public void testMannWhitneyUSimple() {
        double[] x = new double[]{19.0, 22.0, 16.0, 29.0, 24.0};
        double[] y = new double[]{20.0, 11.0, 17.0, 12.0};
        Assert.assertEquals((double)3.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.11134688653, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-5);
        Assert.assertEquals((double)0.11111111111, (double)this.testStatistic.mannWhitneyUTest(x, y, true), (double)1.0E-5);
    }

    @Test
    public void testDisjoint() {
        double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] y = new double[]{6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        Assert.assertEquals((double)0.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.0081131172656, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-5);
        Assert.assertEquals((double)0.004329004329, (double)this.testStatistic.mannWhitneyUTest(x, y, true), (double)1.0E-5);
    }

    @Test
    public void testMannWhitneyUInputValidation() {
        try {
            this.testStatistic.mannWhitneyUTest(new double[0], new double[]{1.0});
            Assert.fail((String)"x does not contain samples (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(new double[]{1.0}, new double[0]);
            Assert.fail((String)"y does not contain samples (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(null, null);
            Assert.fail((String)"x and y is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(null, null);
            Assert.fail((String)"x and y is null (asymptotic), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(null, new double[]{1.0});
            Assert.fail((String)"x is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(new double[]{1.0}, null);
            Assert.fail((String)"y is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLargeDatasetExact() {
        double[] x = new double[]{11.0, 22.0, 19.0, 22.3, 16.0, 29.0, 24.0, 5.2, 7.0, 3.0, 44.0, 72.0, 43.0, 18.0, 65.0};
        double[] y = new double[]{15.0, 32.0, 38.0, 5.0, 6.0, 29.1, 31.0, 73.0, 88.0, 70.0, 50.0, 60.0, 93.0, 112.0, 190.0};
        Assert.assertEquals((double)59.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.027925057353, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-9);
        Assert.assertEquals((double)0.02635404434, (double)this.testStatistic.mannWhitneyUTest(x, y, true), (double)1.0E-9);
        Assert.assertEquals((double)0.02635404434, (double)this.testStatistic.mannWhitneyUTest(x, y), (double)1.0E-9);
    }

    @Test
    public void testDatasetTooLargeForExact() {
        double[] x = new double[]{11.0, 22.0, 19.0, 22.3, 16.0, 29.0, 24.0, 5.2, 7.0, 3.0, 44.0, 72.0, 43.0, 18.0, 65.0, 69.0, 71.0, 115.0, 117.0, 119.0, 121.0, 123.0, 124.0, 125.0, 126.0, 127.0};
        double[] y = new double[]{15.0, 32.0, 38.0, 5.0, 6.0, 29.1, 31.0, 73.0, 88.0, 70.0, 50.0, 60.0, 93.0, 112.0, 190.0, 200.0, 201.0, 202.0, 203.0, 204.0, 205.0, 207.0, 209.0, 210.0, 212.0};
        Assert.assertEquals((double)204.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.023177956065, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-9);
        Assert.assertEquals((double)0.023177956065, (double)this.testStatistic.mannWhitneyUTest(x, y), (double)1.0E-9);
        Assert.assertEquals((double)0.022259264963, (double)this.testStatistic.mannWhitneyUTest(x, y, true), (double)1.0E-9);
    }

    @Test
    public void testExactHiP() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0};
        double[] y = new double[]{1.0, 3.0, 5.0, 7.0, 9.0, 11.0, 13.0, 15.0, 17.0, 19.0};
        Assert.assertEquals((double)45.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.7337299957, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-9);
        Assert.assertEquals((double)0.73936435082, (double)this.testStatistic.mannWhitneyUTest(x, y, true), (double)1.0E-9);
    }

    @Test
    public void testExactLarge() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 46.0, 48.0, 50.0, 52.0, 54.0, 56.0, 58.0, 60.0};
        double[] y = new double[]{1.0, 3.0, 5.0, 7.0, 9.0, 11.0, 13.0, 15.0, 17.0, 19.0, 21.0, 23.0, 25.0, 27.0, 29.0, 31.0, 33.0, 35.0, 37.0, 39.0, 43.0, 45.0, 49.0, 51.0, 55.0, 61.0, 63.0, 65.0, 67.0, 69.0};
        Assert.assertEquals((double)441.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.73459710599, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-9);
        Assert.assertEquals((double)0.73642668965, (double)this.testStatistic.mannWhitneyUTest(x, y, true), (double)1.0E-9);
    }

    @Test
    public void testExactVerySmall() {
        double[] x = new double[]{1.0, 2.0};
        double[] y = new double[]{1.5, 2.5};
        Assert.assertEquals((double)1.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.66666666667, (double)this.testStatistic.mannWhitneyUTest(x, y, true), (double)1.0E-9);
        Assert.assertEquals((double)0.6985353583, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-9);
    }

    @Test
    public void testExactDegenerate() {
        double[] x = new double[]{1.0};
        double[] y = new double[]{1.5};
        Assert.assertEquals((double)0.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)this.testStatistic.mannWhitneyUTest(x, y, true), (double)1.0E-9);
        Assert.assertEquals((double)1.0, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-9);
    }

    @Test
    public void testApproximateWithTies() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0};
        double[] y = new double[]{1.0, 3.0, 5.0, 7.0, 8.0, 10.0, 10.0, 13.0, 15.0, 17.0, 19.0};
        try {
            this.testStatistic.mannWhitneyUTest(x, y, true);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((double)50.5, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.77784391371, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-9);
    }

    @Test
    public void testApproximateWithTies2() {
        double[] x = new double[]{2.0, 3.0, 7.0, 11.0, 23.0, 45.0, 48.0, 55.0, 70.0, 81.0, 92.0, 95.0, 97.0, 100.0, 110.0, 123.0, 125.0};
        double[] y = new double[]{3.5, 4.0, 8.0, 12.0, 25.0, 46.0, 49.0, 56.0, 70.0, 81.0, 92.0, 95.0, 97.0, 97.0, 100.0, 112.0, 125.0, 127.0};
        try {
            this.testStatistic.mannWhitneyUTest(x, y, true);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((double)142.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.72874565042, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-9);
    }

    @Test
    public void testIdenticalArrays() {
        double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        try {
            this.testStatistic.mannWhitneyUTest(x, y, true);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((double)50.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)this.testStatistic.mannWhitneyUTest(x, y, false), (double)1.0E-10);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testExactThrowsOnTies() {
        double[] x = new double[]{1.0, 5.0, 7.0};
        double[] y = new double[]{2.0, 3.0, 1.0};
        this.testStatistic.mannWhitneyUTest(x, y, true);
    }

    @Test
    public void testBigDataSet() {
        double[] d1 = new double[1500];
        double[] d2 = new double[1500];
        for (int i = 0; i < 1500; ++i) {
            d1[i] = 2 * i;
            d2[i] = 2 * i + 1;
        }
        double result = this.testStatistic.mannWhitneyUTest(d1, d2);
        Assert.assertTrue((result > 0.1 ? 1 : 0) != 0);
    }

    @Test
    public void testBigDataSetOverflow() {
        double[] d1 = new double[110000];
        double[] d2 = new double[110000];
        for (int i = 0; i < 110000; ++i) {
            d1[i] = i;
            d2[i] = i;
        }
        Assert.assertEquals((double)1.0, (double)this.testStatistic.mannWhitneyUTest(d1, d2, false), (double)1.0E-7);
    }
}

