/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.regression;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.stat.regression.AbstractMultipleLinearRegression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class MultipleLinearRegressionAbstractTest {
    protected AbstractMultipleLinearRegression regression;

    @Before
    public void setUp() {
        this.regression = this.createRegression();
    }

    protected abstract AbstractMultipleLinearRegression createRegression();

    protected abstract int getNumberOfRegressors();

    protected abstract int getSampleSize();

    @Test
    public void canEstimateRegressionParameters() {
        double[] beta = this.regression.estimateRegressionParameters();
        Assert.assertEquals((long)this.getNumberOfRegressors(), (long)beta.length);
    }

    @Test
    public void canEstimateResiduals() {
        double[] e = this.regression.estimateResiduals();
        Assert.assertEquals((long)this.getSampleSize(), (long)e.length);
    }

    @Test
    public void canEstimateRegressionParametersVariance() {
        double[][] variance = this.regression.estimateRegressionParametersVariance();
        Assert.assertEquals((long)this.getNumberOfRegressors(), (long)variance.length);
    }

    @Test
    public void canEstimateRegressandVariance() {
        if (this.getSampleSize() > this.getNumberOfRegressors()) {
            double variance = this.regression.estimateRegressandVariance();
            Assert.assertTrue((variance > 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNewSample() {
        double[] design = new double[]{1.0, 19.0, 22.0, 33.0, 2.0, 20.0, 30.0, 40.0, 3.0, 25.0, 35.0, 45.0, 4.0, 27.0, 37.0, 47.0};
        double[] y = new double[]{1.0, 2.0, 3.0, 4.0};
        double[][] x = new double[][]{{19.0, 22.0, 33.0}, {20.0, 30.0, 40.0}, {25.0, 35.0, 45.0}, {27.0, 37.0, 47.0}};
        AbstractMultipleLinearRegression regression = this.createRegression();
        regression.newSampleData(design, 4, 3);
        RealMatrix flatX = regression.getX().copy();
        RealVector flatY = regression.getY().copy();
        regression.newXSampleData((double[][])x);
        regression.newYSampleData(y);
        Assert.assertEquals((Object)flatX, (Object)regression.getX());
        Assert.assertEquals((Object)flatY, (Object)regression.getY());
        regression.setNoIntercept(true);
        regression.newSampleData(design, 4, 3);
        flatX = regression.getX().copy();
        flatY = regression.getY().copy();
        regression.newXSampleData((double[][])x);
        regression.newYSampleData(y);
        Assert.assertEquals((Object)flatX, (Object)regression.getX());
        Assert.assertEquals((Object)flatY, (Object)regression.getY());
    }

    @Test(expected=NullArgumentException.class)
    public void testNewSampleNullData() {
        double[] data = null;
        this.createRegression().newSampleData(data, 2, 3);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNewSampleInvalidData() {
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0};
        this.createRegression().newSampleData(data, 2, 3);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNewSampleInsufficientData() {
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0};
        this.createRegression().newSampleData(data, 1, 3);
    }

    @Test(expected=NullArgumentException.class)
    public void testXSampleDataNull() {
        this.createRegression().newXSampleData((double[][])null);
    }

    @Test(expected=NullArgumentException.class)
    public void testYSampleDataNull() {
        this.createRegression().newYSampleData(null);
    }
}

