/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.correlation;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.stat.correlation.PearsonsCorrelationTest;
import org.hipparchus.stat.correlation.SpearmansCorrelation;
import org.hipparchus.stat.ranking.NaNStrategy;
import org.hipparchus.stat.ranking.NaturalRanking;
import org.hipparchus.stat.ranking.RankingAlgorithm;
import org.junit.Assert;
import org.junit.Test;

public class SpearmansRankCorrelationTest
extends PearsonsCorrelationTest {
    @Override
    @Test
    public void testLongly() {
        RealMatrix matrix = this.createRealMatrix(this.longleyData, 16, 7);
        SpearmansCorrelation corrInstance = new SpearmansCorrelation(matrix);
        RealMatrix correlationMatrix = corrInstance.getCorrelationMatrix();
        double[] rData = new double[]{1.0, 0.982352941176471, 0.985294117647059, 0.564705882352941, 0.2264705882352941, 0.976470588235294, 0.976470588235294, 0.982352941176471, 1.0, 0.997058823529412, 0.664705882352941, 0.2205882352941176, 0.997058823529412, 0.997058823529412, 0.985294117647059, 0.997058823529412, 1.0, 0.638235294117647, 0.2235294117647059, 0.9941176470588236, 0.9941176470588236, 0.564705882352941, 0.664705882352941, 0.638235294117647, 1.0, -0.3411764705882353, 0.685294117647059, 0.685294117647059, 0.2264705882352941, 0.2205882352941176, 0.2235294117647059, -0.3411764705882353, 1.0, 0.2264705882352941, 0.2264705882352941, 0.976470588235294, 0.997058823529412, 0.9941176470588236, 0.685294117647059, 0.2264705882352941, 1.0, 1.0, 0.976470588235294, 0.997058823529412, 0.9941176470588236, 0.685294117647059, 0.2264705882352941, 1.0, 1.0};
        UnitTestUtils.assertEquals((String)"Spearman's correlation matrix", (RealMatrix)this.createRealMatrix(rData, 7, 7), (RealMatrix)correlationMatrix, (double)1.0E-14);
    }

    @Test
    public void testSwiss() {
        RealMatrix matrix = this.createRealMatrix(this.swissData, 47, 5);
        SpearmansCorrelation corrInstance = new SpearmansCorrelation(matrix);
        RealMatrix correlationMatrix = corrInstance.getCorrelationMatrix();
        double[] rData = new double[]{1.0, 0.2426642769364176, -0.660902996352354, -0.443257690360988, 0.4136455623012432, 0.2426642769364176, 1.0, -0.598859938748963, -0.650463814145816, 0.2886878090882852, -0.660902996352354, -0.598859938748963, 1.0, 0.674603831406147, -0.4750575257171745, -0.443257690360988, -0.650463814145816, 0.674603831406147, 1.0, -0.1444163088302244, 0.4136455623012432, 0.2886878090882852, -0.4750575257171745, -0.1444163088302244, 1.0};
        UnitTestUtils.assertEquals((String)"Spearman's correlation matrix", (RealMatrix)this.createRealMatrix(rData, 5, 5), (RealMatrix)correlationMatrix, (double)1.0E-14);
    }

    @Override
    @Test
    public void testConstant() {
        double[] noVariance = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0};
        Assert.assertTrue((boolean)Double.isNaN(new SpearmansCorrelation().correlation(noVariance, values)));
    }

    @Override
    @Test
    public void testInsufficientData() {
        double[] one = new double[]{1.0};
        double[] two = new double[]{2.0};
        try {
            new SpearmansCorrelation().correlation(one, two);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        BlockRealMatrix matrix = new BlockRealMatrix((double[][])new double[][]{{0.0}, {1.0}});
        try {
            new SpearmansCorrelation((RealMatrix)matrix);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testConsistency() {
        RealMatrix matrix = this.createRealMatrix(this.longleyData, 16, 7);
        SpearmansCorrelation corrInstance = new SpearmansCorrelation(matrix);
        double[][] data = matrix.getData();
        double[] x = matrix.getColumn(0);
        double[] y = matrix.getColumn(1);
        Assert.assertEquals((double)new SpearmansCorrelation().correlation(x, y), (double)corrInstance.getCorrelationMatrix().getEntry(0, 1), (double)Double.MIN_VALUE);
        UnitTestUtils.assertEquals((String)"Correlation matrix", (RealMatrix)corrInstance.getCorrelationMatrix(), (RealMatrix)new SpearmansCorrelation().computeCorrelationMatrix(data), (double)Double.MIN_VALUE);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMath891Array() {
        double[] xArray = new double[]{Double.NaN, 1.9, 2.0, 100.0, 3.0};
        double[] yArray = new double[]{10.0, 2.0, 10.0, Double.NaN, 4.0};
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.REMOVED);
        SpearmansCorrelation spearman = new SpearmansCorrelation((RankingAlgorithm)ranking);
        Assert.assertEquals((double)0.5, (double)spearman.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMath891Matrix() {
        double[] xArray = new double[]{Double.NaN, 1.9, 2.0, 100.0, 3.0};
        double[] yArray = new double[]{10.0, 2.0, 10.0, Double.NaN, 4.0};
        RealMatrix matrix = MatrixUtils.createRealMatrix((int)xArray.length, (int)2);
        for (int i = 0; i < xArray.length; ++i) {
            matrix.addToEntry(i, 0, xArray[i]);
            matrix.addToEntry(i, 1, yArray[i]);
        }
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.REMOVED);
        SpearmansCorrelation spearman = new SpearmansCorrelation(matrix, (RankingAlgorithm)ranking);
        Assert.assertEquals((double)0.5, (double)spearman.getCorrelationMatrix().getEntry(0, 1), (double)Double.MIN_VALUE);
    }

    @Override
    @Test
    public void testStdErrorConsistency() {
    }

    @Override
    @Test
    public void testCovarianceConsistency() {
    }
}

