/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.DoubleConsumer;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.UnivariateStatistic;
import org.hipparchus.stat.descriptive.moment.GeometricMean;
import org.hipparchus.stat.descriptive.moment.Kurtosis;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.Skewness;
import org.hipparchus.stat.descriptive.moment.Variance;
import org.hipparchus.stat.descriptive.rank.Max;
import org.hipparchus.stat.descriptive.rank.Min;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.hipparchus.stat.descriptive.summary.SumOfSquares;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.ResizableDoubleArray;

public class DescriptiveStatistics
implements StatisticalSummary,
DoubleConsumer,
Serializable {
    protected static final int INFINITE_WINDOW = -1;
    private static final long serialVersionUID = 20160411L;
    private static final UnivariateStatistic POPULATION_VARIANCE = new Variance(false);
    private final UnivariateStatistic maxImpl;
    private final UnivariateStatistic minImpl;
    private final UnivariateStatistic sumImpl;
    private final UnivariateStatistic sumOfSquaresImpl;
    private final UnivariateStatistic meanImpl;
    private final UnivariateStatistic varianceImpl;
    private final UnivariateStatistic geometricMeanImpl;
    private final UnivariateStatistic kurtosisImpl;
    private final UnivariateStatistic skewnessImpl;
    private final Percentile percentileImpl;
    private int windowSize;
    private final ResizableDoubleArray eDA;

    public DescriptiveStatistics() {
        this(-1);
    }

    public DescriptiveStatistics(int size) throws MathIllegalArgumentException {
        this(size, false, null);
    }

    public DescriptiveStatistics(double[] initialDoubleArray) {
        this(-1, true, initialDoubleArray);
    }

    protected DescriptiveStatistics(DescriptiveStatistics original) {
        MathUtils.checkNotNull((Object)original);
        this.windowSize = original.windowSize;
        this.eDA = original.eDA.copy();
        this.maxImpl = original.maxImpl.copy();
        this.minImpl = original.minImpl.copy();
        this.meanImpl = original.meanImpl.copy();
        this.sumImpl = original.sumImpl.copy();
        this.sumOfSquaresImpl = original.sumOfSquaresImpl.copy();
        this.varianceImpl = original.varianceImpl.copy();
        this.geometricMeanImpl = original.geometricMeanImpl.copy();
        this.kurtosisImpl = original.kurtosisImpl.copy();
        this.skewnessImpl = original.skewnessImpl.copy();
        this.percentileImpl = original.percentileImpl.copy();
    }

    DescriptiveStatistics(int windowSize, boolean hasInitialValues, double[] initialValues) {
        if (windowSize < 1 && windowSize != -1) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NOT_POSITIVE_WINDOW_SIZE, new Object[]{windowSize});
        }
        if (hasInitialValues) {
            MathUtils.checkNotNull((Object)initialValues, (Localizable)LocalizedCoreFormats.INPUT_ARRAY, (Object[])new Object[0]);
        }
        this.windowSize = windowSize;
        int initialCapacity = this.windowSize < 0 ? 100 : this.windowSize;
        this.eDA = hasInitialValues ? new ResizableDoubleArray(initialValues) : new ResizableDoubleArray(initialCapacity);
        this.maxImpl = new Max();
        this.minImpl = new Min();
        this.sumImpl = new Sum();
        this.sumOfSquaresImpl = new SumOfSquares();
        this.meanImpl = new Mean();
        this.varianceImpl = new Variance();
        this.geometricMeanImpl = new GeometricMean();
        this.kurtosisImpl = new Kurtosis();
        this.skewnessImpl = new Skewness();
        this.percentileImpl = new Percentile();
    }

    public DescriptiveStatistics copy() {
        return new DescriptiveStatistics(this);
    }

    public void addValue(double v) {
        if (this.windowSize != -1) {
            if (this.getN() == (long)this.windowSize) {
                this.eDA.addElementRolling(v);
            } else if (this.getN() < (long)this.windowSize) {
                this.eDA.addElement(v);
            }
        } else {
            this.eDA.addElement(v);
        }
    }

    @Override
    public void accept(double v) {
        this.addValue(v);
    }

    public void clear() {
        this.eDA.clear();
    }

    public void removeMostRecentValue() throws MathIllegalStateException {
        try {
            this.eDA.discardMostRecentElements(1);
        }
        catch (MathIllegalArgumentException ex) {
            throw new MathIllegalStateException((Throwable)ex, (Localizable)LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
    }

    public double replaceMostRecentValue(double v) throws MathIllegalStateException {
        return this.eDA.substituteMostRecentElement(v);
    }

    public double apply(UnivariateStatistic stat) {
        return this.eDA.compute((MathArrays.Function)stat);
    }

    @Override
    public double getMean() {
        return this.apply(this.meanImpl);
    }

    public double getGeometricMean() {
        return this.apply(this.geometricMeanImpl);
    }

    @Override
    public double getStandardDeviation() {
        double stdDev = Double.NaN;
        if (this.getN() > 0L) {
            stdDev = this.getN() > 1L ? FastMath.sqrt((double)this.getVariance()) : 0.0;
        }
        return stdDev;
    }

    public double getQuadraticMean() {
        long n = this.getN();
        return n > 0L ? FastMath.sqrt((double)(this.getSumOfSquares() / (double)n)) : Double.NaN;
    }

    @Override
    public double getVariance() {
        return this.apply(this.varianceImpl);
    }

    public double getPopulationVariance() {
        return this.apply(POPULATION_VARIANCE);
    }

    public double getSkewness() {
        return this.apply(this.skewnessImpl);
    }

    public double getKurtosis() {
        return this.apply(this.kurtosisImpl);
    }

    @Override
    public double getMax() {
        return this.apply(this.maxImpl);
    }

    @Override
    public double getMin() {
        return this.apply(this.minImpl);
    }

    @Override
    public double getSum() {
        return this.apply(this.sumImpl);
    }

    public double getSumOfSquares() {
        return this.apply(this.sumOfSquaresImpl);
    }

    public double getPercentile(double p) throws MathIllegalArgumentException {
        this.percentileImpl.setQuantile(p);
        return this.apply(this.percentileImpl);
    }

    @Override
    public long getN() {
        return this.eDA.getNumElements();
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) throws MathIllegalArgumentException {
        if (windowSize < 1 && windowSize != -1) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NOT_POSITIVE_WINDOW_SIZE, new Object[]{windowSize});
        }
        this.windowSize = windowSize;
        if (windowSize != -1 && windowSize < this.eDA.getNumElements()) {
            this.eDA.discardFrontElements(this.eDA.getNumElements() - windowSize);
        }
    }

    public double[] getValues() {
        return this.eDA.getElements();
    }

    public double[] getSortedValues() {
        double[] sort = this.getValues();
        Arrays.sort(sort);
        return sort;
    }

    public double getElement(int index) {
        return this.eDA.getElement(index);
    }

    public String toString() {
        StringBuilder outBuffer = new StringBuilder(100);
        String endl = "\n";
        outBuffer.append("DescriptiveStatistics:").append("\n").append("n: ").append(this.getN()).append("\n").append("min: ").append(this.getMin()).append("\n").append("max: ").append(this.getMax()).append("\n").append("mean: ").append(this.getMean()).append("\n").append("std dev: ").append(this.getStandardDeviation()).append("\n");
        try {
            outBuffer.append("median: ").append(this.getPercentile(50.0)).append("\n");
        }
        catch (MathIllegalStateException ex) {
            outBuffer.append("median: unavailable").append("\n");
        }
        outBuffer.append("skewness: ").append(this.getSkewness()).append("\n").append("kurtosis: ").append(this.getKurtosis()).append("\n");
        return outBuffer.toString();
    }
}

