/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.stat.Frequency;
import org.hipparchus.stat.LongFrequency;
import org.junit.Assert;
import org.junit.Test;

public final class LongFrequencyTest {
    private static final long ONE_LONG = 1L;
    private static final long TWO_LONG = 2L;
    private static final long THREE_LONG = 3L;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final double TOLERANCE = 1.0E-14;

    @Test
    public void testCounts() {
        LongFrequency f = new LongFrequency();
        Assert.assertEquals((String)"total count", (long)0L, (long)f.getSumFreq());
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(1L));
        Assert.assertEquals((String)"one frequency count", (long)3L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((String)"two frequency count", (long)1L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((String)"three frequency count", (long)0L, (long)f.getCount((Comparable)Long.valueOf(3L)));
        Assert.assertEquals((String)"total count", (long)4L, (long)f.getSumFreq());
        Assert.assertEquals((String)"zero cumulative frequency", (long)0L, (long)f.getCumFreq((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((String)"one cumulative frequency", (long)3L, (long)f.getCumFreq((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((String)"two cumulative frequency", (long)4L, (long)f.getCumFreq((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((String)"five cumulative frequency", (long)4L, (long)f.getCumFreq((Comparable)Long.valueOf(5L)));
        f.clear();
        Assert.assertEquals((String)"total count", (long)0L, (long)f.getSumFreq());
    }

    @Test
    public void testPcts() {
        LongFrequency f = new LongFrequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        Assert.assertEquals((String)"one pct", (double)0.25, (double)f.getPct((Comparable)Long.valueOf(1L)), (double)1.0E-14);
        Assert.assertEquals((String)"two pct", (double)0.25, (double)f.getPct((Comparable)Long.valueOf(2L)), (double)1.0E-14);
        Assert.assertEquals((String)"three pct", (double)0.5, (double)f.getPct((Comparable)Long.valueOf(3L)), (double)1.0E-14);
        Assert.assertEquals((String)"five pct", (double)0.0, (double)f.getPct((Comparable)Long.valueOf(5L)), (double)1.0E-14);
        Assert.assertEquals((String)"one cum pct", (double)0.25, (double)f.getCumPct((Comparable)Long.valueOf(1L)), (double)1.0E-14);
        Assert.assertEquals((String)"two cum pct", (double)0.5, (double)f.getCumPct((Comparable)Long.valueOf(2L)), (double)1.0E-14);
        Assert.assertEquals((String)"three cum pct", (double)1.0, (double)f.getCumPct((Comparable)Long.valueOf(3L)), (double)1.0E-14);
        Assert.assertEquals((String)"five cum pct", (double)1.0, (double)f.getCumPct((Comparable)Long.valueOf(5L)), (double)1.0E-14);
        Assert.assertEquals((String)"zero cum pct", (double)0.0, (double)f.getCumPct((Comparable)Long.valueOf(0L)), (double)1.0E-14);
    }

    @Test
    public void testToString() throws Exception {
        LongFrequency f = new LongFrequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        String s = f.toString();
        Assert.assertNotNull((Object)s);
        BufferedReader reader = new BufferedReader(new StringReader(s));
        String line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNull((Object)line);
    }

    @Test
    public void testLongValues() {
        LongFrequency f = new LongFrequency();
        Integer obj1 = null;
        obj1 = 1;
        Integer int1 = 1;
        f.addValue(obj1.intValue());
        f.addValue(int1.intValue());
        f.addValue(2);
        f.addValue(Long.valueOf(2L).intValue());
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)f.getCount(1));
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)f.getCount(Integer.valueOf(1).intValue()));
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)f.getCount(Long.valueOf(1L).intValue()));
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)f.getCumPct(1), (double)1.0E-14);
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)f.getCumPct(Long.valueOf(1L).intValue()), (double)1.0E-14);
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)f.getCumPct(Integer.valueOf(1).intValue()), (double)1.0E-14);
        f.incrementValue(1, -2L);
        f.incrementValue(3, 5L);
        Assert.assertEquals((String)"Integer 1 count", (long)0L, (long)f.getCount(1));
        Assert.assertEquals((String)"Integer 3 count", (long)5L, (long)f.getCount(3));
        Iterator it = f.valuesIterator();
        while (it.hasNext()) {
            Assert.assertTrue((boolean)(it.next() instanceof Long));
        }
    }

    @Test
    public void testSerial() {
        LongFrequency f = new LongFrequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        Assert.assertEquals((Object)f, (Object)UnitTestUtils.serializeAndRecover((Object)f));
    }

    @Test
    public void testGetUniqueCount() {
        LongFrequency f = new LongFrequency();
        Assert.assertEquals((long)0L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assert.assertEquals((long)1L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assert.assertEquals((long)1L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(2L));
        Assert.assertEquals((long)2L, (long)f.getUniqueCount());
    }

    @Test
    public void testIncrement() {
        LongFrequency f = new LongFrequency();
        Assert.assertEquals((long)0L, (long)f.getUniqueCount());
        f.incrementValue((Comparable)Long.valueOf(1L), 1L);
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        f.incrementValue((Comparable)Long.valueOf(1L), 4L);
        Assert.assertEquals((long)5L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        f.incrementValue((Comparable)Long.valueOf(1L), -5L);
        Assert.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(1L)));
    }

    @Test
    public void testMerge() {
        LongFrequency f = new LongFrequency();
        Assert.assertEquals((long)0L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        Assert.assertEquals((long)2L, (long)f.getUniqueCount());
        Assert.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        LongFrequency g = new LongFrequency();
        g.addValue((Comparable)Long.valueOf(1L));
        g.addValue((Comparable)Long.valueOf(3L));
        g.addValue((Comparable)Long.valueOf(3L));
        Assert.assertEquals((long)2L, (long)g.getUniqueCount());
        Assert.assertEquals((long)1L, (long)g.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)2L, (long)g.getCount((Comparable)Long.valueOf(3L)));
        f.merge((Frequency)g);
        Assert.assertEquals((long)3L, (long)f.getUniqueCount());
        Assert.assertEquals((long)3L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(3L)));
    }

    @Test
    public void testMergeCollection() {
        LongFrequency f = new LongFrequency();
        Assert.assertEquals((long)0L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assert.assertEquals((long)1L, (long)f.getUniqueCount());
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        LongFrequency g = new LongFrequency();
        g.addValue((Comparable)Long.valueOf(2L));
        LongFrequency h = new LongFrequency();
        h.addValue((Comparable)Long.valueOf(3L));
        ArrayList<LongFrequency> coll = new ArrayList<LongFrequency>();
        coll.add(g);
        coll.add(h);
        f.merge(coll);
        Assert.assertEquals((long)3L, (long)f.getUniqueCount());
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(3L)));
    }

    @Test
    public void testMode() {
        LongFrequency f = new LongFrequency();
        List mode = f.getMode();
        Assert.assertEquals((long)0L, (long)mode.size());
        f.addValue((Comparable)Long.valueOf(3L));
        mode = f.getMode();
        Assert.assertEquals((long)1L, (long)mode.size());
        Assert.assertEquals((Object)3L, mode.get(0));
        f.addValue((Comparable)Long.valueOf(2L));
        mode = f.getMode();
        Assert.assertEquals((long)2L, (long)mode.size());
        Assert.assertEquals((Object)2L, mode.get(0));
        Assert.assertEquals((Object)3L, mode.get(1));
        f.addValue((Comparable)Long.valueOf(2L));
        mode = f.getMode();
        Assert.assertEquals((long)1L, (long)mode.size());
        Assert.assertEquals((Object)2L, mode.get(0));
        Assert.assertFalse((boolean)mode.contains(1L));
        Assert.assertTrue((boolean)mode.contains(2L));
    }
}

