/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.correlation;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.stat.LocalizedStatFormats;
import org.hipparchus.stat.correlation.PearsonsCorrelation;
import org.hipparchus.stat.ranking.NaNStrategy;
import org.hipparchus.stat.ranking.NaturalRanking;
import org.hipparchus.stat.ranking.RankingAlgorithm;
import org.hipparchus.util.MathArrays;

public class SpearmansCorrelation {
    private final RealMatrix data;
    private final RankingAlgorithm rankingAlgorithm;
    private final PearsonsCorrelation rankCorrelation;

    public SpearmansCorrelation() {
        this(new NaturalRanking());
    }

    public SpearmansCorrelation(RankingAlgorithm rankingAlgorithm) throws MathIllegalArgumentException {
        if (rankingAlgorithm instanceof NaturalRanking && NaNStrategy.REMOVED == ((NaturalRanking)rankingAlgorithm).getNanStrategy()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedStatFormats.NOT_SUPPORTED_NAN_STRATEGY, new Object[]{NaNStrategy.REMOVED});
        }
        this.data = null;
        this.rankingAlgorithm = rankingAlgorithm;
        this.rankCorrelation = null;
    }

    public SpearmansCorrelation(RealMatrix dataMatrix) {
        this(dataMatrix, new NaturalRanking());
    }

    public SpearmansCorrelation(RealMatrix dataMatrix, RankingAlgorithm rankingAlgorithm) throws MathIllegalArgumentException {
        if (rankingAlgorithm instanceof NaturalRanking && NaNStrategy.REMOVED == ((NaturalRanking)rankingAlgorithm).getNanStrategy()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedStatFormats.NOT_SUPPORTED_NAN_STRATEGY, new Object[]{NaNStrategy.REMOVED});
        }
        this.rankingAlgorithm = rankingAlgorithm;
        this.data = this.rankTransform(dataMatrix);
        this.rankCorrelation = new PearsonsCorrelation(this.data);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.rankCorrelation.getCorrelationMatrix();
    }

    public PearsonsCorrelation getRankCorrelation() {
        return this.rankCorrelation;
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix matrix) {
        RealMatrix matrixCopy = this.rankTransform(matrix);
        return new PearsonsCorrelation().computeCorrelationMatrix(matrixCopy);
    }

    public RealMatrix computeCorrelationMatrix(double[][] matrix) {
        return this.computeCorrelationMatrix((RealMatrix)new BlockRealMatrix(matrix));
    }

    public double correlation(double[] xArray, double[] yArray) {
        MathArrays.checkEqualLength((double[])xArray, (double[])yArray);
        if (xArray.length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INSUFFICIENT_DIMENSION, new Object[]{xArray.length, 2});
        }
        return new PearsonsCorrelation().correlation(this.rankingAlgorithm.rank(xArray), this.rankingAlgorithm.rank(yArray));
    }

    private RealMatrix rankTransform(RealMatrix matrix) {
        RealMatrix transformed = matrix.copy();
        for (int i = 0; i < transformed.getColumnDimension(); ++i) {
            transformed.setColumn(i, this.rankingAlgorithm.rank(transformed.getColumn(i)));
        }
        return transformed;
    }
}

