/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.moment.SecondMoment;

class ThirdMoment
extends SecondMoment
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    protected double m3;
    protected double nDevSq;

    ThirdMoment() {
        this.m3 = Double.NaN;
        this.nDevSq = Double.NaN;
    }

    ThirdMoment(ThirdMoment original) throws NullArgumentException {
        super(original);
        this.m3 = original.m3;
        this.nDevSq = original.nDevSq;
    }

    @Override
    public void increment(double d) {
        if (this.n < 1L) {
            this.m1 = 0.0;
            this.m2 = 0.0;
            this.m3 = 0.0;
        }
        double prevM2 = this.m2;
        super.increment(d);
        this.nDevSq = this.nDev * this.nDev;
        double n0 = this.n;
        this.m3 = this.m3 - 3.0 * this.nDev * prevM2 + (n0 - 1.0) * (n0 - 2.0) * this.nDevSq * this.dev;
    }

    @Override
    public double getResult() {
        return this.m3;
    }

    @Override
    public void clear() {
        super.clear();
        this.m3 = Double.NaN;
        this.nDevSq = Double.NaN;
    }

    @Override
    public void aggregate(SecondMoment other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ThirdMoment copy() {
        return new ThirdMoment(this);
    }
}

