/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.correlation;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.random.ISAACRandom;
import org.hipparchus.stat.correlation.StorelessBivariateCovariance;
import org.hipparchus.stat.correlation.StorelessCovariance;
import org.junit.Assert;
import org.junit.Test;

public class StorelessCovarianceTest {
    protected final double[] longleyData = new double[]{60323.0, 83.0, 234289.0, 2356.0, 1590.0, 107608.0, 1947.0, 61122.0, 88.5, 259426.0, 2325.0, 1456.0, 108632.0, 1948.0, 60171.0, 88.2, 258054.0, 3682.0, 1616.0, 109773.0, 1949.0, 61187.0, 89.5, 284599.0, 3351.0, 1650.0, 110929.0, 1950.0, 63221.0, 96.2, 328975.0, 2099.0, 3099.0, 112075.0, 1951.0, 63639.0, 98.1, 346999.0, 1932.0, 3594.0, 113270.0, 1952.0, 64989.0, 99.0, 365385.0, 1870.0, 3547.0, 115094.0, 1953.0, 63761.0, 100.0, 363112.0, 3578.0, 3350.0, 116219.0, 1954.0, 66019.0, 101.2, 397469.0, 2904.0, 3048.0, 117388.0, 1955.0, 67857.0, 104.6, 419180.0, 2822.0, 2857.0, 118734.0, 1956.0, 68169.0, 108.4, 442769.0, 2936.0, 2798.0, 120445.0, 1957.0, 66513.0, 110.8, 444546.0, 4681.0, 2637.0, 121950.0, 1958.0, 68655.0, 112.6, 482704.0, 3813.0, 2552.0, 123366.0, 1959.0, 69564.0, 114.2, 502601.0, 3931.0, 2514.0, 125368.0, 1960.0, 69331.0, 115.7, 518173.0, 4806.0, 2572.0, 127852.0, 1961.0, 70551.0, 116.9, 554894.0, 4007.0, 2827.0, 130081.0, 1962.0};
    protected final double[] swissData = new double[]{80.2, 17.0, 15.0, 12.0, 9.96, 83.1, 45.1, 6.0, 9.0, 84.84, 92.5, 39.7, 5.0, 5.0, 93.4, 85.8, 36.5, 12.0, 7.0, 33.77, 76.9, 43.5, 17.0, 15.0, 5.16, 76.1, 35.3, 9.0, 7.0, 90.57, 83.8, 70.2, 16.0, 7.0, 92.85, 92.4, 67.8, 14.0, 8.0, 97.16, 82.4, 53.3, 12.0, 7.0, 97.67, 82.9, 45.2, 16.0, 13.0, 91.38, 87.1, 64.5, 14.0, 6.0, 98.61, 64.1, 62.0, 21.0, 12.0, 8.52, 66.9, 67.5, 14.0, 7.0, 2.27, 68.9, 60.7, 19.0, 12.0, 4.43, 61.7, 69.3, 22.0, 5.0, 2.82, 68.3, 72.6, 18.0, 2.0, 24.2, 71.7, 34.0, 17.0, 8.0, 3.3, 55.7, 19.4, 26.0, 28.0, 12.11, 54.3, 15.2, 31.0, 20.0, 2.15, 65.1, 73.0, 19.0, 9.0, 2.84, 65.5, 59.8, 22.0, 10.0, 5.23, 65.0, 55.1, 14.0, 3.0, 4.52, 56.6, 50.9, 22.0, 12.0, 15.14, 57.4, 54.1, 20.0, 6.0, 4.2, 72.5, 71.2, 12.0, 1.0, 2.4, 74.2, 58.1, 14.0, 8.0, 5.23, 72.0, 63.5, 6.0, 3.0, 2.56, 60.5, 60.8, 16.0, 10.0, 7.72, 58.3, 26.8, 25.0, 19.0, 18.46, 65.4, 49.5, 15.0, 8.0, 6.1, 75.5, 85.9, 3.0, 2.0, 99.71, 69.3, 84.9, 7.0, 6.0, 99.68, 77.3, 89.7, 5.0, 2.0, 100.0, 70.5, 78.2, 12.0, 6.0, 98.96, 79.4, 64.9, 7.0, 3.0, 98.22, 65.0, 75.9, 9.0, 9.0, 99.06, 92.2, 84.6, 3.0, 3.0, 99.46, 79.3, 63.1, 13.0, 13.0, 96.83, 70.4, 38.4, 26.0, 12.0, 5.62, 65.7, 7.7, 29.0, 11.0, 13.79, 72.7, 16.7, 22.0, 13.0, 11.22, 64.4, 17.6, 35.0, 32.0, 16.92, 77.6, 37.6, 15.0, 7.0, 4.97, 67.6, 18.7, 25.0, 7.0, 8.65, 35.0, 1.2, 37.0, 53.0, 42.34, 44.7, 46.6, 16.0, 29.0, 50.43, 42.8, 27.7, 22.0, 29.0, 58.33};
    protected final double[][] longleyDataSimple = new double[][]{{60323.0, 83.0}, {61122.0, 88.5}, {60171.0, 88.2}, {61187.0, 89.5}, {63221.0, 96.2}, {63639.0, 98.1}, {64989.0, 99.0}, {63761.0, 100.0}, {66019.0, 101.2}, {67857.0, 104.6}, {68169.0, 108.4}, {66513.0, 110.8}, {68655.0, 112.6}, {69564.0, 114.2}, {69331.0, 115.7}, {70551.0, 116.9}};

    @Test
    public void testLonglySimpleVar() {
        double rCov = 1.2333921733333332E7;
        StorelessBivariateCovariance cov = new StorelessBivariateCovariance();
        for (int i = 0; i < this.longleyDataSimple.length; ++i) {
            cov.increment(this.longleyDataSimple[i][0], this.longleyDataSimple[i][0]);
        }
        UnitTestUtils.assertEquals((String)"simple covariance test", (double)rCov, (double)cov.getResult(), (double)1.0E-6);
    }

    @Test
    public void testLonglySimpleCov() {
        double rCov = 36796.66;
        StorelessBivariateCovariance cov = new StorelessBivariateCovariance();
        for (int i = 0; i < this.longleyDataSimple.length; ++i) {
            cov.increment(this.longleyDataSimple[i][0], this.longleyDataSimple[i][1]);
        }
        UnitTestUtils.assertEquals((String)"simple covariance test", (double)rCov, (double)cov.getResult(), (double)1.0E-6);
    }

    @Test
    public void testLonglyByRow() {
        RealMatrix matrix = this.createRealMatrix(this.longleyData, 16, 7);
        double[] rData = new double[]{1.2333921733333332E7, 36796.66, 3.433302063333333E8, 1649102.6666666667, 1117681.0666666667, 2.3461965733333334E7, 16240.933333333332, 36796.66, 116.457625, 1063604.115416667, 6258.66625, 3490.25375, 73503.0, 50.92333333333334, 3.433302063333333E8, 1063604.115416667, 9.879353659329166E9, 5.6124369854166664E7, 3.0880428345833335E7, 6.852409446E8, 470977.9, 1649102.6666666667, 6258.66625, 5.6124369854166664E7, 873223.4291666667, -115378.7625, 4462741.533333333, 2973.0333333333333, 1117681.0666666667, 3490.25375, 3.0880428345833335E7, -115378.7625, 484304.0958333333, 1764098.133333333, 1382.4333333333334, 2.3461965733333334E7, 73503.0, 6.852409446E8, 4462741.533333333, 1764098.1333333333, 4.838734893333333E7, 32917.4, 16240.93333333333, 50.92333333333334, 470977.9, 2973.033333333333, 1382.433333333333, 32917.4, 22.66666666666667};
        StorelessCovariance covMatrix = new StorelessCovariance(7);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            covMatrix.increment(matrix.getRow(i));
        }
        RealMatrix covarianceMatrix = covMatrix.getCovarianceMatrix();
        UnitTestUtils.assertEquals((String)"covariance matrix", (RealMatrix)this.createRealMatrix(rData, 7, 7), (RealMatrix)covarianceMatrix, (double)1.0E-6);
    }

    @Test
    public void testSwissFertilityByRow() {
        RealMatrix matrix = this.createRealMatrix(this.swissData, 47, 5);
        double[] rData = new double[]{156.0424976873265, 100.1691489361702, -64.36692876965772, -79.7295097132285, 241.5632030527289, 100.16914893617025, 515.7994172062905, -124.39283071230344, -139.6574005550416, 379.9043755781684, -64.3669287696577, -124.3928307123034, 63.64662349676226, 53.5758556891767, -190.5606105457909, -79.7295097132285, -139.6574005550416, 53.57585568917669, 92.4560592044403, -61.698829787234, 241.5632030527289, 379.9043755781684, -190.56061054579092, -61.698829787234, 1739.294537187789};
        StorelessCovariance covMatrix = new StorelessCovariance(5);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            covMatrix.increment(matrix.getRow(i));
        }
        RealMatrix covarianceMatrix = covMatrix.getCovarianceMatrix();
        UnitTestUtils.assertEquals((String)"covariance matrix", (RealMatrix)this.createRealMatrix(rData, 5, 5), (RealMatrix)covarianceMatrix, (double)1.0E-12);
    }

    @Test
    public void testSymmetry() {
        RealMatrix matrix = this.createRealMatrix(this.swissData, 47, 5);
        int dimension = 5;
        StorelessCovariance storelessCov = new StorelessCovariance(5);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            storelessCov.increment(matrix.getRow(i));
        }
        double[][] covMatrix = storelessCov.getData();
        for (int i = 0; i < 5; ++i) {
            for (int j = i; j < 5; ++j) {
                Assert.assertEquals((double)covMatrix[i][j], (double)covMatrix[j][i], (double)1.0E-8);
            }
        }
    }

    @Test
    public void testEquivalence() {
        int num_sets = 2;
        StorelessBivariateCovariance cov = new StorelessBivariateCovariance();
        StorelessBivariateCovariance chk = new StorelessBivariateCovariance();
        ISAACRandom rand = new ISAACRandom(10L);
        for (int s = 0; s < num_sets; ++s) {
            StorelessBivariateCovariance covs = new StorelessBivariateCovariance();
            for (int i = 0; i < 5; ++i) {
                double x = rand.nextDouble();
                double y = rand.nextDouble();
                covs.increment(x, y);
                cov.increment(x, y);
            }
            chk.append(covs);
        }
        UnitTestUtils.assertEquals((String)"covariance subset test", (double)chk.getResult(), (double)cov.getResult(), (double)1.0E-6);
    }

    protected RealMatrix createRealMatrix(double[] data, int nRows, int nCols) {
        double[][] matrixData = new double[nRows][nCols];
        int ptr = 0;
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(data, ptr, matrixData[i], 0, nCols);
            ptr += nCols;
        }
        return new Array2DRowRealMatrix(matrixData);
    }
}

