/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.ExponentialDistribution;
import org.hipparchus.distribution.continuous.GammaDistribution;
import org.hipparchus.distribution.continuous.LogNormalDistribution;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.MersenneTwister;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.Well19937c;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.rank.PSquarePercentile;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.hipparchus.stat.descriptive.rank.RandomPercentile;
import org.hipparchus.stat.inference.AlternativeHypothesis;
import org.hipparchus.stat.inference.BinomialTest;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class RandomPercentileTest
extends StorelessUnivariateStatisticAbstractTest {
    protected double tolerance = 1.0E-11;
    private final RandomGenerator randomGenerator = new Well19937c(1000);
    final int TINY = 10;
    final int SMALL = 50;
    final int NOMINAL = 100;
    final int MEDIUM = 500;
    final int STANDARD = 1000;
    final int BIG = 10000;
    final int VERY_BIG = 50000;
    final int LARGE = 1000000;
    final int VERY_LARGE = 10000000;

    public RandomPercentile getUnivariateStatistic() {
        return new RandomPercentile();
    }

    @Override
    public double expectedValue() {
        return this.median;
    }

    @Test
    public void testCopyConsistencyWithInitialMostElements() {
        RandomPercentile master = this.getUnivariateStatistic();
        StorelessUnivariateStatistic replica = null;
        long index = FastMath.round((double)(0.75 * (double)this.testArray.length));
        master.incrementAll(this.testArray, 0, (int)index);
        replica = master.copy();
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
        master.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        replica.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
    }

    @Test
    public void testCopyConsistencyWithInitialFirstFewElements() {
        RandomPercentile master = this.getUnivariateStatistic();
        StorelessUnivariateStatistic replica = null;
        long index = FastMath.round((double)(0.1 * (double)this.testArray.length));
        master.incrementAll(this.testArray, 0, (int)index);
        replica = master.copy();
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
        master.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        replica.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        Assert.assertTrue((boolean)master.equals(master));
        Assert.assertTrue((boolean)replica.equals(replica));
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
    }

    @Test
    public void testPercentileSmallSample() {
        double[] d = new double[]{1.0, 3.0, 2.0, 4.0};
        RandomPercentile randomPercentile = new RandomPercentile();
        randomPercentile.incrementAll(d);
        Percentile p = new Percentile(30.0);
        Assert.assertEquals((double)p.evaluate(d), (double)randomPercentile.getResult(30.0), (double)1.0E-5);
        p = new Percentile(25.0);
        Assert.assertEquals((double)p.evaluate(d), (double)randomPercentile.getResult(25.0), (double)1.0E-5);
        p = new Percentile(75.0);
        Assert.assertEquals((double)p.evaluate(d), (double)randomPercentile.getResult(75.0), (double)1.0E-5);
        p = new Percentile(50.0);
        Assert.assertEquals((double)p.evaluate(d), (double)randomPercentile.getResult(50.0), (double)1.0E-5);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNonPositiveEpsilon() {
        double[] d = new double[]{95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682};
        RandomPercentile p = new RandomPercentile(0.0);
        p.evaluate(d, 0, d.length);
    }

    @Test
    public void testNISTExample() {
        double[] d = new double[]{95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682};
        Assert.assertEquals((double)95.1981, (double)new RandomPercentile().evaluate(90.0, d), (double)1.0E-4);
        Assert.assertEquals((double)95.061, (double)new RandomPercentile().evaluate(0.0, d), (double)0.0);
        Assert.assertEquals((double)95.199, (double)new RandomPercentile().evaluate(100.0, d, 0, d.length), (double)0.0);
    }

    @Test
    public void test5() {
        RandomPercentile percentile = new RandomPercentile();
        Assert.assertEquals((double)this.percentile5, (double)percentile.evaluate(5.0, this.testArray), (double)1.0E-4);
    }

    @Test
    public void testSingleton() {
        RandomPercentile percentile = new RandomPercentile();
        double[] singletonArray = new double[]{1.0};
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray), (double)0.0);
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1), (double)0.0);
        percentile = new RandomPercentile();
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(5.0, singletonArray, 0, 1), (double)0.0);
        percentile = new RandomPercentile();
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(100.0, singletonArray, 0, 1), (double)0.0);
        percentile = new RandomPercentile();
        Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(100.0, singletonArray, 0, 0)));
    }

    @Test
    public void testSpecialValues() {
        RandomPercentile percentile = new RandomPercentile();
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN};
        Assert.assertEquals((double)2.0, (double)percentile.evaluate(specialValues), (double)0.0);
        specialValues = new double[]{Double.NEGATIVE_INFINITY, 1.0, 2.0, 3.0, Double.NaN, Double.POSITIVE_INFINITY};
        Assert.assertEquals((double)2.0, (double)percentile.evaluate(specialValues), (double)0.0);
        specialValues = new double[]{1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        Assert.assertTrue((boolean)Double.isInfinite(percentile.evaluate(specialValues)));
        specialValues = new double[]{1.0, 1.0, Double.NaN, Double.NaN};
        Assert.assertFalse((boolean)Double.isNaN(percentile.evaluate(specialValues)));
        specialValues = new double[]{1.0, 1.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        percentile = new RandomPercentile();
        Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(specialValues)));
    }

    @Test
    public void testBufferConsumeLevel0() throws Exception {
        int len = this.testArray.length;
        double[] sorted = Arrays.copyOf(this.testArray, len);
        Arrays.sort(sorted);
        BufferMock buffer = new BufferMock(len, 0, this.randomGenerator);
        for (int i = 0; i < len; ++i) {
            buffer.consume(this.testArray[i]);
        }
        UnitTestUtils.assertEquals((double[])sorted, (double[])buffer.getData(), (double)Double.MIN_VALUE);
        Assert.assertFalse((boolean)buffer.hasCapacity());
        Assert.assertEquals((double)StatUtils.min((double[])this.testArray), (double)buffer.min(), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)StatUtils.max((double[])this.testArray), (double)buffer.max(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testBufferSampling() throws Exception {
        BufferMock buffer = new BufferMock(10, 2, this.randomGenerator);
        for (int i = 0; i < 40; ++i) {
            buffer.consume(i);
        }
        Assert.assertFalse((boolean)buffer.hasCapacity());
        double[] data = buffer.getData();
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((data[i] < (double)(4 * (i + 1)) ? 1 : 0) != 0);
            Assert.assertTrue((data[i] >= (double)(4 * i) ? 1 : 0) != 0);
            Assert.assertEquals((long)(i + 1), (long)buffer.rankOf((i + 1) * 4));
            Assert.assertEquals((long)0L, (long)buffer.rankOf(-1.0));
            Assert.assertEquals((long)10L, (long)buffer.rankOf(100.0));
        }
    }

    @Test
    public void testBufferMergeWith() throws Exception {
        BufferMock buffer1 = new BufferMock(20, 0, this.randomGenerator);
        BufferMock buffer2 = new BufferMock(20, 0, this.randomGenerator);
        for (int i = 0; i < 20; ++i) {
            buffer1.consume(i);
            buffer2.consume(i + 20);
        }
        Assert.assertEquals((long)0L, (long)buffer1.getLevel());
        Assert.assertEquals((long)0L, (long)buffer2.getLevel());
        buffer1.mergeWith(buffer2.getInstance());
        Assert.assertEquals((long)1L, (long)buffer1.getLevel());
        Assert.assertFalse((boolean)buffer1.hasCapacity());
        Assert.assertEquals((long)1L, (long)buffer2.getLevel());
        Assert.assertTrue((boolean)buffer2.hasCapacity());
        double[] data = buffer1.getData();
        int nSmall = 0;
        for (double value : data) {
            Assert.assertTrue((value >= 0.0 && value < 40.0 ? 1 : 0) != 0);
            if (!(value < 20.0)) continue;
            ++nSmall;
        }
        BinomialTest bTest = new BinomialTest();
        Assert.assertFalse((boolean)bTest.binomialTest(20, nSmall, 0.5, AlternativeHypothesis.TWO_SIDED, 0.01));
        buffer1.checkSorted();
    }

    @Test
    public void testBufferMergeInto() throws Exception {
        int i;
        BufferMock buffer1 = new BufferMock(20, 0, this.randomGenerator);
        BufferMock buffer2 = new BufferMock(20, 2, this.randomGenerator);
        for (i = 0; i < 20; ++i) {
            buffer1.consume(i);
        }
        for (i = 0; i < 80; ++i) {
            buffer2.consume(i + 20);
        }
        Assert.assertFalse((boolean)buffer1.hasCapacity());
        Assert.assertFalse((boolean)buffer2.hasCapacity());
        buffer1.mergeInto(buffer2.getInstance());
        Assert.assertEquals((long)0L, (long)buffer1.getLevel());
        Assert.assertEquals((long)2L, (long)buffer2.getLevel());
        double[] data = buffer2.getData();
        int nSmall = 0;
        for (double value : data) {
            Assert.assertTrue((value >= 0.0 && value < 100.0 ? 1 : 0) != 0);
            if (!(value < 20.0)) continue;
            ++nSmall;
        }
        BinomialTest bTest = new BinomialTest();
        Assert.assertFalse((boolean)bTest.binomialTest(20, nSmall, 0.25, AlternativeHypothesis.TWO_SIDED, 0.01));
        buffer2.checkSorted();
    }

    @Test
    public void testArrayExample() {
        Assert.assertEquals((double)this.percentile95, (double)new RandomPercentile().evaluate(95.0, this.testArray), (double)this.getTolerance());
    }

    @Test
    public void testReduceSmallDataSet() {
        RandomDataGenerator random = new RandomDataGenerator(1000L);
        long n = 1000L;
        double[] combined = new double[10000];
        int i = 0;
        ArrayList<RandomPercentile> aggregates = new ArrayList<RandomPercentile>();
        for (int j = 0; j < 10; ++j) {
            RandomPercentile randomPercentile = new RandomPercentile();
            int k = 0;
            while ((long)k < 1000L) {
                double value = random.nextGaussian();
                randomPercentile.accept(value);
                combined[i++] = value;
                ++k;
            }
            aggregates.add(randomPercentile);
        }
        Percentile master = new Percentile();
        RandomPercentile randomMaster = new RandomPercentile();
        for (int l = 0; l < 5; ++l) {
            double percentile = l * 15 + 1;
            Assert.assertEquals((double)master.evaluate(combined, percentile), (double)randomMaster.reduce(percentile, aggregates), (double)Double.MIN_VALUE);
        }
    }

    @Test
    public void testReduceLargeDataSet() {
        RandomDataGenerator random = new RandomDataGenerator(1000L);
        long n = 1000000L;
        RandomDataGenerator randomGenerator = new RandomDataGenerator(1000L);
        RandomPercentile randomMaster = new RandomPercentile((RandomGenerator)randomGenerator);
        PSquarePercentile pSquare = new PSquarePercentile(1.0);
        ArrayList<RandomPercentile> aggregates = new ArrayList<RandomPercentile>();
        for (int j = 0; j < 5; ++j) {
            RandomPercentile randomPercentile = new RandomPercentile((RandomGenerator)randomGenerator);
            int k = 0;
            while ((long)k < 1000000L) {
                double value = random.nextGaussian();
                randomPercentile.accept(value);
                randomMaster.accept(value);
                pSquare.increment(value);
                ++k;
            }
            aggregates.add(randomPercentile);
        }
        for (int l = 0; l < 5; ++l) {
            double percentile = l * 13 + 1;
            Assert.assertEquals((String)("percentile = " + percentile), (double)randomMaster.getResult(percentile), (double)randomMaster.reduce(percentile, aggregates), (double)0.005);
        }
    }

    private Double[] randomTestData(int factor, int values) {
        Double[] test = new Double[values];
        for (int i = 0; i < test.length; ++i) {
            test[i] = Math.abs(this.randomGenerator.nextDouble() * (double)factor);
        }
        return test;
    }

    public void testAccept() {
        Double[] test;
        RandomPercentile randomPercentile = new RandomPercentile();
        Assert.assertTrue((boolean)Double.isNaN(randomPercentile.getResult()));
        for (Double value : test = this.randomTestData(100, 10000)) {
            randomPercentile.increment(value.doubleValue());
            Assert.assertTrue((randomPercentile.getResult() >= 0.0 ? 1 : 0) != 0);
        }
    }

    private void assertValues(Double a, Double b, double delta) {
        if (Double.isNaN(a)) {
            Assert.assertTrue((String)("" + b + " is not NaN."), (boolean)Double.isNaN(a));
        } else if (Double.isInfinite(a)) {
            Assert.assertTrue((boolean)a.equals(b));
        } else {
            double max = FastMath.max((double)a, (double)b);
            double percentage = FastMath.abs((double)(a - b)) / max;
            double deviation = delta;
            Assert.assertTrue((String)String.format("Deviated = %f and is beyond %f as a=%f,  b=%f", percentage, deviation, a, b), (percentage < deviation ? 1 : 0) != 0);
        }
    }

    private void checkQuantileError(double[] data, double value, double quantile, double tolerance, double referenceValue) {
        double n = data.length;
        int nLess = 0;
        for (double val : data) {
            if (!(val < value)) continue;
            ++nLess;
        }
        if (Double.isNaN(referenceValue)) {
            Assert.assertTrue((boolean)Double.isNaN(value));
        } else if (Double.isInfinite(value)) {
            Assert.assertTrue((value == referenceValue ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Quantile error exceeded: value returned = " + value + " Reference value = " + referenceValue + " quantile = " + quantile + " n = " + n + " error = " + (quantile - (double)nLess / n)), (FastMath.abs((double)(quantile - (double)nLess / n)) < tolerance ? 1 : 0) != 0);
        }
    }

    private void doCalculatePercentile(Double percentile, Number[] test) {
        this.doCalculatePercentile(percentile, test, Double.MAX_VALUE);
    }

    private void doCalculatePercentile(Double percentile, Number[] test, double delta) {
        RandomPercentile random = new RandomPercentile((RandomGenerator)new Well19937c(200));
        for (Number value : test) {
            random.increment(value.doubleValue());
        }
        Percentile p2 = new Percentile(percentile * 100.0);
        double[] dall = new double[test.length];
        for (int i = 0; i < test.length; ++i) {
            dall[i] = test[i].doubleValue();
        }
        Double referenceValue = p2.evaluate(dall);
        this.assertValues(random.getResult(percentile.doubleValue()), referenceValue, delta);
    }

    private void doCalculatePercentile(double percentile, double[] test, double delta) {
        RandomPercentile randomEstimated = new RandomPercentile((RandomGenerator)new Well19937c(200));
        for (double value : test) {
            randomEstimated.increment(value);
        }
        Percentile p2 = new Percentile(percentile < 1.0 ? percentile * 100.0 : percentile);
        Double referenceValue = p2.evaluate(test);
        if (test.length < 1000000) {
            this.assertValues(randomEstimated.getResult(percentile), referenceValue, delta);
        } else {
            this.checkQuantileError(test, randomEstimated.getResult(percentile), percentile / 100.0, delta, referenceValue);
        }
    }

    @Test
    public void testCannedDataSet() {
        Integer[] seedInput = new Integer[]{283, 285, 298, 304, 310, 31, 319, 32, 33, 339, 342, 348, 350, 354, 354, 357, 36, 36, 369, 37, 37, 375, 378, 383, 390, 396, 405, 408, 41, 414, 419, 416, 42, 420, 430, 430, 432, 444, 447, 447, 449, 45, 451, 456, 468, 470, 471, 474, 600, 695, 70, 83, 97, 109, 113, 128};
        Number[] input = new Integer[seedInput.length * 100];
        for (int i = 0; i < input.length; ++i) {
            input[i] = seedInput[i % seedInput.length] + i;
        }
        this.doCalculatePercentile(0.5, input);
        this.doCalculatePercentile(0.95, input);
    }

    @Test
    public void test99Percentile() {
        Number[] test = this.randomTestData(100, 10000);
        this.doCalculatePercentile(0.99, test);
    }

    @Test
    public void test90Percentile() {
        Number[] test = this.randomTestData(100, 10000);
        this.doCalculatePercentile(0.9, test);
    }

    @Test
    public void test20Percentile() {
        Number[] test = this.randomTestData(100, 100000);
        this.doCalculatePercentile(0.2, test);
    }

    @Test
    public void test5Percentile() {
        Number[] test = this.randomTestData(50, 990000);
        this.doCalculatePercentile(0.5, test);
    }

    @Test
    public void test99PercentileHighValues() {
        Number[] test = this.randomTestData(100000, 10000);
        this.doCalculatePercentile(0.99, test);
    }

    @Test
    public void test90PercentileHighValues() {
        Number[] test = this.randomTestData(100000, 100000);
        this.doCalculatePercentile(0.9, test);
    }

    @Test
    public void test20PercentileHighValues() {
        Number[] test = this.randomTestData(100000, 100000);
        this.doCalculatePercentile(0.2, test);
    }

    @Test
    public void test5PercentileHighValues() {
        Number[] test = this.randomTestData(100000, 100000);
        this.doCalculatePercentile(0.05, test);
    }

    @Test
    public void test0PercentileValuesWithFewerThan5Values() {
        double[] test = new double[]{1.0, 2.0, 3.0, 4.0};
        RandomPercentile p = new RandomPercentile();
        Assert.assertEquals((double)1.0, (double)p.evaluate(0.0, test), (double)0.0);
    }

    @Test
    public void testMaxValuesRetained() {
        Assert.assertEquals((long)546795L, (long)RandomPercentile.maxValuesRetained((double)1.0E-4));
        Assert.assertEquals((long)34727L, (long)RandomPercentile.maxValuesRetained((double)0.001));
        Assert.assertEquals((long)2064L, (long)RandomPercentile.maxValuesRetained((double)0.01));
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMaxValuesRetained0Epsilon() {
        RandomPercentile.maxValuesRetained((double)0.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMaxValuesRetained1Epsilon() {
        RandomPercentile.maxValuesRetained((double)1.0);
    }

    private void doDistributionTest(RealDistribution distribution) {
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        double[] data = randomDataGenerator.nextDeviates(distribution, 1000000);
        this.doCalculatePercentile(50.0, data, 5.0E-4);
        this.doCalculatePercentile(95.0, data, 5.0E-4);
        data = randomDataGenerator.nextDeviates(distribution, 50000);
        this.doCalculatePercentile(50.0, data, 1.0E-4);
        this.doCalculatePercentile(95.0, data, 1.0E-4);
        data = randomDataGenerator.nextDeviates(distribution, 10000);
        this.doCalculatePercentile(50.0, data, 1.0E-4);
        this.doCalculatePercentile(95.0, data, 1.0E-4);
        data = randomDataGenerator.nextDeviates(distribution, 1000);
        this.doCalculatePercentile(50.0, data, 1.0E-4);
        this.doCalculatePercentile(95.0, data, 1.0E-4);
        data = randomDataGenerator.nextDeviates(distribution, 500);
        this.doCalculatePercentile(50.0, data, 1.0E-4);
        this.doCalculatePercentile(95.0, data, 1.0E-4);
        data = randomDataGenerator.nextDeviates(distribution, 100);
        this.doCalculatePercentile(50.0, data, 1.0E-4);
        this.doCalculatePercentile(95.0, data, 1.0E-4);
        data = randomDataGenerator.nextDeviates(distribution, 50);
        this.doCalculatePercentile(50.0, data, 1.0E-4);
        this.doCalculatePercentile(95.0, data, 1.0E-4);
        data = randomDataGenerator.nextDeviates(distribution, 10);
        this.doCalculatePercentile(50.0, data, 1.0E-4);
        this.doCalculatePercentile(95.0, data, 1.0E-4);
    }

    @Test
    public void testDistribution() {
        this.doDistributionTest((RealDistribution)new NormalDistribution(4000.0, 50.0));
        this.doDistributionTest((RealDistribution)new LogNormalDistribution(4000.0, 50.0));
        this.doDistributionTest((RealDistribution)new ExponentialDistribution(4000.0));
        this.doDistributionTest((RealDistribution)new GammaDistribution(5.0, 1.0));
    }

    @Test
    public void testDistributionStreaming() {
        this.checkQuartiles((RealDistribution)new NormalDistribution(), 1000000, 5.0E-4);
        this.checkQuartiles((RealDistribution)new ExponentialDistribution(1.0), 600000, 5.0E-4);
        this.checkQuartiles((RealDistribution)new GammaDistribution(4.0, 2.0), 600000, 5.0E-4);
    }

    @Test
    public void testSequentialData() {
        long seed = 1000L;
        double epsilon = 1.0E-4;
        for (int j = 0; j < 3; ++j) {
            int i;
            RandomPercentile randomPercentile = new RandomPercentile(epsilon *= 10.0, (RandomGenerator)new MersenneTwister(1000L));
            int n = 5000000;
            for (i = 1; i <= 5000000; ++i) {
                randomPercentile.accept((double)i);
            }
            for (i = 1; i < 5; ++i) {
                Assert.assertEquals((double)(0.2 * (double)i), (double)(randomPercentile.getResult((double)(i * 20)) / 5000000.0), (double)(2.0 * epsilon));
            }
        }
    }

    private void checkQuartiles(RealDistribution dist, int sampleSize, double tolerance) {
        long seed = 1000L;
        RandomDataGenerator randomDataGenerator = RandomDataGenerator.of((RandomGenerator)new MersenneTwister(1000L));
        RandomPercentile randomPercentile = new RandomPercentile(1.0E-4, this.randomGenerator);
        for (int i = 0; i < sampleSize; ++i) {
            randomPercentile.increment(randomDataGenerator.nextDeviate(dist));
        }
        double q1 = randomPercentile.getResult(25.0);
        double q2 = randomPercentile.getResult();
        double q3 = randomPercentile.getResult(75.0);
        randomDataGenerator.setSeed(1000L);
        double ct1 = 0.0;
        double ct2 = 0.0;
        double ct3 = 0.0;
        for (int i = 0; i < sampleSize; ++i) {
            double v = randomDataGenerator.nextDeviate(dist);
            if (v < q1) {
                ct1 += 1.0;
                ct2 += 1.0;
                ct3 += 1.0;
                continue;
            }
            if (v < q2) {
                ct2 += 1.0;
                ct3 += 1.0;
                continue;
            }
            if (!(v < q3)) continue;
            ct3 += 1.0;
        }
        Assert.assertEquals((double)0.25, (double)(ct1 / (double)sampleSize), (double)tolerance);
        Assert.assertEquals((double)0.5, (double)(ct2 / (double)sampleSize), (double)tolerance);
        Assert.assertEquals((double)0.75, (double)(ct3 / (double)sampleSize), (double)tolerance);
    }

    static class BufferMock {
        private Object instance;
        private Method consumeMethod;
        private Method getDataMethod;
        private Method hasCapacityMethod;
        private Method minMethod;
        private Method maxMethod;
        private Method rankOfMethod;
        private Method getLevelMethod;
        private Method mergeWithMethod;
        private Method mergeIntoMethod;

        public BufferMock(int size, int level, RandomGenerator randomGenerator) throws Exception {
            Class<?>[] classes;
            for (Class<?> cls : classes = RandomPercentile.class.getDeclaredClasses()) {
                if (!cls.getName().endsWith("$Buffer")) continue;
                Constructor<?> constructor = cls.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, RandomGenerator.class);
                this.instance = constructor.newInstance(size, level, randomGenerator);
                this.consumeMethod = cls.getDeclaredMethod("consume", Double.TYPE);
                this.getDataMethod = cls.getDeclaredMethod("getData", new Class[0]);
                this.hasCapacityMethod = cls.getDeclaredMethod("hasCapacity", new Class[0]);
                this.minMethod = cls.getDeclaredMethod("min", new Class[0]);
                this.maxMethod = cls.getDeclaredMethod("max", new Class[0]);
                this.rankOfMethod = cls.getDeclaredMethod("rankOf", Double.TYPE);
                this.getLevelMethod = cls.getDeclaredMethod("getLevel", new Class[0]);
                this.mergeWithMethod = cls.getDeclaredMethod("mergeWith", cls);
                this.mergeIntoMethod = cls.getDeclaredMethod("mergeInto", cls);
            }
        }

        public void consume(double value) throws Exception {
            this.consumeMethod.invoke(this.instance, value);
        }

        public boolean hasCapacity() throws Exception {
            return (Boolean)this.hasCapacityMethod.invoke(this.instance, new Object[0]);
        }

        public double[] getData() throws Exception {
            return (double[])this.getDataMethod.invoke(this.instance, new Object[0]);
        }

        public double min() throws Exception {
            return (Double)this.minMethod.invoke(this.instance, new Object[0]);
        }

        public double max() throws Exception {
            return (Double)this.maxMethod.invoke(this.instance, new Object[0]);
        }

        public int rankOf(double value) throws Exception {
            return (Integer)this.rankOfMethod.invoke(this.instance, value);
        }

        public int getLevel() throws Exception {
            return (Integer)this.getLevelMethod.invoke(this.instance, new Object[0]);
        }

        public void mergeWith(Object other) throws Exception {
            this.mergeWithMethod.invoke(this.instance, other);
        }

        public void mergeInto(Object other) throws Exception {
            this.mergeIntoMethod.invoke(this.instance, other);
        }

        public Object getInstance() {
            return this.instance;
        }

        public void checkSorted() throws Exception {
            double[] data = this.getData();
            double[] copy = Arrays.copyOf(data, data.length);
            Arrays.sort(copy);
            UnitTestUtils.assertEquals((double[])data, (double[])copy, (double)Double.MIN_VALUE);
        }
    }
}

