/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.LogNormalDistribution;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.Well19937c;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.rank.PSquarePercentile;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class PSquarePercentileTest
extends StorelessUnivariateStatisticAbstractTest {
    protected double percentile5 = 8.2299;
    protected double percentile95 = 16.72195;
    protected double tolerance = 1.0E-11;
    private final RandomGenerator randomGenerator = new Well19937c(1000);
    final int TINY = 10;
    final int SMALL = 50;
    final int NOMINAL = 100;
    final int MEDIUM = 500;
    final int STANDARD = 1000;
    final int BIG = 10000;
    final int VERY_BIG = 50000;
    final int LARGE = 1000000;
    final int VERY_LARGE = 10000000;

    public PSquarePercentile getUnivariateStatistic() {
        return new PSquarePercentile(95.0);
    }

    @Override
    public double expectedValue() {
        return this.percentile95;
    }

    @Override
    public double getTolerance() {
        return 0.01;
    }

    @Test
    public void testCopyConsistencyWithInitialMostElements() {
        PSquarePercentile master = this.getUnivariateStatistic();
        StorelessUnivariateStatistic replica = null;
        long index = FastMath.round((double)(0.75 * (double)this.testArray.length));
        master.incrementAll(this.testArray, 0, (int)index);
        replica = master.copy();
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
        master.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        replica.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
    }

    @Test
    public void testCopyConsistencyWithInitialFirstFewElements() {
        PSquarePercentile master = this.getUnivariateStatistic();
        StorelessUnivariateStatistic replica = null;
        long index = FastMath.round((double)(0.1 * (double)this.testArray.length));
        master.incrementAll(this.testArray, 0, (int)index);
        replica = master.copy();
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
        master.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        replica.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        Assert.assertTrue((boolean)master.equals(master));
        Assert.assertTrue((boolean)replica.equals(replica));
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNullListInMarkers() {
        PSquarePercentile.newMarkers(null, (double)0.0);
    }

    @Test
    public void testMiscellaniousFunctionsInMarkers() {
        double p = 0.5;
        PSquarePercentile.PSquareMarkers markers = PSquarePercentile.newMarkers(Arrays.asList(0.02, 1.18, 9.15, 21.91, 38.62), (double)p);
        Assert.assertTrue((boolean)markers.equals(markers));
        Assert.assertFalse((boolean)markers.equals(null));
        Assert.assertFalse((boolean)markers.equals(new String()));
        PSquarePercentile p1 = new PSquarePercentile();
        PSquarePercentile p2 = new PSquarePercentile();
        Assert.assertEquals((Object)p1, (Object)p2);
        p1.evaluate(new double[]{1.0, 2.0, 3.0});
        p2.evaluate(new double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((Object)p1, (Object)p2);
        p2.incrementAll(new double[]{5.0, 7.0, 11.0});
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1.incrementAll(new double[]{20.0, 21.0, 22.0, 23.0});
        Assert.assertFalse((boolean)p1.equals((Object)p2));
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMarkersOORLow() {
        PSquarePercentile.newMarkers(Arrays.asList(0.02, 1.18, 9.15, 21.91, 38.62), (double)0.5).estimate(0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMarkersOORHigh() {
        PSquarePercentile.newMarkers(Arrays.asList(0.02, 1.18, 9.15, 21.91, 38.62), (double)0.5).estimate(5);
    }

    @Test
    public void testMarkers2() {
        double p = 0.5;
        PSquarePercentile.PSquareMarkers markers = PSquarePercentile.newMarkers(Arrays.asList(0.02, 1.18, 9.15, 21.91, 38.62), (double)p);
        PSquarePercentile.PSquareMarkers markersNew = PSquarePercentile.newMarkers(Arrays.asList(0.02, 1.18, 9.15, 21.91, 38.62), (double)p);
        Assert.assertTrue((boolean)markers.equals(markersNew));
        markersNew.processDataPoint(39.0);
        Assert.assertFalse((boolean)markers.equals(markersNew));
    }

    @Test
    public void testHashCodeInMarkers() {
        PSquarePercentile p = new PSquarePercentile(95.0);
        PSquarePercentile p2 = new PSquarePercentile(95.0);
        HashSet<PSquarePercentile> s = new HashSet<PSquarePercentile>();
        s.add(p);
        s.add(p2);
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertEquals((Object)p, s.iterator().next());
        double[] d = new double[]{95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682};
        Assert.assertEquals((double)95.1981, (double)p.evaluate(d), (double)0.01);
        Assert.assertEquals((double)95.1981, (double)p2.evaluate(d), (double)0.01);
        s.clear();
        s.add(p);
        s.add(p2);
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertEquals((Object)p, s.iterator().next());
        PSquarePercentile.PSquareMarkers m1 = PSquarePercentile.newMarkers(Arrays.asList(95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682), (double)0.0);
        PSquarePercentile.PSquareMarkers m2 = PSquarePercentile.newMarkers(Arrays.asList(95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682), (double)0.0);
        Assert.assertTrue((boolean)m1.equals(m2));
        LinkedHashSet<PSquarePercentile.PSquareMarkers> setMarkers = new LinkedHashSet<PSquarePercentile.PSquareMarkers>();
        Assert.assertTrue((boolean)setMarkers.add(m1));
        Assert.assertFalse((boolean)setMarkers.add(m2));
        Assert.assertEquals((long)1L, (long)setMarkers.size());
        PSquarePercentile.PSquareMarkers mThis = PSquarePercentile.newMarkers(Arrays.asList(195.1772, 195.1567, 195.1937, 195.1959, 95.1442, 195.061, 195.1591, 195.1195, 195.1772, 95.0925, 95.199, 195.1682), (double)0.5);
        PSquarePercentile.PSquareMarkers mThat = PSquarePercentile.newMarkers(Arrays.asList(95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682), (double)0.5);
        Assert.assertTrue((boolean)mThis.equals(mThis));
        Assert.assertFalse((boolean)mThis.equals(mThat));
        String s1 = "";
        Assert.assertFalse((boolean)mThis.equals(s1));
        for (int i = 0; i < this.testArray.length; ++i) {
            mThat.processDataPoint(this.testArray[i]);
        }
        setMarkers.add(mThat);
        setMarkers.add(mThis);
        Assert.assertTrue((boolean)mThat.equals(mThat));
        Assert.assertTrue((boolean)setMarkers.contains(mThat));
        Assert.assertTrue((boolean)setMarkers.contains(mThis));
        Assert.assertEquals((long)3L, (long)setMarkers.size());
        Iterator iterator = setMarkers.iterator();
        Assert.assertEquals((Object)m1, iterator.next());
        Assert.assertEquals((Object)mThat, iterator.next());
        Assert.assertEquals((Object)mThis, iterator.next());
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMarkersWithLowerIndex() {
        PSquarePercentile.PSquareMarkers mThat = PSquarePercentile.newMarkers(Arrays.asList(95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682), (double)0.5);
        for (int i = 0; i < this.testArray.length; ++i) {
            mThat.processDataPoint(this.testArray[i]);
        }
        mThat.estimate(0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMarkersWithHigherIndex() {
        PSquarePercentile.PSquareMarkers mThat = PSquarePercentile.newMarkers(Arrays.asList(95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682), (double)0.5);
        for (int i = 0; i < this.testArray.length; ++i) {
            mThat.processDataPoint(this.testArray[i]);
        }
        mThat.estimate(6);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMarkerHeightWithLowerIndex() {
        PSquarePercentile.PSquareMarkers mThat = PSquarePercentile.newMarkers(Arrays.asList(95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682), (double)0.5);
        mThat.height(0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testMarkerHeightWithHigherIndex() {
        PSquarePercentile.PSquareMarkers mThat = PSquarePercentile.newMarkers(Arrays.asList(95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682), (double)0.5);
        mThat.height(6);
    }

    @Test
    public void testPSquaredEqualsAndMin() {
        PSquarePercentile ptile = new PSquarePercentile(0.0);
        Assert.assertEquals((Object)ptile, (Object)ptile);
        Assert.assertFalse((boolean)ptile.equals(null));
        Assert.assertFalse((boolean)ptile.equals((Object)new String()));
        Assert.assertTrue((boolean)Double.isNaN(ptile.getResult()));
        Assert.assertTrue((boolean)Double.isNaN(new PSquarePercentile(100.0).getResult()));
        double[] d = new double[]{1.0, 3.0, 2.0, 4.0, 9.0, 10.0, 11.0};
        ptile.incrementAll(d);
        Assert.assertEquals((Object)ptile, (Object)ptile);
        Assert.assertEquals((double)1.0, (double)ptile.getResult(), (double)0.01);
        Assert.assertEquals((double)0.0, (double)ptile.getQuantile(), (double)1.0E-15);
    }

    @Test
    public void testString() {
        PSquarePercentile ptile = new PSquarePercentile(95.0);
        Assert.assertNotNull((Object)ptile.toString());
        ptile.increment(1.0);
        ptile.increment(2.0);
        ptile.increment(3.0);
        Assert.assertNotNull((Object)ptile.toString());
        Assert.assertEquals((double)this.expectedValue(), (double)ptile.evaluate(this.testArray), (double)this.getTolerance());
        Assert.assertNotNull((Object)ptile.toString());
        Assert.assertEquals((double)0.95, (double)ptile.getQuantile(), (double)1.0E-15);
    }

    @Test
    public void testHighPercentile() {
        double[] d = new double[]{1.0, 2.0, 3.0};
        PSquarePercentile p = new PSquarePercentile(75.0);
        Assert.assertEquals((double)2.0, (double)p.evaluate(d), (double)1.0E-5);
        PSquarePercentile p95 = new PSquarePercentile();
        Assert.assertEquals((double)2.0, (double)p95.evaluate(d), (double)1.0E-5);
    }

    @Test
    public void testLowPercentile() {
        double[] d = new double[]{0.0, 1.0};
        PSquarePercentile p = new PSquarePercentile(25.0);
        Assert.assertEquals((double)0.0, (double)p.evaluate(d), (double)Double.MIN_VALUE);
    }

    @Test
    public void testPercentile() {
        double[] d = new double[]{1.0, 3.0, 2.0, 4.0};
        PSquarePercentile p = new PSquarePercentile(30.0);
        Assert.assertEquals((double)1.0, (double)p.evaluate(d), (double)1.0E-5);
        p = new PSquarePercentile(25.0);
        Assert.assertEquals((double)1.0, (double)p.evaluate(d), (double)1.0E-5);
        p = new PSquarePercentile(75.0);
        Assert.assertEquals((double)3.0, (double)p.evaluate(d), (double)1.0E-5);
        p = new PSquarePercentile(50.0);
        Assert.assertEquals((double)2.0, (double)p.evaluate(d), (double)1.0E-5);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testInitial() {
        PSquarePercentile.newMarkers(new ArrayList(), (double)0.5);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNegativeInvalidValues() {
        double[] d = new double[]{95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682};
        PSquarePercentile p = new PSquarePercentile(-1.0);
        p.evaluate(d, 0, d.length);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testPositiveInvalidValues() {
        double[] d = new double[]{95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682};
        PSquarePercentile p = new PSquarePercentile(101.0);
        p.evaluate(d, 0, d.length);
    }

    @Test
    public void testNISTExample() {
        double[] d = new double[]{95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682};
        Assert.assertEquals((double)95.1981, (double)new PSquarePercentile(90.0).evaluate(d), (double)0.01);
        Assert.assertEquals((double)95.061, (double)new PSquarePercentile(0.0).evaluate(d), (double)0.0);
        Assert.assertEquals((double)95.199, (double)new PSquarePercentile(100.0).evaluate(d, 0, d.length), (double)0.0);
    }

    @Test
    public void test5() {
        PSquarePercentile percentile = new PSquarePercentile(5.0);
        Assert.assertEquals((double)this.percentile5, (double)percentile.evaluate(this.testArray), (double)1.0);
    }

    @Test(expected=NullArgumentException.class)
    public void testNull() {
        PSquarePercentile percentile = new PSquarePercentile(50.0);
        double[] nullArray = null;
        percentile.evaluate(nullArray);
    }

    @Test
    public void testEmpty() {
        PSquarePercentile percentile = new PSquarePercentile(50.0);
        double[] emptyArray = new double[]{};
        Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(emptyArray)));
    }

    @Test
    public void testSingleton() {
        PSquarePercentile percentile = new PSquarePercentile(50.0);
        double[] singletonArray = new double[]{1.0};
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray), (double)0.0);
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1), (double)0.0);
        percentile = new PSquarePercentile(5.0);
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1), (double)0.0);
        percentile = new PSquarePercentile(100.0);
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1), (double)0.0);
        percentile = new PSquarePercentile(100.0);
        Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(singletonArray, 0, 0)));
    }

    @Test
    public void testSpecialValues() {
        PSquarePercentile percentile = new PSquarePercentile(50.0);
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN};
        Assert.assertEquals((double)2.0, (double)percentile.evaluate(specialValues), (double)0.0);
        specialValues = new double[]{Double.NEGATIVE_INFINITY, 1.0, 2.0, 3.0, Double.NaN, Double.POSITIVE_INFINITY};
        Assert.assertEquals((double)2.0, (double)percentile.evaluate(specialValues), (double)0.0);
        specialValues = new double[]{1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        Assert.assertFalse((boolean)Double.isInfinite(percentile.evaluate(specialValues)));
        specialValues = new double[]{1.0, 1.0, Double.NaN, Double.NaN};
        Assert.assertFalse((boolean)Double.isNaN(percentile.evaluate(specialValues)));
        specialValues = new double[]{1.0, 1.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        percentile = new PSquarePercentile(50.0);
        Assert.assertTrue((boolean)Double.isInfinite(percentile.evaluate(specialValues)));
    }

    @Test
    public void testArrayExample() {
        Assert.assertEquals((double)this.expectedValue(), (double)new PSquarePercentile(95.0).evaluate(this.testArray), (double)this.getTolerance());
    }

    @Test
    public void testSetQuantile() {
        PSquarePercentile percentile = new PSquarePercentile(10.0);
        percentile = new PSquarePercentile(100.0);
        Assert.assertEquals((double)1.0, (double)percentile.quantile(), (double)0.0);
        try {
            percentile = new PSquarePercentile(0.0);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            new PSquarePercentile(0.0);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    private Double[] randomTestData(int factor, int values) {
        Double[] test = new Double[values];
        for (int i = 0; i < test.length; ++i) {
            test[i] = Math.abs(this.randomGenerator.nextDouble() * (double)factor);
        }
        return test;
    }

    @Test
    public void testAccept() {
        Double[] test;
        PSquarePercentile psquared = new PSquarePercentile(0.99);
        Assert.assertTrue((boolean)Double.isNaN(psquared.getResult()));
        for (Double value : test = this.randomTestData(100, 10000)) {
            psquared.increment(value.doubleValue());
            Assert.assertTrue((psquared.getResult() >= 0.0 ? 1 : 0) != 0);
        }
    }

    private void assertValues(Double a, Double b, double delta) {
        if (Double.isNaN(a)) {
            Assert.assertTrue((String)("" + b + " is not NaN."), (boolean)Double.isNaN(a));
        } else {
            double max = FastMath.max((double)a, (double)b);
            double percentage = FastMath.abs((double)(a - b)) / max;
            double deviation = delta;
            Assert.assertTrue((String)String.format("Deviated = %f and is beyond %f as a=%f,  b=%f", percentage, deviation, a, b), (percentage < deviation ? 1 : 0) != 0);
        }
    }

    private void doCalculatePercentile(Double percentile, Number[] test) {
        this.doCalculatePercentile(percentile, test, Double.MAX_VALUE);
    }

    private void doCalculatePercentile(Double percentile, Number[] test, double delta) {
        PSquarePercentile psquared = new PSquarePercentile(percentile.doubleValue());
        for (Number value : test) {
            psquared.increment(value.doubleValue());
        }
        Percentile p2 = new Percentile(percentile * 100.0);
        double[] dall = new double[test.length];
        for (int i = 0; i < test.length; ++i) {
            dall[i] = test[i].doubleValue();
        }
        Double referenceValue = p2.evaluate(dall);
        this.assertValues(psquared.getResult(), referenceValue, delta);
    }

    private void doCalculatePercentile(double percentile, double[] test, double delta) {
        PSquarePercentile psquared = new PSquarePercentile(percentile);
        for (double value : test) {
            psquared.increment(value);
        }
        Percentile p2 = new Percentile(percentile < 1.0 ? percentile * 100.0 : percentile);
        Double referenceValue = p2.evaluate(test);
        this.assertValues(psquared.getResult(), referenceValue, delta);
    }

    @Test
    public void testCannedDataSet() {
        Integer[] seedInput = new Integer[]{283, 285, 298, 304, 310, 31, 319, 32, 33, 339, 342, 348, 350, 354, 354, 357, 36, 36, 369, 37, 37, 375, 378, 383, 390, 396, 405, 408, 41, 414, 419, 416, 42, 420, 430, 430, 432, 444, 447, 447, 449, 45, 451, 456, 468, 470, 471, 474, 600, 695, 70, 83, 97, 109, 113, 128};
        Number[] input = new Integer[seedInput.length * 100];
        for (int i = 0; i < input.length; ++i) {
            input[i] = seedInput[i % seedInput.length] + i;
        }
        this.doCalculatePercentile(0.5, input);
        this.doCalculatePercentile(0.95, input);
    }

    @Test
    public void test99Percentile() {
        Number[] test = this.randomTestData(100, 10000);
        this.doCalculatePercentile(0.99, test);
    }

    @Test
    public void test90Percentile() {
        Number[] test = this.randomTestData(100, 10000);
        this.doCalculatePercentile(0.9, test);
    }

    @Test
    public void test20Percentile() {
        Number[] test = this.randomTestData(100, 100000);
        this.doCalculatePercentile(0.2, test);
    }

    @Test
    public void test5Percentile() {
        Number[] test = this.randomTestData(50, 990000);
        this.doCalculatePercentile(0.5, test);
    }

    @Test
    public void test99PercentileHighValues() {
        Number[] test = this.randomTestData(100000, 10000);
        this.doCalculatePercentile(0.99, test);
    }

    @Test
    public void test90PercentileHighValues() {
        Number[] test = this.randomTestData(100000, 100000);
        this.doCalculatePercentile(0.9, test);
    }

    @Test
    public void test20PercentileHighValues() {
        Number[] test = this.randomTestData(100000, 100000);
        this.doCalculatePercentile(0.2, test);
    }

    @Test
    public void test5PercentileHighValues() {
        Number[] test = this.randomTestData(100000, 100000);
        this.doCalculatePercentile(0.05, test);
    }

    @Test
    public void test0PercentileValuesWithFewerThan5Values() {
        double[] test = new double[]{1.0, 2.0, 3.0, 4.0};
        PSquarePercentile p = new PSquarePercentile(0.0);
        Assert.assertEquals((double)1.0, (double)p.evaluate(test), (double)0.0);
        Assert.assertNotNull((Object)p.toString());
    }

    @Test
    public void testPSQuaredEvalFuncWithPapersExampleData() throws IOException {
        double[] data = new double[]{0.02, 0.5, 0.74, 3.39, 0.83, 22.37, 10.15, 15.43, 38.62, 15.92, 34.6, 10.28, 1.47, 0.4, 0.05, 11.39, 0.27, 0.42, 0.09, 11.37, 11.39, 15.43, 15.92, 22.37, 34.6, 38.62, 18.9, 19.2, 27.6, 12.8, 13.7, 21.9};
        PSquarePercentile psquared = new PSquarePercentile(50.0);
        Double p2value = 0.0;
        for (int i = 0; i < 20; ++i) {
            psquared.increment(data[i]);
            p2value = psquared.getResult();
        }
        Double expected = 4.44;
        Assert.assertEquals((String)String.format("Expected=%f, Actual=%f", expected, p2value), (double)expected, (double)p2value, (double)0.25);
    }

    private void doDistributionTest(RealDistribution distribution) {
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        double[] data = randomDataGenerator.nextDeviates(distribution, 1000000);
        this.doCalculatePercentile(50.0, data, 0.001);
        this.doCalculatePercentile(95.0, data, 0.001);
        data = randomDataGenerator.nextDeviates(distribution, 50000);
        this.doCalculatePercentile(50.0, data, 0.001);
        this.doCalculatePercentile(95.0, data, 0.001);
        data = randomDataGenerator.nextDeviates(distribution, 10000);
        this.doCalculatePercentile(50.0, data, 0.001);
        this.doCalculatePercentile(95.0, data, 0.001);
        data = randomDataGenerator.nextDeviates(distribution, 1000);
        this.doCalculatePercentile(50.0, data, 0.005);
        this.doCalculatePercentile(95.0, data, 0.005);
        data = randomDataGenerator.nextDeviates(distribution, 500);
        this.doCalculatePercentile(50.0, data, 0.005);
        this.doCalculatePercentile(95.0, data, 0.005);
        data = randomDataGenerator.nextDeviates(distribution, 100);
        this.doCalculatePercentile(50.0, data, 0.01);
        this.doCalculatePercentile(95.0, data, 0.01);
        data = randomDataGenerator.nextDeviates(distribution, 50);
        this.doCalculatePercentile(50.0, data, 0.01);
        this.doCalculatePercentile(95.0, data, 0.01);
        data = randomDataGenerator.nextDeviates(distribution, 10);
        this.doCalculatePercentile(50.0, data, 0.05);
        this.doCalculatePercentile(95.0, data, 0.05);
    }

    @Test
    public void testDistribution() {
        this.doDistributionTest((RealDistribution)new NormalDistribution(4000.0, 50.0));
        this.doDistributionTest((RealDistribution)new LogNormalDistribution(4000.0, 50.0));
    }
}

