/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.Arrays;
import java.util.function.DoubleConsumer;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.UniformRealDistribution;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.Well19937a;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class StreamingStatisticsTest {
    private final double[] testArray = new double[]{1.0, 2.0, 2.0, 3.0};
    private final double one = 1.0;
    private final float twoF = 2.0f;
    private final long twoL = 2L;
    private final int three = 3;
    private final double mean = 2.0;
    private final double sumSq = 18.0;
    private final double sum = 8.0;
    private final double var = 0.6666666666666666;
    private final double popVar = 0.5;
    private final double std = FastMath.sqrt((double)0.6666666666666666);
    private final double n = 4.0;
    private final double min = 1.0;
    private final double max = 3.0;
    private final double tolerance = 1.0E-14;

    protected StreamingStatistics createStreamingStatistics() {
        return new StreamingStatistics();
    }

    @Test
    public void testStats() {
        StreamingStatistics u = this.createStreamingStatistics();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)1.0E-14);
        u.addValue(1.0);
        u.addValue(2.0);
        u.addValue(2.0);
        u.addValue(3.0);
        Assert.assertEquals((String)"N", (double)4.0, (double)u.getN(), (double)1.0E-14);
        Assert.assertEquals((String)"sum", (double)8.0, (double)u.getSum(), (double)1.0E-14);
        Assert.assertEquals((String)"sumsq", (double)18.0, (double)u.getSumOfSquares(), (double)1.0E-14);
        Assert.assertEquals((String)"var", (double)0.6666666666666666, (double)u.getVariance(), (double)1.0E-14);
        Assert.assertEquals((String)"population var", (double)0.5, (double)u.getPopulationVariance(), (double)1.0E-14);
        Assert.assertEquals((String)"std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"mean", (double)2.0, (double)u.getMean(), (double)1.0E-14);
        Assert.assertEquals((String)"min", (double)1.0, (double)u.getMin(), (double)1.0E-14);
        Assert.assertEquals((String)"max", (double)3.0, (double)u.getMax(), (double)1.0E-14);
        u.clear();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)1.0E-14);
    }

    @Test
    public void testConsume() {
        StreamingStatistics u = this.createStreamingStatistics();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)1.0E-14);
        Arrays.stream(this.testArray).forEach((DoubleConsumer)u);
        Assert.assertEquals((String)"N", (double)4.0, (double)u.getN(), (double)1.0E-14);
        Assert.assertEquals((String)"sum", (double)8.0, (double)u.getSum(), (double)1.0E-14);
        Assert.assertEquals((String)"sumsq", (double)18.0, (double)u.getSumOfSquares(), (double)1.0E-14);
        Assert.assertEquals((String)"var", (double)0.6666666666666666, (double)u.getVariance(), (double)1.0E-14);
        Assert.assertEquals((String)"population var", (double)0.5, (double)u.getPopulationVariance(), (double)1.0E-14);
        Assert.assertEquals((String)"std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"mean", (double)2.0, (double)u.getMean(), (double)1.0E-14);
        Assert.assertEquals((String)"min", (double)1.0, (double)u.getMin(), (double)1.0E-14);
        Assert.assertEquals((String)"max", (double)3.0, (double)u.getMax(), (double)1.0E-14);
        u.clear();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)1.0E-14);
    }

    @Test
    public void testN0andN1Conditions() {
        StreamingStatistics u = this.createStreamingStatistics();
        Assert.assertTrue((String)"Mean of n = 0 set should be NaN", (boolean)Double.isNaN(u.getMean()));
        Assert.assertTrue((String)"Standard Deviation of n = 0 set should be NaN", (boolean)Double.isNaN(u.getStandardDeviation()));
        Assert.assertTrue((String)"Variance of n = 0 set should be NaN", (boolean)Double.isNaN(u.getVariance()));
        u.addValue(1.0);
        Assert.assertTrue((String)"mean should be one (n = 1)", (u.getMean() == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("geometric should be one (n = 1) instead it is " + u.getGeometricMean()), (u.getGeometricMean() == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Std should be zero (n = 1)", (u.getStandardDeviation() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"variance should be zero (n = 1)", (u.getVariance() == 0.0 ? 1 : 0) != 0);
        u.addValue(2.0);
        Assert.assertTrue((String)"Std should not be zero (n = 2)", (u.getStandardDeviation() != 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"variance should not be zero (n = 2)", (u.getVariance() != 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testProductAndGeometricMean() {
        StreamingStatistics u = this.createStreamingStatistics();
        u.addValue(1.0);
        u.addValue(2.0);
        u.addValue(3.0);
        u.addValue(4.0);
        Assert.assertEquals((String)"Geometric mean not expected", (double)2.213364, (double)u.getGeometricMean(), (double)1.0E-5);
    }

    @Test
    public void testNaNContracts() {
        StreamingStatistics u = this.createStreamingStatistics();
        Assert.assertTrue((String)"mean not NaN", (boolean)Double.isNaN(u.getMean()));
        Assert.assertTrue((String)"min not NaN", (boolean)Double.isNaN(u.getMin()));
        Assert.assertTrue((String)"std dev not NaN", (boolean)Double.isNaN(u.getStandardDeviation()));
        Assert.assertTrue((String)"var not NaN", (boolean)Double.isNaN(u.getVariance()));
        Assert.assertTrue((String)"geom mean not NaN", (boolean)Double.isNaN(u.getGeometricMean()));
        u.addValue(1.0);
        Assert.assertEquals((String)"mean", (double)1.0, (double)u.getMean(), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"variance", (double)0.0, (double)u.getVariance(), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"geometric mean", (double)1.0, (double)u.getGeometricMean(), (double)Double.MIN_VALUE);
        u.addValue(-1.0);
        Assert.assertTrue((String)"geom mean not NaN", (boolean)Double.isNaN(u.getGeometricMean()));
        u.addValue(0.0);
        Assert.assertTrue((String)"geom mean not NaN", (boolean)Double.isNaN(u.getGeometricMean()));
    }

    @Test
    public void testGetSummary() {
        StreamingStatistics u = this.createStreamingStatistics();
        StatisticalSummary summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(1.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
    }

    @Test
    public void testSerialization() {
        StreamingStatistics u = this.createStreamingStatistics();
        UnitTestUtils.checkSerializedEquality((Object)u);
        StreamingStatistics s = (StreamingStatistics)UnitTestUtils.serializeAndRecover((Object)u);
        StatisticalSummary summary = s.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        u.addValue(5.0);
        UnitTestUtils.checkSerializedEquality((Object)u);
        s = (StreamingStatistics)UnitTestUtils.serializeAndRecover((Object)u);
        summary = s.getSummary();
        this.verifySummary(u, summary);
    }

    @Test
    public void testEqualsAndHashCode() {
        StreamingStatistics u = this.createStreamingStatistics();
        StreamingStatistics t = null;
        int emptyHash = u.hashCode();
        Assert.assertTrue((String)"reflexive", (boolean)u.equals((Object)u));
        Assert.assertFalse((String)"non-null compared to null", (boolean)u.equals(t));
        Assert.assertFalse((String)"wrong type", (boolean)u.equals((Object)0.0));
        t = this.createStreamingStatistics();
        Assert.assertTrue((String)"empty instances should be equal", (boolean)t.equals((Object)u));
        Assert.assertTrue((String)"empty instances should be equal", (boolean)u.equals((Object)t));
        Assert.assertEquals((String)"empty hash code", (long)emptyHash, (long)t.hashCode());
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        Assert.assertFalse((String)"different n's should make instances not equal", (boolean)t.equals((Object)u));
        Assert.assertFalse((String)"different n's should make instances not equal", (boolean)u.equals((Object)t));
        Assert.assertTrue((String)"different n's should make hashcodes different", (u.hashCode() != t.hashCode() ? 1 : 0) != 0);
        t.addValue(2.0);
        t.addValue(1.0);
        t.addValue(3.0);
        t.addValue(4.0);
        Assert.assertTrue((String)"summaries based on same data should be equal", (boolean)t.equals((Object)u));
        Assert.assertTrue((String)"summaries based on same data should be equal", (boolean)u.equals((Object)t));
        Assert.assertEquals((String)"summaries based on same data should have same hashcodes", (long)u.hashCode(), (long)t.hashCode());
        u.clear();
        t.clear();
        Assert.assertTrue((String)"empty instances should be equal", (boolean)t.equals((Object)u));
        Assert.assertTrue((String)"empty instances should be equal", (boolean)u.equals((Object)t));
        Assert.assertEquals((String)"empty hash code", (long)emptyHash, (long)t.hashCode());
        Assert.assertEquals((String)"empty hash code", (long)emptyHash, (long)u.hashCode());
    }

    @Test
    public void testCopy() {
        StreamingStatistics u = this.createStreamingStatistics();
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        StreamingStatistics v = u.copy();
        Assert.assertEquals((Object)u, (Object)v);
        Assert.assertEquals((Object)v, (Object)u);
        u.addValue(7.0);
        u.addValue(9.0);
        u.addValue(11.0);
        u.addValue(23.0);
        v.addValue(7.0);
        v.addValue(9.0);
        v.addValue(11.0);
        v.addValue(23.0);
        Assert.assertEquals((Object)u, (Object)v);
        Assert.assertEquals((Object)v, (Object)u);
    }

    private void verifySummary(StreamingStatistics u, StatisticalSummary s) {
        Assert.assertEquals((String)"N", (long)s.getN(), (long)u.getN());
        UnitTestUtils.assertEquals((String)"sum", (double)s.getSum(), (double)u.getSum(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"var", (double)s.getVariance(), (double)u.getVariance(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"std", (double)s.getStandardDeviation(), (double)u.getStandardDeviation(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"mean", (double)s.getMean(), (double)u.getMean(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"min", (double)s.getMin(), (double)u.getMin(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"max", (double)s.getMax(), (double)u.getMax(), (double)1.0E-14);
    }

    @Test
    public void testQuadraticMean() {
        double[] values = new double[]{1.2, 3.4, 5.6, 7.89};
        StreamingStatistics stats = this.createStreamingStatistics();
        int len = values.length;
        double expected = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = values[i];
            expected += v * v / (double)len;
            stats.addValue(v);
        }
        expected = Math.sqrt(expected);
        Assert.assertEquals((double)expected, (double)stats.getQuadraticMean(), (double)Math.ulp(expected));
    }

    @Test
    public void testToString() {
        StreamingStatistics u = this.createStreamingStatistics();
        for (int i = 0; i < 5; ++i) {
            u.addValue((double)i);
        }
        String[] labels = new String[]{"min", "max", "sum", "geometric mean", "variance", "population variance", "second moment", "sum of squares", "standard deviation", "sum of logs"};
        double[] values = new double[]{u.getMin(), u.getMax(), u.getSum(), u.getGeometricMean(), u.getVariance(), u.getPopulationVariance(), u.getSecondMoment(), u.getSumOfSquares(), u.getStandardDeviation(), u.getSumOfLogs()};
        String toString = u.toString();
        Assert.assertTrue((toString.indexOf("n: " + u.getN()) > 0 ? 1 : 0) != 0);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertTrue((toString.indexOf(labels[i] + ": " + String.valueOf(values[i])) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAggregationConsistency() {
        int i;
        double[] totalSample = this.generateSample();
        double[][] subSamples = this.generatePartition(totalSample);
        int nSamples = subSamples.length;
        StreamingStatistics aggregate = new StreamingStatistics();
        StreamingStatistics totalStats = new StreamingStatistics();
        Object[] componentStats = new StreamingStatistics[nSamples];
        for (i = 0; i < nSamples; ++i) {
            componentStats[i] = new StreamingStatistics();
            for (int j = 0; j < subSamples[i].length; ++j) {
                componentStats[i].addValue(subSamples[i][j]);
            }
        }
        aggregate.aggregate(componentStats);
        for (i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        StreamingStatisticsTest.assertSummaryStatisticsEquals(totalStats, aggregate, 1.0E-10);
        double tol = 1.0E-13;
        Assert.assertEquals((double)totalStats.getPercentile(10.0), (double)aggregate.getPercentile(10.0), (double)1.0E-13);
        Assert.assertEquals((double)totalStats.getPercentile(25.0), (double)aggregate.getPercentile(25.0), (double)1.0E-13);
        Assert.assertEquals((double)totalStats.getPercentile(50.0), (double)aggregate.getPercentile(50.0), (double)1.0E-13);
        Assert.assertEquals((double)totalStats.getPercentile(75.0), (double)aggregate.getPercentile(75.0), (double)1.0E-13);
        Assert.assertEquals((double)totalStats.getPercentile(90.0), (double)aggregate.getPercentile(90.0), (double)1.0E-13);
        Assert.assertEquals((double)totalStats.getPercentile(99.0), (double)aggregate.getPercentile(99.0), (double)1.0E-13);
    }

    @Test
    public void testAggregateDegenerate() {
        int i;
        double[] totalSample = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[][] subSamples = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}, {5.0}};
        StreamingStatistics totalStats = new StreamingStatistics();
        for (int i2 = 0; i2 < totalSample.length; ++i2) {
            totalStats.addValue(totalSample[i2]);
        }
        Object[] subSampleStats = new StreamingStatistics[5];
        for (i = 0; i < 5; ++i) {
            subSampleStats[i] = new StreamingStatistics();
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
        }
        StreamingStatistics aggregatedStats = new StreamingStatistics();
        aggregatedStats.aggregate(subSampleStats);
        StreamingStatisticsTest.assertSummaryStatisticsEquals(totalStats, aggregatedStats, 1.0E-9);
    }

    @Test
    public void testAggregateSpecialValues() {
        int i;
        double[] totalSample = new double[]{Double.POSITIVE_INFINITY, 2.0, 3.0, Double.NaN, 5.0};
        double[][] subSamples = new double[][]{{Double.POSITIVE_INFINITY, 2.0}, {3.0}, {Double.NaN}, {5.0}};
        StreamingStatistics totalStats = new StreamingStatistics();
        for (int i2 = 0; i2 < totalSample.length; ++i2) {
            totalStats.addValue(totalSample[i2]);
        }
        Object[] subSampleStats = new StreamingStatistics[4];
        for (i = 0; i < 4; ++i) {
            subSampleStats[i] = new StreamingStatistics();
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
        }
        StreamingStatistics aggregatedStats = new StreamingStatistics();
        aggregatedStats.aggregate(subSampleStats);
        StreamingStatisticsTest.assertSummaryStatisticsEquals(totalStats, aggregatedStats, 1.0E-9);
    }

    @Test
    public void testBuilderDefault() {
        StreamingStatistics stats = StreamingStatistics.builder().build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assert.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    public void testBuilderPercentilesOn() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assert.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assert.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assert.assertEquals((double)0.0, (double)stats.getSum(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertEquals((double)0.0, (double)stats.getSumOfSquares(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)stats.getSumOfLogs(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    public void testBuilderMomentsOff() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).moments(false).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assert.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getSum()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assert.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getSum()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertEquals((double)0.0, (double)stats.getSumOfSquares(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)stats.getSumOfLogs(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    public void testBuilderSumOfLogsOff() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).sumOfLogs(false).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assert.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assert.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assert.assertEquals((double)0.0, (double)stats.getSum(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertEquals((double)0.0, (double)stats.getSumOfSquares(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    public void testBuilderExtremaOff() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).extrema(false).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assert.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assert.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assert.assertEquals((double)0.0, (double)stats.getSum(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertEquals((double)0.0, (double)stats.getSumOfSquares(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)stats.getSumOfLogs(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    public void testBuilderSumOfSquares() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).sumOfSquares(false).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assert.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assert.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assert.assertEquals((double)0.0, (double)stats.getSum(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assert.assertEquals((double)0.0, (double)stats.getSumOfLogs(), (double)1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assert.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    protected static void assertSummaryStatisticsEquals(StreamingStatistics expected, StreamingStatistics observed, double delta) {
        UnitTestUtils.assertEquals((double)expected.getMax(), (double)observed.getMax(), (double)0.0);
        UnitTestUtils.assertEquals((double)expected.getMin(), (double)observed.getMin(), (double)0.0);
        Assert.assertEquals((long)expected.getN(), (long)observed.getN());
        UnitTestUtils.assertEquals((double)expected.getSum(), (double)observed.getSum(), (double)delta);
        UnitTestUtils.assertEquals((double)expected.getMean(), (double)observed.getMean(), (double)delta);
        UnitTestUtils.assertEquals((double)expected.getStandardDeviation(), (double)observed.getStandardDeviation(), (double)delta);
        UnitTestUtils.assertEquals((double)expected.getVariance(), (double)observed.getVariance(), (double)delta);
    }

    private double[] generateSample() {
        UniformRealDistribution uniformDist = new UniformRealDistribution(-100.0, 100.0);
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        int sampleSize = randomDataGenerator.nextInt(10, 100);
        double[] out = randomDataGenerator.nextDeviates((RealDistribution)uniformDist, sampleSize);
        return out;
    }

    private double[][] generatePartition(double[] sample) {
        int subLength;
        int length = sample.length;
        double[][] out = new double[5][];
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        int cur = 0;
        int offset = 0;
        int sampleCount = 0;
        for (int i = 0; i < 5 && cur != length && offset != length; offset += subLength, ++i) {
            int next = i == 4 || cur == length - 1 ? length - 1 : randomDataGenerator.nextInt(cur, length - 1);
            subLength = next - cur + 1;
            out[i] = new double[subLength];
            System.arraycopy(sample, offset, out[i], 0, subLength);
            cur = next + 1;
            ++sampleCount;
        }
        if (sampleCount < 5) {
            double[][] out2 = new double[sampleCount][];
            for (int j = 0; j < sampleCount; ++j) {
                int curSize = out[j].length;
                out2[j] = new double[curSize];
                System.arraycopy(out[j], 0, out2[j], 0, curSize);
            }
            return out2;
        }
        return out;
    }
}

