/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.projection;

import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.stat.LocalizedStatFormats;
import org.hipparchus.stat.projection.PCA;
import org.junit.Assert;
import org.junit.Test;

public class PCATest {
    private static final double[][] SCORES = new double[][]{{90.0, 60.0, 90.0}, {90.0, 90.0, 30.0}, {60.0, 60.0, 60.0}, {60.0, 60.0, 90.0}, {30.0, 30.0, 30.0}};
    public static final double[] EXPECTED_MEAN = new double[]{66.0, 60.0, 60.0};
    public static final double[] EXPECTED_VARIANCE = new double[]{1137.587441, 786.387983, 56.024575};
    private static final double[][] EXPECTED_COMPONENTS = new double[][]{{0.6558023, 0.385999}, {0.4291978, 0.516366}, {0.6210577, -0.7644414}};
    private static final double[][] EXPECTED_COV = new double[][]{{34.3709848, -13.6692708}, {9.9834573, 47.6882055}, {-3.9348135, -2.3159927}, {14.6969171, -25.2492347}, {-55.1165457, -6.4537072}};
    private static final double[][] EXPECTED_COR = new double[][]{{0.9118256, -0.942809}, {1.3832302, 1.4142136}, {-0.1690309, 0.0}, {0.0666714, -0.942809}, {-2.1926964, 0.4714045}};
    public static final double[][] EXPECTED_COR_NO_BIAS = new double[][]{{1.0194521, -1.0540926}, {1.5464984, 1.5811388}, {-0.1889822, 0.0}, {0.0745409, -1.0540926}, {-2.451509, 0.5270463}};
    public static final double DELTA = 1.0E-6;

    @Test
    public void defaultSettings() {
        PCA pca = new PCA(2);
        Assert.assertEquals((long)2L, (long)pca.getNumComponents());
        Assert.assertFalse((boolean)pca.isScale());
        Assert.assertTrue((boolean)pca.isBiasCorrection());
    }

    @Test
    public void covariance() {
        PCA pca = new PCA(2);
        double[][] actual = pca.fitAndTransform(SCORES);
        Assert.assertArrayEquals((double[])EXPECTED_MEAN, (double[])pca.getCenter(), (double)1.0E-6);
        Assert.assertArrayEquals((double[])EXPECTED_VARIANCE, (double[])pca.getVariance(), (double)1.0E-6);
        PCATest.assertExpected(EXPECTED_COMPONENTS, pca.getComponents());
        PCATest.assertExpected(EXPECTED_COV, actual);
        pca = new PCA(2);
        actual = pca.fit(SCORES).transform(SCORES);
        Assert.assertArrayEquals((double[])EXPECTED_MEAN, (double[])pca.getCenter(), (double)1.0E-6);
        PCATest.assertExpected(EXPECTED_COV, actual);
    }

    @Test
    public void correlation() {
        PCA pca = new PCA(2, true, true);
        double[][] actual = pca.fitAndTransform(SCORES);
        PCATest.assertExpected(EXPECTED_COR, actual);
    }

    @Test
    public void correlationNoBias() {
        PCA pca = new PCA(2, true, false);
        double[][] actual = pca.fitAndTransform(SCORES);
        PCATest.assertExpected(EXPECTED_COR_NO_BIAS, actual);
    }

    @Test
    public void transformWithoutFit() {
        PCA pca = new PCA(2);
        try {
            pca.transform(SCORES);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalStateException mise) {
            Assert.assertEquals((Object)LocalizedStatFormats.ILLEGAL_STATE_PCA, (Object)mise.getSpecifier());
            Assert.assertEquals((Object)"transform", (Object)mise.getParts()[0]);
        }
    }

    private static void assertExpected(double[][] expected, double[][] actual) {
        for (int i = 0; i < expected.length; ++i) {
            double[] e = expected[i];
            double[] t = actual[i];
            Assert.assertArrayEquals((double[])e, (double[])t, (double)1.0E-6);
        }
    }
}

