/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.regression;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.hipparchus.random.GaussianRandomGenerator;
import org.hipparchus.random.JDKRandomGenerator;
import org.hipparchus.random.NormalizedRandomGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.stat.correlation.Covariance;
import org.hipparchus.stat.descriptive.DescriptiveStatistics;
import org.hipparchus.stat.regression.GLSMultipleLinearRegression;
import org.hipparchus.stat.regression.MultipleLinearRegressionAbstractTest;
import org.hipparchus.stat.regression.OLSMultipleLinearRegression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GLSMultipleLinearRegressionTest
extends MultipleLinearRegressionAbstractTest {
    private double[] y;
    private double[][] x;
    private double[][] omega;
    private final double[] longley = new double[]{60323.0, 83.0, 234289.0, 2356.0, 1590.0, 107608.0, 1947.0, 61122.0, 88.5, 259426.0, 2325.0, 1456.0, 108632.0, 1948.0, 60171.0, 88.2, 258054.0, 3682.0, 1616.0, 109773.0, 1949.0, 61187.0, 89.5, 284599.0, 3351.0, 1650.0, 110929.0, 1950.0, 63221.0, 96.2, 328975.0, 2099.0, 3099.0, 112075.0, 1951.0, 63639.0, 98.1, 346999.0, 1932.0, 3594.0, 113270.0, 1952.0, 64989.0, 99.0, 365385.0, 1870.0, 3547.0, 115094.0, 1953.0, 63761.0, 100.0, 363112.0, 3578.0, 3350.0, 116219.0, 1954.0, 66019.0, 101.2, 397469.0, 2904.0, 3048.0, 117388.0, 1955.0, 67857.0, 104.6, 419180.0, 2822.0, 2857.0, 118734.0, 1956.0, 68169.0, 108.4, 442769.0, 2936.0, 2798.0, 120445.0, 1957.0, 66513.0, 110.8, 444546.0, 4681.0, 2637.0, 121950.0, 1958.0, 68655.0, 112.6, 482704.0, 3813.0, 2552.0, 123366.0, 1959.0, 69564.0, 114.2, 502601.0, 3931.0, 2514.0, 125368.0, 1960.0, 69331.0, 115.7, 518173.0, 4806.0, 2572.0, 127852.0, 1961.0, 70551.0, 116.9, 554894.0, 4007.0, 2827.0, 130081.0, 1962.0};

    @Override
    @Before
    public void setUp() {
        this.y = new double[]{11.0, 12.0, 13.0, 14.0, 15.0, 16.0};
        this.x = new double[6][];
        this.x[0] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        this.x[1] = new double[]{2.0, 0.0, 0.0, 0.0, 0.0};
        this.x[2] = new double[]{0.0, 3.0, 0.0, 0.0, 0.0};
        this.x[3] = new double[]{0.0, 0.0, 4.0, 0.0, 0.0};
        this.x[4] = new double[]{0.0, 0.0, 0.0, 5.0, 0.0};
        this.x[5] = new double[]{0.0, 0.0, 0.0, 0.0, 6.0};
        this.omega = new double[6][];
        this.omega[0] = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.omega[1] = new double[]{0.0, 2.0, 0.0, 0.0, 0.0, 0.0};
        this.omega[2] = new double[]{0.0, 0.0, 3.0, 0.0, 0.0, 0.0};
        this.omega[3] = new double[]{0.0, 0.0, 0.0, 4.0, 0.0, 0.0};
        this.omega[4] = new double[]{0.0, 0.0, 0.0, 0.0, 5.0, 0.0};
        this.omega[5] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 6.0};
        super.setUp();
    }

    @Test(expected=NullArgumentException.class)
    public void cannotAddXSampleData() {
        this.createRegression().newSampleData(new double[0], null, null);
    }

    @Test(expected=NullArgumentException.class)
    public void cannotAddNullYSampleData() {
        this.createRegression().newSampleData(null, (double[][])new double[0][], null);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void cannotAddSampleDataWithSizeMismatch() {
        double[] y = new double[]{1.0, 2.0};
        double[][] x = new double[][]{{1.0, 0.0}};
        this.createRegression().newSampleData(y, (double[][])x, null);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void cannotAddNullCovarianceData() {
        this.createRegression().newSampleData(new double[0], (double[][])new double[0][], null);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void notEnoughData() {
        double[] reducedY = new double[this.y.length - 1];
        double[][] reducedX = new double[this.x.length - 1][];
        double[][] reducedO = new double[this.omega.length - 1][];
        System.arraycopy(this.y, 0, reducedY, 0, reducedY.length);
        System.arraycopy(this.x, 0, reducedX, 0, reducedX.length);
        System.arraycopy(this.omega, 0, reducedO, 0, reducedO.length);
        this.createRegression().newSampleData(reducedY, (double[][])reducedX, (double[][])reducedO);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void cannotAddCovarianceDataWithSampleSizeMismatch() {
        double[] y = new double[]{1.0, 2.0};
        double[][] x = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[][] omega = new double[][]{{1.0, 0.0}};
        this.createRegression().newSampleData(y, (double[][])x, (double[][])omega);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void cannotAddCovarianceDataThatIsNotSquare() {
        double[] y = new double[]{1.0, 2.0};
        double[][] x = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[][] omega = new double[][]{{1.0, 0.0}, {0.0, 1.0}, {0.0, 2.0}};
        this.createRegression().newSampleData(y, (double[][])x, (double[][])omega);
    }

    protected GLSMultipleLinearRegression createRegression() {
        GLSMultipleLinearRegression regression = new GLSMultipleLinearRegression();
        regression.newSampleData(this.y, this.x, this.omega);
        return regression;
    }

    @Override
    protected int getNumberOfRegressors() {
        return this.x[0].length + 1;
    }

    @Override
    protected int getSampleSize() {
        return this.y.length;
    }

    @Test
    public void testYVariance() {
        GLSMultipleLinearRegression model = new GLSMultipleLinearRegression();
        model.newSampleData(this.y, this.x, this.omega);
        UnitTestUtils.assertEquals((double)model.calculateYVariance(), (double)3.5, (double)0.0);
    }

    @Test
    public void testNewSample2() {
        double[] y = new double[]{1.0, 2.0, 3.0, 4.0};
        double[][] x = new double[][]{{19.0, 22.0, 33.0}, {20.0, 30.0, 40.0}, {25.0, 35.0, 45.0}, {27.0, 37.0, 47.0}};
        double[][] covariance = MatrixUtils.createRealIdentityMatrix((int)4).scalarMultiply(2.0).getData();
        GLSMultipleLinearRegression regression = new GLSMultipleLinearRegression();
        regression.newSampleData(y, (double[][])x, covariance);
        RealMatrix combinedX = regression.getX().copy();
        RealVector combinedY = regression.getY().copy();
        RealMatrix combinedCovInv = regression.getOmegaInverse();
        regression.newXSampleData((double[][])x);
        regression.newYSampleData(y);
        Assert.assertEquals((Object)combinedX, (Object)regression.getX());
        Assert.assertEquals((Object)combinedY, (Object)regression.getY());
        Assert.assertEquals((Object)combinedCovInv, (Object)regression.getOmegaInverse());
    }

    @Test
    public void testGLSOLSConsistency() {
        RealMatrix identityCov = MatrixUtils.createRealIdentityMatrix((int)16);
        GLSMultipleLinearRegression glsModel = new GLSMultipleLinearRegression();
        OLSMultipleLinearRegression olsModel = new OLSMultipleLinearRegression();
        glsModel.newSampleData(this.longley, 16, 6);
        olsModel.newSampleData(this.longley, 16, 6);
        glsModel.newCovarianceData(identityCov.getData());
        double[] olsBeta = olsModel.calculateBeta().toArray();
        double[] glsBeta = glsModel.calculateBeta().toArray();
        for (int i = 0; i < olsBeta.length; ++i) {
            UnitTestUtils.assertRelativelyEquals((double)olsBeta[i], (double)glsBeta[i], (double)1.0E-6);
        }
    }

    @Test
    public void testGLSEfficiency() {
        JDKRandomGenerator rg = new JDKRandomGenerator();
        rg.setSeed(200);
        int nObs = 16;
        double[] sigma = new double[16];
        for (int i = 0; i < 16; ++i) {
            sigma[i] = 10.0 * rg.nextDouble();
        }
        int numSeeds = 1000;
        RealMatrix errorSeeds = MatrixUtils.createRealMatrix((int)1000, (int)16);
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 16; ++j) {
                errorSeeds.setEntry(i, j, rg.nextGaussian() * sigma[j]);
            }
        }
        RealMatrix cov = new Covariance(errorSeeds).getCovarianceMatrix();
        GaussianRandomGenerator rawGenerator = new GaussianRandomGenerator((RandomGenerator)rg);
        double[] errorMeans = new double[16];
        CorrelatedRandomVectorGenerator gen = new CorrelatedRandomVectorGenerator(errorMeans, cov, 1.0E-12 * cov.getNorm1(), (NormalizedRandomGenerator)rawGenerator);
        OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
        ols.newSampleData(this.longley, 16, 6);
        RealVector b = ols.calculateBeta().copy();
        RealMatrix x = ols.getX().copy();
        GLSMultipleLinearRegression gls = new GLSMultipleLinearRegression();
        gls.newSampleData(this.longley, 16, 6);
        gls.newCovarianceData(cov.getData());
        DescriptiveStatistics olsBetaStats = new DescriptiveStatistics();
        DescriptiveStatistics glsBetaStats = new DescriptiveStatistics();
        int nModels = 10000;
        for (int i = 0; i < 10000; ++i) {
            RealVector u = MatrixUtils.createRealVector((double[])gen.nextVector());
            double[] y = u.add(x.operate(b)).toArray();
            ols.newYSampleData(y);
            RealVector olsBeta = ols.calculateBeta();
            gls.newYSampleData(y);
            RealVector glsBeta = gls.calculateBeta();
            double dist = olsBeta.getDistance(b);
            olsBetaStats.addValue(dist * dist);
            dist = glsBeta.getDistance(b);
            glsBetaStats.addValue(dist * dist);
        }
        assert (olsBetaStats.getMean() > 1.5 * glsBetaStats.getMean());
        assert (olsBetaStats.getStandardDeviation() > glsBetaStats.getStandardDeviation());
    }
}

