/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.Locale;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.stat.descriptive.StatisticalSummaryValues;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class StatisticalSummaryValuesTest {
    StatisticalSummaryValuesTest() {
    }

    @Test
    void testSerialization() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        UnitTestUtils.checkSerializedEquality((Object)u);
        StatisticalSummaryValues t = (StatisticalSummaryValues)UnitTestUtils.serializeAndRecover((Object)u);
        this.verifyEquality(u, t);
    }

    @Test
    void testEqualsAndHashCode() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        StatisticalSummaryValues t = null;
        Assertions.assertEquals((Object)u, (Object)u, (String)"reflexive");
        Assertions.assertNotEquals((Object)u, t, (String)"non-null compared to null");
        Assertions.assertNotEquals((Object)u, (Object)0.0, (String)"wrong type");
        t = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        Assertions.assertEquals((Object)t, (Object)u, (String)"instances with same data should be equal");
        Assertions.assertEquals((int)u.hashCode(), (int)t.hashCode(), (String)"hash code");
        u = new StatisticalSummaryValues(Double.NaN, 2.0, 3L, 4.0, 5.0, 6.0);
        t = new StatisticalSummaryValues(1.0, Double.NaN, 3L, 4.0, 5.0, 6.0);
        Assertions.assertFalse((u.equals((Object)t) || t.equals((Object)u) ? 1 : 0) != 0, (String)"instances based on different data should be different");
    }

    private void verifyEquality(StatisticalSummaryValues s, StatisticalSummaryValues u) {
        Assertions.assertEquals((long)s.getN(), (long)u.getN(), (String)"N");
        UnitTestUtils.customAssertEquals((String)"sum", (double)s.getSum(), (double)u.getSum(), (double)0.0);
        UnitTestUtils.customAssertEquals((String)"var", (double)s.getVariance(), (double)u.getVariance(), (double)0.0);
        UnitTestUtils.customAssertEquals((String)"std", (double)s.getStandardDeviation(), (double)u.getStandardDeviation(), (double)0.0);
        UnitTestUtils.customAssertEquals((String)"mean", (double)s.getMean(), (double)u.getMean(), (double)0.0);
        UnitTestUtils.customAssertEquals((String)"min", (double)s.getMin(), (double)u.getMin(), (double)0.0);
        UnitTestUtils.customAssertEquals((String)"max", (double)s.getMax(), (double)u.getMax(), (double)0.0);
    }

    @Test
    void testToString() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(4.5, 16.0, 10L, 5.0, 4.0, 45.0);
        Locale d = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Assertions.assertEquals((Object)"StatisticalSummaryValues:\nn: 10\nmin: 4.0\nmax: 5.0\nmean: 4.5\nstd dev: 4.0\nvariance: 16.0\nsum: 45.0\n", (Object)u.toString());
        Locale.setDefault(d);
    }
}

