/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.Arrays;
import java.util.function.DoubleConsumer;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.UnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.moment.SecondMoment;
import org.hipparchus.util.FastMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class StorelessUnivariateStatisticAbstractTest
extends UnivariateStatisticAbstractTest {
    protected double[][] smallSamples = new double[][]{new double[0], {1.0}, {1.0, 2.0}, {1.0, 2.0, 3.0}, {1.0, 2.0, 3.0, 4.0}};

    public abstract StorelessUnivariateStatistic getUnivariateStatistic();

    @Override
    public abstract double expectedValue();

    @Test
    public void testIncrementation() {
        StorelessUnivariateStatistic statistic = this.getUnivariateStatistic();
        for (int i = 0; i < this.testArray.length; ++i) {
            statistic.increment(this.testArray[i]);
        }
        Assertions.assertEquals((double)this.expectedValue(), (double)statistic.getResult(), (double)this.getTolerance());
        Assertions.assertEquals((long)this.testArray.length, (long)statistic.getN());
        statistic.clear();
        statistic.incrementAll(this.testArray);
        Assertions.assertEquals((double)this.expectedValue(), (double)statistic.getResult(), (double)this.getTolerance());
        Assertions.assertEquals((long)this.testArray.length, (long)statistic.getN());
        statistic.clear();
        this.checkClearValue(statistic);
        Assertions.assertEquals((long)0L, (long)statistic.getN());
    }

    protected void checkClearValue(StorelessUnivariateStatistic statistic) {
        Assertions.assertTrue((boolean)Double.isNaN(statistic.getResult()));
    }

    @Test
    public void testSerialization() {
        StorelessUnivariateStatistic statistic = this.getUnivariateStatistic();
        UnitTestUtils.checkSerializedEquality((Object)statistic);
        statistic.clear();
        for (int i = 0; i < this.testArray.length; ++i) {
            statistic.increment(this.testArray[i]);
            if (i % 5 != 0) continue;
            statistic = (StorelessUnivariateStatistic)UnitTestUtils.serializeAndRecover((Object)statistic);
        }
        UnitTestUtils.checkSerializedEquality((Object)statistic);
        Assertions.assertEquals((double)this.expectedValue(), (double)statistic.getResult(), (double)this.getTolerance());
        statistic.clear();
        this.checkClearValue(statistic);
    }

    @Test
    public void testEqualsAndHashCode() {
        StorelessUnivariateStatistic statistic = this.getUnivariateStatistic();
        StorelessUnivariateStatistic statistic2 = null;
        Assertions.assertNotEquals((Object)statistic, statistic2, (String)"non-null, compared to null");
        Assertions.assertEquals((Object)statistic, (Object)statistic, (String)"reflexive, non-null");
        int emptyHash = statistic.hashCode();
        statistic2 = this.getUnivariateStatistic();
        Assertions.assertEquals((Object)statistic, (Object)statistic2, (String)"empty stats should be equal");
        Assertions.assertEquals((int)emptyHash, (int)statistic2.hashCode(), (String)"empty stats should have the same hashcode");
        statistic.increment(1.0);
        Assertions.assertEquals((Object)statistic, (Object)statistic, (String)"reflexive, non-empty");
        Assertions.assertNotEquals((Object)statistic, (Object)statistic2, (String)"non-empty, compared to empty");
        Assertions.assertNotEquals((Object)statistic2, (Object)statistic, (String)"non-empty, compared to empty");
        Assertions.assertTrue((statistic.hashCode() != emptyHash ? 1 : 0) != 0, (String)"non-empty stat should have different hashcode from empty stat");
        statistic2.increment(1.0);
        Assertions.assertEquals((Object)statistic, (Object)statistic2, (String)"stats with same data should be equal");
        Assertions.assertEquals((int)statistic.hashCode(), (int)statistic2.hashCode(), (String)"stats with same data should have the same hashcode");
        statistic.increment(Double.POSITIVE_INFINITY);
        Assertions.assertNotEquals((Object)statistic2, (Object)statistic, (String)"stats with different n's should not be equal");
        Assertions.assertTrue((statistic.hashCode() != statistic2.hashCode() ? 1 : 0) != 0, (String)"stats with different n's should have different hashcodes");
        statistic2.increment(Double.POSITIVE_INFINITY);
        Assertions.assertEquals((Object)statistic, (Object)statistic2, (String)"stats with same data should be equal");
        Assertions.assertEquals((int)statistic.hashCode(), (int)statistic2.hashCode(), (String)"stats with same data should have the same hashcode");
        statistic.clear();
        statistic2.clear();
        Assertions.assertEquals((Object)statistic, (Object)statistic2, (String)"cleared stats should be equal");
        Assertions.assertEquals((int)emptyHash, (int)statistic2.hashCode(), (String)"cleared stats should have thashcode of empty stat");
        Assertions.assertEquals((int)emptyHash, (int)statistic.hashCode(), (String)"cleared stats should have thashcode of empty stat");
    }

    @Test
    public void testMomentSmallSamples() {
        StorelessUnivariateStatistic stat = this.getUnivariateStatistic();
        if (stat instanceof SecondMoment) {
            SecondMoment moment = (SecondMoment)this.getUnivariateStatistic();
            Assertions.assertTrue((boolean)Double.isNaN(moment.getResult()));
            moment.increment(1.0);
            Assertions.assertEquals((double)0.0, (double)moment.getResult(), (double)0.0);
        }
    }

    @Test
    public void testConsistency() {
        StorelessUnivariateStatistic stat = this.getUnivariateStatistic();
        stat.incrementAll(this.testArray);
        Assertions.assertEquals((double)stat.getResult(), (double)stat.evaluate(this.testArray), (double)this.getTolerance());
        for (int i = 0; i < this.smallSamples.length; ++i) {
            stat.clear();
            for (int j = 0; j < this.smallSamples[i].length; ++j) {
                stat.increment(this.smallSamples[i][j]);
            }
            UnitTestUtils.customAssertEquals((double)stat.getResult(), (double)stat.evaluate(this.smallSamples[i]), (double)this.getTolerance());
        }
    }

    @Test
    public void testCopyConsistency() {
        StorelessUnivariateStatistic master = this.getUnivariateStatistic();
        StorelessUnivariateStatistic replica = null;
        long index = FastMath.round((double)(FastMath.random() * (double)this.testArray.length));
        master.incrementAll(this.testArray, 0, (int)index);
        replica = master.copy();
        Assertions.assertEquals((Object)replica, (Object)master);
        Assertions.assertEquals((Object)master, (Object)replica);
        master.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        replica.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        Assertions.assertEquals((Object)replica, (Object)master);
        Assertions.assertEquals((Object)master, (Object)replica);
    }

    @Test
    public void testSerial() {
        StorelessUnivariateStatistic s = this.getUnivariateStatistic();
        Assertions.assertEquals((Object)s, (Object)UnitTestUtils.serializeAndRecover((Object)s));
    }

    @Test
    public void testEvaluateInternalState() {
        StorelessUnivariateStatistic stat = this.getUnivariateStatistic();
        stat.evaluate(this.testArray);
        Assertions.assertEquals((long)0L, (long)stat.getN());
        stat.incrementAll(this.testArray);
        StorelessUnivariateStatistic savedStatistic = stat.copy();
        Assertions.assertNotEquals((double)stat.getResult(), (double)stat.evaluate(this.testArray, 0, 5), (double)this.getTolerance());
        Assertions.assertEquals((double)savedStatistic.getResult(), (double)stat.getResult(), (double)0.0);
        Assertions.assertEquals((long)savedStatistic.getN(), (long)stat.getN());
    }

    @Test
    public <T> void testAggregate() {
        StorelessUnivariateStatistic statU = this.getUnivariateStatistic();
        if (!(statU instanceof AggregatableStatistic)) {
            return;
        }
        AggregatableStatistic aggregated = (AggregatableStatistic)this.getUnivariateStatistic();
        StorelessUnivariateStatistic statAgg = (StorelessUnivariateStatistic)aggregated;
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        StorelessUnivariateStatistic statA = this.getUnivariateStatistic();
        for (int i = 0; i < 10; ++i) {
            double val = randomDataGenerator.nextGaussian();
            statA.increment(val);
            statU.increment(val);
        }
        aggregated.aggregate((Object)statA);
        Assertions.assertEquals((double)statA.getN(), (double)statAgg.getN(), (double)this.getTolerance());
        Assertions.assertEquals((double)statA.getResult(), (double)statAgg.getResult(), (double)this.getTolerance());
        StorelessUnivariateStatistic statB = this.getUnivariateStatistic();
        for (int i = 0; i < 4; ++i) {
            double val = randomDataGenerator.nextGaussian();
            statB.increment(val);
            statU.increment(val);
        }
        aggregated.aggregate((Object)statB);
        Assertions.assertEquals((double)statU.getN(), (double)statAgg.getN(), (double)this.getTolerance());
        Assertions.assertEquals((double)statU.getResult(), (double)statAgg.getResult(), (double)this.getTolerance());
    }

    @Test
    public void testConsume() {
        StorelessUnivariateStatistic stat = this.getUnivariateStatistic();
        Arrays.stream(this.testArray).forEach((DoubleConsumer)stat);
        Assertions.assertEquals((double)this.expectedValue(), (double)stat.getResult(), (double)this.getTolerance());
        StorelessUnivariateStatistic stat2 = this.getUnivariateStatistic();
        stat2.incrementAll(this.testArray);
        Assertions.assertEquals((double)stat2.getResult(), (double)stat.getResult(), (double)this.getTolerance());
    }
}

