/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.moment.GeometricMean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeometricMeanTest
extends StorelessUnivariateStatisticAbstractTest {
    public GeometricMean getUnivariateStatistic() {
        return new GeometricMean();
    }

    @Override
    public double expectedValue() {
        return this.geoMean;
    }

    @Test
    void testSpecialValues() {
        GeometricMean mean = this.getUnivariateStatistic();
        Assertions.assertTrue((boolean)Double.isNaN(mean.getResult()));
        mean.increment(1.0);
        Assertions.assertFalse((boolean)Double.isNaN(mean.getResult()));
        mean.increment(0.0);
        Assertions.assertEquals((double)0.0, (double)mean.getResult(), (double)0.0);
        mean.increment(Double.POSITIVE_INFINITY);
        Assertions.assertTrue((boolean)Double.isNaN(mean.getResult()));
        mean.clear();
        Assertions.assertTrue((boolean)Double.isNaN(mean.getResult()));
        mean.increment(Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)mean.getResult(), (double)0.0);
        mean.increment(-2.0);
        Assertions.assertTrue((boolean)Double.isNaN(mean.getResult()));
    }
}

