/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.moment.SecondMoment;
import org.hipparchus.stat.descriptive.moment.StandardDeviation;
import org.hipparchus.util.FastMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StandardDeviationTest
extends StorelessUnivariateStatisticAbstractTest {
    public StandardDeviation getUnivariateStatistic() {
        return new StandardDeviation();
    }

    @Override
    public double expectedValue() {
        return this.std;
    }

    @Test
    void testNaN() {
        StandardDeviation std = this.getUnivariateStatistic();
        Assertions.assertTrue((boolean)Double.isNaN(std.getResult()));
        std.increment(1.0);
        Assertions.assertEquals((double)0.0, (double)std.getResult(), (double)0.0);
    }

    @Test
    void testPopulation() {
        double[] values = new double[]{-1.0, 3.1, 4.0, -2.1, 22.0, 11.7, 3.0, 14.0};
        double sigma = this.populationStandardDeviation(values);
        SecondMoment m = new SecondMoment();
        m.incrementAll(values);
        StandardDeviation s1 = this.getUnivariateStatistic();
        s1 = s1.withBiasCorrection(false);
        Assertions.assertEquals((double)sigma, (double)s1.evaluate(values), (double)1.0E-14);
        s1.incrementAll(values);
        Assertions.assertEquals((double)sigma, (double)s1.getResult(), (double)1.0E-14);
        s1 = new StandardDeviation(false, m);
        Assertions.assertEquals((double)sigma, (double)s1.getResult(), (double)1.0E-14);
        s1 = new StandardDeviation(false);
        Assertions.assertEquals((double)sigma, (double)s1.evaluate(values), (double)1.0E-14);
        s1.incrementAll(values);
        Assertions.assertEquals((double)sigma, (double)s1.getResult(), (double)1.0E-14);
    }

    protected double populationStandardDeviation(double[] v) {
        double mean = StatUtils.mean((double[])v);
        double sum = 0.0;
        for (double val : v) {
            sum += (val - mean) * (val - mean);
        }
        return FastMath.sqrt((double)(sum / (double)v.length));
    }
}

