/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.summary;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.summary.Product;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProductTest
extends StorelessUnivariateStatisticAbstractTest {
    public Product getUnivariateStatistic() {
        return new Product();
    }

    @Override
    public double getTolerance() {
        return 1.0E9;
    }

    @Override
    public double expectedValue() {
        return this.product;
    }

    public double expectedWeightedValue() {
        return this.weightedProduct;
    }

    @Test
    void testSpecialValues() {
        Product product = this.getUnivariateStatistic();
        Assertions.assertEquals((double)1.0, (double)product.getResult(), (double)0.0);
        product.increment(1.0);
        Assertions.assertEquals((double)1.0, (double)product.getResult(), (double)0.0);
        product.increment(Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)product.getResult(), (double)0.0);
        product.increment(Double.NEGATIVE_INFINITY);
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)product.getResult(), (double)0.0);
        product.increment(Double.NaN);
        Assertions.assertTrue((boolean)Double.isNaN(product.getResult()));
        product.increment(1.0);
        Assertions.assertTrue((boolean)Double.isNaN(product.getResult()));
    }

    @Test
    void testWeightedProduct() {
        Product product = new Product();
        Assertions.assertEquals((double)this.expectedWeightedValue(), (double)product.evaluate(this.testArray, this.testWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assertions.assertEquals((double)this.expectedValue(), (double)product.evaluate(this.testArray, this.unitWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
    }

    @Override
    protected void checkClearValue(StorelessUnivariateStatistic statistic) {
        Assertions.assertEquals((double)1.0, (double)statistic.getResult(), (double)0.0);
    }
}

