/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.distribution.discrete.BinomialDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.inference.AlternativeHypothesis;
import org.hipparchus.stat.inference.BinomialTest;
import org.hipparchus.util.FastMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BinomialTestTest {
    protected BinomialTest testStatistic = new BinomialTest();
    private static int successes = 51;
    private static int trials = 235;
    private static double probability = 0.16666666666666666;

    BinomialTestTest() {
    }

    @Test
    void testBinomialTestPValues() {
        Assertions.assertEquals((double)0.04375, (double)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.TWO_SIDED), (double)1.0E-4);
        Assertions.assertEquals((double)0.02654, (double)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.GREATER_THAN), (double)1.0E-4);
        Assertions.assertEquals((double)0.982, (double)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.LESS_THAN), (double)1.0E-4);
    }

    @Test
    void testBinomialTestExceptions() {
        try {
            this.testStatistic.binomialTest(10, -1, 0.5, AlternativeHypothesis.TWO_SIDED);
            Assertions.fail((String)"Expected not positive exception");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.binomialTest(10, 11, 0.5, AlternativeHypothesis.TWO_SIDED);
            Assertions.fail((String)"Expected illegal argument exception");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.binomialTest(10, 11, 0.5, null);
            Assertions.fail((String)"Expected illegal argument exception");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testBinomialTestAcceptReject() {
        double alpha05 = 0.05;
        double alpha01 = 0.01;
        Assertions.assertTrue((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.TWO_SIDED, alpha05));
        Assertions.assertTrue((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.GREATER_THAN, alpha05));
        Assertions.assertFalse((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.LESS_THAN, alpha05));
        Assertions.assertFalse((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.TWO_SIDED, alpha01));
        Assertions.assertFalse((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.GREATER_THAN, alpha01));
        Assertions.assertFalse((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.LESS_THAN, alpha05));
    }

    @Test
    void testAllSuccessesTwoSidedHighP() {
        Assertions.assertEquals((double)1.0, (double)this.testStatistic.binomialTest(200, 200, 0.9950429, AlternativeHypothesis.TWO_SIDED), (double)Double.MIN_VALUE);
    }

    @Test
    void testAllSuccessesTwoSidedEvenP() {
        Assertions.assertEquals((double)(2.0 * FastMath.pow((double)0.5, (int)5)), (double)this.testStatistic.binomialTest(5, 5, 0.5, AlternativeHypothesis.TWO_SIDED), (double)Double.MIN_VALUE);
    }

    @Test
    void testNoSuccessesTwoSidedEvenP() {
        Assertions.assertEquals((double)(2.0 * FastMath.pow((double)0.5, (int)5)), (double)this.testStatistic.binomialTest(5, 0, 0.5, AlternativeHypothesis.TWO_SIDED), (double)Double.MIN_VALUE);
    }

    @Test
    void testAllSuccessesTwoSidedLowP() {
        BinomialDistribution dist = new BinomialDistribution(5, 0.4);
        Assertions.assertEquals((double)dist.probability(5), (double)this.testStatistic.binomialTest(5, 5, 0.4, AlternativeHypothesis.TWO_SIDED), (double)Double.MIN_VALUE);
    }

    @Test
    void testNoSuccessesTwoSidedHighP() {
        BinomialDistribution dist = new BinomialDistribution(5, 0.9);
        Assertions.assertEquals((double)dist.probability(0), (double)this.testStatistic.binomialTest(5, 0, 0.9, AlternativeHypothesis.TWO_SIDED), (double)Double.MIN_VALUE);
    }

    @Test
    void testNoSuccessesTwoSidedLowP() {
        BinomialDistribution dist = new BinomialDistribution(5, 0.2);
        Assertions.assertEquals((double)(1.0 - dist.probability(1)), (double)this.testStatistic.binomialTest(5, 0, 0.2, AlternativeHypothesis.TWO_SIDED), (double)Double.MIN_VALUE);
    }

    @Test
    void testNoSuccessesTwoSidedVeryLowP() {
        Assertions.assertEquals((double)1.0, (double)this.testStatistic.binomialTest(5, 0, 0.001, AlternativeHypothesis.TWO_SIDED), (double)Double.MIN_VALUE);
    }
}

