/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.interval;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.interval.ConfidenceInterval;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class BinomialProportionAbstractTest {
    protected BinomialProportionMethod testMethod;
    private final int trials = 500;
    private final double probabilityOfSuccess = 0.1;
    private final double confidenceLevel = 0.9;

    protected abstract BinomialProportionMethod getBinomialProportionMethod();

    protected ConfidenceInterval createStandardTestInterval() {
        return this.testMethod.calculate(500, 0.1, 0.9);
    }

    @BeforeEach
    public void setUp() {
        this.testMethod = this.getBinomialProportionMethod();
    }

    @Test
    public void testZeroConfidencelevel() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> this.testMethod.calculate(500, 0.1, 0.0));
    }

    @Test
    public void testOneConfidencelevel() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> this.testMethod.calculate(500, 0.1, 1.0));
    }

    @Test
    public void testZeroTrials() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> this.testMethod.calculate(0, 0.0, 0.9));
    }

    @Test
    public void testNegativeSuccesses() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> this.testMethod.calculate(500, -1.0, 0.9));
    }

    @Test
    public void testSuccessesExceedingTrials() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> this.testMethod.calculate(500, 501.0, 0.9));
    }

    @FunctionalInterface
    public static interface BinomialProportionMethod {
        public ConfidenceInterval calculate(int var1, double var2, double var4);
    }
}

