/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.ranking;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.JDKRandomGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.stat.ranking.NaNStrategy;
import org.hipparchus.stat.ranking.NaturalRanking;
import org.hipparchus.stat.ranking.TiesStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NaturalRankingTest {
    private final double[] exampleData = new double[]{20.0, 17.0, 30.0, 42.3, 17.0, 50.0, Double.NaN, Double.NEGATIVE_INFINITY, 17.0};
    private final double[] tiesFirst = new double[]{0.0, 0.0, 2.0, 1.0, 4.0};
    private final double[] tiesLast = new double[]{4.0, 4.0, 1.0, 0.0};
    private final double[] multipleNaNs = new double[]{0.0, 1.0, Double.NaN, Double.NaN};
    private final double[] multipleTies = new double[]{3.0, 2.0, 5.0, 5.0, 6.0, 6.0, 1.0};
    private final double[] allSame = new double[]{0.0, 0.0, 0.0, 0.0};

    NaturalRankingTest() {
    }

    @Test
    void testDefault() {
        double[] ranks;
        NaturalRanking ranking = new NaturalRanking();
        try {
            ranks = ranking.rank(this.exampleData);
            Assertions.fail((String)"expected MathIllegalArgumentException due to NaNStrategy.FAILED");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        ranks = ranking.rank(this.tiesFirst);
        double[] correctRanks = new double[]{1.5, 1.5, 4.0, 3.0, 5.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.5, 3.5, 2.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        try {
            ranks = ranking.rank(this.multipleNaNs);
            Assertions.fail((String)"expected MathIllegalArgumentException due to NaNStrategy.FAILED");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.5, 4.5, 6.5, 6.5, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{2.5, 2.5, 2.5, 2.5};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
    }

    @Test
    void testNaNsMaximalTiesMinimum() {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.MAXIMAL, TiesStrategy.MINIMUM);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{5.0, 2.0, 6.0, 7.0, 2.0, 8.0, 9.0, 1.0, 2.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{1.0, 1.0, 4.0, 3.0, 5.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.0, 3.0, 2.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{1.0, 2.0, 3.0, 3.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.0, 4.0, 6.0, 6.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{1.0, 1.0, 1.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
    }

    @Test
    void testNaNsRemovedTiesSequential() {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.REMOVED, TiesStrategy.SEQUENTIAL);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{5.0, 2.0, 6.0, 7.0, 3.0, 8.0, 1.0, 4.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{1.0, 2.0, 4.0, 3.0, 5.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.0, 4.0, 2.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{1.0, 2.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.0, 5.0, 6.0, 7.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{1.0, 2.0, 3.0, 4.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
    }

    @Test
    void testNaNsMinimalTiesMaximum() {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.MINIMAL, TiesStrategy.MAXIMUM);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{6.0, 5.0, 7.0, 8.0, 5.0, 9.0, 2.0, 2.0, 5.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{2.0, 2.0, 4.0, 3.0, 5.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{4.0, 4.0, 2.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{3.0, 4.0, 2.0, 2.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 5.0, 5.0, 7.0, 7.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{4.0, 4.0, 4.0, 4.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
    }

    @Test
    void testNaNsMinimalTiesAverage() {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.MINIMAL);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{6.0, 4.0, 7.0, 8.0, 4.0, 9.0, 1.5, 1.5, 4.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{1.5, 1.5, 4.0, 3.0, 5.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.5, 3.5, 2.0, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{3.0, 4.0, 1.5, 1.5};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.5, 4.5, 6.5, 6.5, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{2.5, 2.5, 2.5, 2.5};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
    }

    @Test
    void testNaNsFixedTiesRandom() {
        JDKRandomGenerator randomGenerator = new JDKRandomGenerator();
        randomGenerator.setSeed(1000);
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.FIXED, (RandomGenerator)randomGenerator);
        double[] ranks = ranking.rank(this.exampleData);
        double[][] correctRanks = new double[][]{{5.0}, {2.0, 3.0, 4.0}, {6.0}, {7.0}, {2.0, 3.0, 4.0}, {8.0}, {Double.NaN}, {1.0}, {2.0, 3.0, 4.0}};
        UnitTestUtils.customAssertContains((double[][])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[][]{{1.0, 2.0}, {1.0, 2.0}, {4.0}, {3.0}, {5.0}};
        UnitTestUtils.customAssertContains((double[][])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[][]{{3.0, 4.0}, {3.0, 4.0}, {2.0}, {1.0}};
        UnitTestUtils.customAssertContains((double[][])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleNaNs);
        UnitTestUtils.customAssertEquals((double[])new double[]{1.0, 2.0, Double.NaN, Double.NaN}, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[][]{{3.0}, {2.0}, {4.0, 5.0}, {4.0, 5.0}, {6.0, 7.0}, {6.0, 7.0}, {1.0}};
        UnitTestUtils.customAssertContains((double[][])correctRanks, (double[])ranks, (double)0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}};
        UnitTestUtils.customAssertContains((double[][])correctRanks, (double[])ranks, (double)0.0);
    }

    @Test
    void testNaNsAndInfs() {
        double[] data = new double[]{0.0, Double.POSITIVE_INFINITY, Double.NaN, Double.NEGATIVE_INFINITY};
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.MAXIMAL);
        double[] ranks = ranking.rank(data);
        double[] correctRanks = new double[]{2.0, 3.5, 3.5, 1.0};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
        ranking = new NaturalRanking(NaNStrategy.MINIMAL);
        ranks = ranking.rank(data);
        correctRanks = new double[]{3.0, 4.0, 1.5, 1.5};
        UnitTestUtils.customAssertEquals((double[])correctRanks, (double[])ranks, (double)0.0);
    }

    @Test
    void testNaNsFailed() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> {
            double[] data = new double[]{0.0, Double.POSITIVE_INFINITY, Double.NaN, Double.NEGATIVE_INFINITY};
            NaturalRanking ranking = new NaturalRanking(NaNStrategy.FAILED);
            ranking.rank(data);
        });
    }

    @Test
    void testNoNaNsFailed() {
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0};
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.FAILED);
        double[] ranks = ranking.rank(data);
        UnitTestUtils.customAssertEquals((double[])data, (double[])ranks, (double)0.0);
    }
}

