/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.regression;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.stat.regression.AbstractMultipleLinearRegression;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class MultipleLinearRegressionAbstractTest {
    protected AbstractMultipleLinearRegression regression;

    @BeforeEach
    public void setUp() {
        this.regression = this.createRegression();
    }

    protected abstract AbstractMultipleLinearRegression createRegression();

    protected abstract int getNumberOfRegressors();

    protected abstract int getSampleSize();

    @Test
    public void canEstimateRegressionParameters() {
        double[] beta = this.regression.estimateRegressionParameters();
        Assertions.assertEquals((int)this.getNumberOfRegressors(), (int)beta.length);
    }

    @Test
    public void canEstimateResiduals() {
        double[] e = this.regression.estimateResiduals();
        Assertions.assertEquals((int)this.getSampleSize(), (int)e.length);
    }

    @Test
    public void canEstimateRegressionParametersVariance() {
        double[][] variance = this.regression.estimateRegressionParametersVariance();
        Assertions.assertEquals((int)this.getNumberOfRegressors(), (int)variance.length);
    }

    @Test
    public void canEstimateRegressandVariance() {
        if (this.getSampleSize() > this.getNumberOfRegressors()) {
            double variance = this.regression.estimateRegressandVariance();
            Assertions.assertTrue((variance > 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNewSample() {
        double[] design = new double[]{1.0, 19.0, 22.0, 33.0, 2.0, 20.0, 30.0, 40.0, 3.0, 25.0, 35.0, 45.0, 4.0, 27.0, 37.0, 47.0};
        double[] y = new double[]{1.0, 2.0, 3.0, 4.0};
        double[][] x = new double[][]{{19.0, 22.0, 33.0}, {20.0, 30.0, 40.0}, {25.0, 35.0, 45.0}, {27.0, 37.0, 47.0}};
        AbstractMultipleLinearRegression regression = this.createRegression();
        regression.newSampleData(design, 4, 3);
        RealMatrix flatX = regression.getX().copy();
        RealVector flatY = regression.getY().copy();
        regression.newXSampleData((double[][])x);
        regression.newYSampleData(y);
        Assertions.assertEquals((Object)flatX, (Object)regression.getX());
        Assertions.assertEquals((Object)flatY, (Object)regression.getY());
        regression.setNoIntercept(true);
        regression.newSampleData(design, 4, 3);
        flatX = regression.getX().copy();
        flatY = regression.getY().copy();
        regression.newXSampleData((double[][])x);
        regression.newYSampleData(y);
        Assertions.assertEquals((Object)flatX, (Object)regression.getX());
        Assertions.assertEquals((Object)flatY, (Object)regression.getY());
    }

    @Test
    public void testNewSampleNullData() {
        Assertions.assertThrows(NullArgumentException.class, () -> {
            double[] data = null;
            this.createRegression().newSampleData(data, 2, 3);
        });
    }

    @Test
    public void testNewSampleInvalidData() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> {
            double[] data = new double[]{1.0, 2.0, 3.0, 4.0};
            this.createRegression().newSampleData(data, 2, 3);
        });
    }

    @Test
    public void testNewSampleInsufficientData() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> {
            double[] data = new double[]{1.0, 2.0, 3.0, 4.0};
            this.createRegression().newSampleData(data, 1, 3);
        });
    }

    @Test
    public void testXSampleDataNull() {
        Assertions.assertThrows(NullArgumentException.class, () -> this.createRegression().newXSampleData(null));
    }

    @Test
    public void testYSampleDataNull() {
        Assertions.assertThrows(NullArgumentException.class, () -> this.createRegression().newYSampleData(null));
    }
}

