/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.hipparchus.stat.descriptive.DescriptiveStatistics;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CertifiedDataTest {
    protected double mean = Double.NaN;
    protected double std = Double.NaN;

    CertifiedDataTest() {
    }

    @Test
    void testSummaryStatistics() throws Exception {
        StreamingStatistics u = new StreamingStatistics();
        this.loadStats("data/PiDigits.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-13, (String)"PiDigits: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-13, (String)"PiDigits: mean");
        this.loadStats("data/Mavro.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"Mavro: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-14, (String)"Mavro: mean");
        this.loadStats("data/Michelso.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-13, (String)"Michelso: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-13, (String)"Michelso: mean");
        this.loadStats("data/NumAcc1.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"NumAcc1: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-14, (String)"NumAcc1: mean");
        this.loadStats("data/NumAcc2.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"NumAcc2: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-14, (String)"NumAcc2: mean");
    }

    @Test
    void testDescriptiveStatistics() throws Exception {
        DescriptiveStatistics u = new DescriptiveStatistics();
        this.loadStats("data/PiDigits.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"PiDigits: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-14, (String)"PiDigits: mean");
        this.loadStats("data/Mavro.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"Mavro: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-14, (String)"Mavro: mean");
        this.loadStats("data/Michelso.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"Michelso: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-14, (String)"Michelso: mean");
        this.loadStats("data/NumAcc1.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"NumAcc1: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-14, (String)"NumAcc1: mean");
        this.loadStats("data/NumAcc2.txt", u);
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"NumAcc2: std");
        Assertions.assertEquals((double)this.mean, (double)u.getMean(), (double)1.0E-14, (String)"NumAcc2: mean");
    }

    private void loadStats(String resource, Object u) throws Exception {
        DescriptiveStatistics d = null;
        StreamingStatistics s = null;
        if (u instanceof DescriptiveStatistics) {
            d = (DescriptiveStatistics)u;
            d.clear();
        } else {
            s = (StreamingStatistics)u;
            s.clear();
        }
        this.mean = Double.NaN;
        this.std = Double.NaN;
        InputStream resourceAsStream = CertifiedDataTest.class.getResourceAsStream(resource);
        Assertions.assertNotNull((Object)resourceAsStream, (String)("Could not find resource " + resource));
        BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream));
        String line = null;
        for (int j = 0; j < 60; ++j) {
            line = in.readLine();
            if (j == 40) {
                this.mean = Double.parseDouble(line.substring(line.lastIndexOf(":") + 1).trim());
            }
            if (j != 41) continue;
            this.std = Double.parseDouble(line.substring(line.lastIndexOf(":") + 1).trim());
        }
        line = in.readLine();
        while (line != null) {
            if (d != null) {
                d.addValue(Double.parseDouble(line.trim()));
            } else {
                s.addValue(Double.parseDouble(line.trim()));
            }
            line = in.readLine();
        }
        resourceAsStream.close();
        in.close();
    }
}

