/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.stat.Frequency;
import org.hipparchus.stat.LongFrequency;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class LongFrequencyTest {
    private static final long ONE_LONG = 1L;
    private static final long TWO_LONG = 2L;
    private static final long THREE_LONG = 3L;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final double TOLERANCE = 1.0E-14;

    LongFrequencyTest() {
    }

    @Test
    void testCounts() {
        LongFrequency f = new LongFrequency();
        Assertions.assertEquals((long)0L, (long)f.getSumFreq(), (String)"total count");
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(1L));
        Assertions.assertEquals((long)3L, (long)f.getCount((Comparable)Long.valueOf(1L)), (String)"one frequency count");
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(2L)), (String)"two frequency count");
        Assertions.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(3L)), (String)"three frequency count");
        Assertions.assertEquals((long)4L, (long)f.getSumFreq(), (String)"total count");
        Assertions.assertEquals((long)0L, (long)f.getCumFreq((Comparable)Long.valueOf(0L)), (String)"zero cumulative frequency");
        Assertions.assertEquals((long)3L, (long)f.getCumFreq((Comparable)Long.valueOf(1L)), (String)"one cumulative frequency");
        Assertions.assertEquals((long)4L, (long)f.getCumFreq((Comparable)Long.valueOf(2L)), (String)"two cumulative frequency");
        Assertions.assertEquals((long)4L, (long)f.getCumFreq((Comparable)Long.valueOf(5L)), (String)"five cumulative frequency");
        f.clear();
        Assertions.assertEquals((long)0L, (long)f.getSumFreq(), (String)"total count");
    }

    @Test
    void testPcts() {
        LongFrequency f = new LongFrequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        Assertions.assertEquals((double)0.25, (double)f.getPct((Comparable)Long.valueOf(1L)), (double)1.0E-14, (String)"one pct");
        Assertions.assertEquals((double)0.25, (double)f.getPct((Comparable)Long.valueOf(2L)), (double)1.0E-14, (String)"two pct");
        Assertions.assertEquals((double)0.5, (double)f.getPct((Comparable)Long.valueOf(3L)), (double)1.0E-14, (String)"three pct");
        Assertions.assertEquals((double)0.0, (double)f.getPct((Comparable)Long.valueOf(5L)), (double)1.0E-14, (String)"five pct");
        Assertions.assertEquals((double)0.25, (double)f.getCumPct((Comparable)Long.valueOf(1L)), (double)1.0E-14, (String)"one cum pct");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct((Comparable)Long.valueOf(2L)), (double)1.0E-14, (String)"two cum pct");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Long.valueOf(3L)), (double)1.0E-14, (String)"three cum pct");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Long.valueOf(5L)), (double)1.0E-14, (String)"five cum pct");
        Assertions.assertEquals((double)0.0, (double)f.getCumPct((Comparable)Long.valueOf(0L)), (double)1.0E-14, (String)"zero cum pct");
    }

    @Test
    void testToString() throws Exception {
        LongFrequency f = new LongFrequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        String s = f.toString();
        Assertions.assertNotNull((Object)s);
        BufferedReader reader = new BufferedReader(new StringReader(s));
        String line = reader.readLine();
        Assertions.assertNotNull((Object)line);
        line = reader.readLine();
        Assertions.assertNotNull((Object)line);
        line = reader.readLine();
        Assertions.assertNotNull((Object)line);
        line = reader.readLine();
        Assertions.assertNull((Object)line);
    }

    @Test
    void testLongValues() {
        LongFrequency f = new LongFrequency();
        Integer obj1 = null;
        obj1 = 1;
        Integer int1 = 1;
        f.addValue(obj1.intValue());
        f.addValue(int1.intValue());
        f.addValue(2);
        f.addValue(Long.valueOf(2L).intValue());
        Assertions.assertEquals((long)2L, (long)f.getCount(1), (String)"Integer 1 count");
        Assertions.assertEquals((long)2L, (long)f.getCount(Integer.valueOf(1).intValue()), (String)"Integer 1 count");
        Assertions.assertEquals((long)2L, (long)f.getCount(Long.valueOf(1L).intValue()), (String)"Integer 1 count");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct(1), (double)1.0E-14, (String)"Integer 1 cumPct");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct(Long.valueOf(1L).intValue()), (double)1.0E-14, (String)"Integer 1 cumPct");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct(Integer.valueOf(1).intValue()), (double)1.0E-14, (String)"Integer 1 cumPct");
        f.incrementValue(1, -2L);
        f.incrementValue(3, 5L);
        Assertions.assertEquals((long)0L, (long)f.getCount(1), (String)"Integer 1 count");
        Assertions.assertEquals((long)5L, (long)f.getCount(3), (String)"Integer 3 count");
        Iterator it = f.valuesIterator();
        while (it.hasNext()) {
            Assertions.assertTrue((boolean)(it.next() instanceof Long));
        }
    }

    @Test
    void testSerial() {
        LongFrequency f = new LongFrequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        Assertions.assertEquals((Object)f, (Object)UnitTestUtils.serializeAndRecover((Object)f));
    }

    @Test
    void testGetUniqueCount() {
        LongFrequency f = new LongFrequency();
        Assertions.assertEquals((int)0, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assertions.assertEquals((int)1, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assertions.assertEquals((int)1, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(2L));
        Assertions.assertEquals((int)2, (int)f.getUniqueCount());
    }

    @Test
    void testIncrement() {
        LongFrequency f = new LongFrequency();
        Assertions.assertEquals((int)0, (int)f.getUniqueCount());
        f.incrementValue((Comparable)Long.valueOf(1L), 1L);
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        f.incrementValue((Comparable)Long.valueOf(1L), 4L);
        Assertions.assertEquals((long)5L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        f.incrementValue((Comparable)Long.valueOf(1L), -5L);
        Assertions.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(1L)));
    }

    @Test
    void testMerge() {
        LongFrequency f = new LongFrequency();
        Assertions.assertEquals((int)0, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        Assertions.assertEquals((int)2, (int)f.getUniqueCount());
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        LongFrequency g = new LongFrequency();
        g.addValue((Comparable)Long.valueOf(1L));
        g.addValue((Comparable)Long.valueOf(3L));
        g.addValue((Comparable)Long.valueOf(3L));
        Assertions.assertEquals((int)2, (int)g.getUniqueCount());
        Assertions.assertEquals((long)1L, (long)g.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)2L, (long)g.getCount((Comparable)Long.valueOf(3L)));
        f.merge((Frequency)g);
        Assertions.assertEquals((int)3, (int)f.getUniqueCount());
        Assertions.assertEquals((long)3L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(3L)));
    }

    @Test
    void testMergeCollection() {
        LongFrequency f = new LongFrequency();
        Assertions.assertEquals((int)0, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assertions.assertEquals((int)1, (int)f.getUniqueCount());
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        LongFrequency g = new LongFrequency();
        g.addValue((Comparable)Long.valueOf(2L));
        LongFrequency h = new LongFrequency();
        h.addValue((Comparable)Long.valueOf(3L));
        ArrayList<LongFrequency> coll = new ArrayList<LongFrequency>();
        coll.add(g);
        coll.add(h);
        f.merge(coll);
        Assertions.assertEquals((int)3, (int)f.getUniqueCount());
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(3L)));
    }

    @Test
    void testMode() {
        LongFrequency f = new LongFrequency();
        List mode = f.getMode();
        Assertions.assertEquals((int)0, (int)mode.size());
        f.addValue((Comparable)Long.valueOf(3L));
        mode = f.getMode();
        Assertions.assertEquals((int)1, (int)mode.size());
        Assertions.assertEquals((Long)3L, (Long)((Long)mode.get(0)));
        f.addValue((Comparable)Long.valueOf(2L));
        mode = f.getMode();
        Assertions.assertEquals((int)2, (int)mode.size());
        Assertions.assertEquals((Long)2L, (Long)((Long)mode.get(0)));
        Assertions.assertEquals((Long)3L, (Long)((Long)mode.get(1)));
        f.addValue((Comparable)Long.valueOf(2L));
        mode = f.getMode();
        Assertions.assertEquals((int)1, (int)mode.size());
        Assertions.assertEquals((Long)2L, (Long)((Long)mode.get(0)));
        Assertions.assertFalse((boolean)mode.contains(1L));
        Assertions.assertTrue((boolean)mode.contains(2L));
    }
}

