/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.DescriptiveStatistics;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class StatUtilsTest {
    private static final double ONE = 1.0;
    private static final float TWO = 2.0f;
    private static final int THREE = 3;
    private static final double MEAN = 2.0;
    private static final double SUMSQ = 18.0;
    private static final double SUM = 8.0;
    private static final double VAR = 0.6666666666666666;
    private static final double MIN = 1.0;
    private static final double MAX = 3.0;
    private static final double TOLERANCE = 1.0E-14;
    private static final double NAN = Double.NaN;

    StatUtilsTest() {
    }

    @Test
    void testStats() {
        double[] values = new double[]{1.0, 2.0, 2.0, 3.0};
        Assertions.assertEquals((double)8.0, (double)StatUtils.sum((double[])values), (double)1.0E-14, (String)"sum");
        Assertions.assertEquals((double)18.0, (double)StatUtils.sumSq((double[])values), (double)1.0E-14, (String)"sumsq");
        Assertions.assertEquals((double)0.6666666666666666, (double)StatUtils.variance((double[])values), (double)1.0E-14, (String)"var");
        Assertions.assertEquals((double)0.6666666666666666, (double)StatUtils.variance((double[])values, (double)2.0), (double)1.0E-14, (String)"var with mean");
        Assertions.assertEquals((double)2.0, (double)StatUtils.mean((double[])values), (double)1.0E-14, (String)"mean");
        Assertions.assertEquals((double)1.0, (double)StatUtils.min((double[])values), (double)1.0E-14, (String)"min");
        Assertions.assertEquals((double)3.0, (double)StatUtils.max((double[])values), (double)1.0E-14, (String)"max");
    }

    @Test
    void testN0andN1Conditions() {
        double[] values = new double[]{};
        Assertions.assertTrue((boolean)Double.isNaN(StatUtils.mean((double[])values)), (String)"Mean of n = 0 set should be NaN");
        Assertions.assertTrue((boolean)Double.isNaN(StatUtils.variance((double[])values)), (String)"Variance of n = 0 set should be NaN");
        values = new double[]{1.0};
        Assertions.assertEquals((double)1.0, (double)StatUtils.mean((double[])values), (double)0.0, (String)"Mean of n = 1 set should be value of single item n1");
        Assertions.assertEquals((double)0.0, (double)StatUtils.variance((double[])values), (double)0.0, (String)"Variance of n = 1 set should be zero");
    }

    @Test
    void testArrayIndexConditions() {
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0};
        Assertions.assertEquals((double)5.0, (double)StatUtils.sum((double[])values, (int)1, (int)2), (double)Double.MIN_VALUE, (String)"Sum not expected");
        Assertions.assertEquals((double)3.0, (double)StatUtils.sum((double[])values, (int)0, (int)2), (double)Double.MIN_VALUE, (String)"Sum not expected");
        Assertions.assertEquals((double)7.0, (double)StatUtils.sum((double[])values, (int)2, (int)2), (double)Double.MIN_VALUE, (String)"Sum not expected");
        try {
            StatUtils.sum((double[])values, (int)2, (int)3);
            Assertions.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            StatUtils.sum((double[])values, (int)-1, (int)2);
            Assertions.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    void testSumSq() {
        double[] x = null;
        try {
            StatUtils.sumSq(x);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.sumSq(x, (int)0, (int)4);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)0.0, (double)StatUtils.sumSq((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)0.0, (double)StatUtils.sumSq((double[])x, (int)0, (int)0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)4.0, (double)StatUtils.sumSq((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)4.0, (double)StatUtils.sumSq((double[])x, (int)0, (int)1), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)18.0, (double)StatUtils.sumSq((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)8.0, (double)StatUtils.sumSq((double[])x, (int)1, (int)2), (double)1.0E-14);
    }

    @Test
    void testProduct() {
        double[] x = null;
        try {
            StatUtils.product(x);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.product(x, (int)0, (int)4);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)1.0, (double)StatUtils.product((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)1.0, (double)StatUtils.product((double[])x, (int)0, (int)0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.product((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.product((double[])x, (int)0, (int)1), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)12.0, (double)StatUtils.product((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)4.0, (double)StatUtils.product((double[])x, (int)1, (int)2), (double)1.0E-14);
    }

    @Test
    void testSumLog() {
        double[] x = null;
        try {
            StatUtils.sumLog(x);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.sumLog(x, (int)0, (int)4);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)0.0, (double)StatUtils.sumLog((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)0.0, (double)StatUtils.sumLog((double[])x, (int)0, (int)0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)FastMath.log((double)2.0), (double)StatUtils.sumLog((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)FastMath.log((double)2.0), (double)StatUtils.sumLog((double[])x, (int)0, (int)1), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)(FastMath.log((double)1.0) + 2.0 * FastMath.log((double)2.0) + FastMath.log((double)3.0)), (double)StatUtils.sumLog((double[])x), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)(2.0 * FastMath.log((double)2.0)), (double)StatUtils.sumLog((double[])x, (int)1, (int)2), (double)1.0E-14);
    }

    @Test
    void testMean() {
        double[] x = null;
        try {
            StatUtils.mean(x, (int)0, (int)4);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.mean((double[])x, (int)0, (int)0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.mean((double[])x, (int)0, (int)1), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)2.5, (double)StatUtils.mean((double[])x, (int)2, (int)2), (double)1.0E-14);
    }

    @Test
    void testVariance() {
        double[] x = null;
        try {
            StatUtils.variance(x, (int)0, (int)4);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.variance((double[])x, (int)0, (int)0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)0.0, (double)StatUtils.variance((double[])x, (int)0, (int)1), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)0.5, (double)StatUtils.variance((double[])x, (int)2, (int)2), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)0.5, (double)StatUtils.variance((double[])x, (double)2.5, (int)2, (int)2), (double)1.0E-14);
    }

    @Test
    void testPopulationVariance() {
        double[] x = null;
        try {
            StatUtils.variance(x, (int)0, (int)4);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.populationVariance((double[])x, (int)0, (int)0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)0.0, (double)StatUtils.populationVariance((double[])x, (int)0, (int)1), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)0.25, (double)StatUtils.populationVariance((double[])x, (int)0, (int)2), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)0.25, (double)StatUtils.populationVariance((double[])x, (double)2.5, (int)2, (int)2), (double)1.0E-14);
    }

    @Test
    void testMax() {
        double[] x = null;
        try {
            StatUtils.max(x, (int)0, (int)4);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.max((double[])x, (int)0, (int)0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.max((double[])x, (int)0, (int)1), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)3.0, (double)StatUtils.max((double[])x, (int)1, (int)3), (double)1.0E-14);
        x = new double[]{Double.NaN, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)3.0, (double)StatUtils.max((double[])x), (double)1.0E-14);
        x = new double[]{1.0, Double.NaN, 3.0};
        UnitTestUtils.customAssertEquals((double)3.0, (double)StatUtils.max((double[])x), (double)1.0E-14);
        x = new double[]{1.0, 2.0, Double.NaN};
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.max((double[])x), (double)1.0E-14);
        x = new double[]{Double.NaN, Double.NaN, Double.NaN};
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.max((double[])x), (double)1.0E-14);
    }

    @Test
    void testMin() {
        double[] x = null;
        try {
            StatUtils.min(x, (int)0, (int)4);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.min((double[])x, (int)0, (int)0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.min((double[])x, (int)0, (int)1), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.min((double[])x, (int)1, (int)3), (double)1.0E-14);
        x = new double[]{Double.NaN, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.min((double[])x), (double)1.0E-14);
        x = new double[]{1.0, Double.NaN, 3.0};
        UnitTestUtils.customAssertEquals((double)1.0, (double)StatUtils.min((double[])x), (double)1.0E-14);
        x = new double[]{1.0, 2.0, Double.NaN};
        UnitTestUtils.customAssertEquals((double)1.0, (double)StatUtils.min((double[])x), (double)1.0E-14);
        x = new double[]{Double.NaN, Double.NaN, Double.NaN};
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.min((double[])x), (double)1.0E-14);
    }

    @Test
    void testPercentile() {
        double[] x = null;
        try {
            StatUtils.percentile(x, (double)0.25);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.percentile(x, (int)0, (int)4, (double)0.25);
            Assertions.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.percentile((double[])x, (double)25.0), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)StatUtils.percentile((double[])x, (int)0, (int)0, (double)25.0), (double)1.0E-14);
        x = new double[]{2.0};
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.percentile((double[])x, (double)25.0), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)2.0, (double)StatUtils.percentile((double[])x, (int)0, (int)1, (double)25.0), (double)1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        UnitTestUtils.customAssertEquals((double)2.5, (double)StatUtils.percentile((double[])x, (double)70.0), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((double)2.5, (double)StatUtils.percentile((double[])x, (int)1, (int)3, (double)62.5), (double)1.0E-14);
    }

    @Test
    void testDifferenceStats() {
        double[] sample1 = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] sample2 = new double[]{1.0, 3.0, 4.0, 2.0};
        double[] diff = new double[]{0.0, -1.0, -1.0, 2.0};
        double[] small = new double[]{1.0, 4.0};
        double meanDifference = StatUtils.meanDifference((double[])sample1, (double[])sample2);
        Assertions.assertEquals((double)StatUtils.sumDifference((double[])sample1, (double[])sample2), (double)StatUtils.sum((double[])diff), (double)1.0E-14);
        Assertions.assertEquals((double)meanDifference, (double)StatUtils.mean((double[])diff), (double)1.0E-14);
        Assertions.assertEquals((double)StatUtils.varianceDifference((double[])sample1, (double[])sample2, (double)meanDifference), (double)StatUtils.variance((double[])diff), (double)1.0E-14);
        try {
            StatUtils.meanDifference((double[])sample1, (double[])small);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.varianceDifference((double[])sample1, (double[])small, (double)meanDifference);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            double[] single = new double[]{1.0};
            StatUtils.varianceDifference((double[])single, (double[])single, (double)meanDifference);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testGeometricMean() {
        double[] test = null;
        try {
            StatUtils.geometricMean(test);
            Assertions.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        test = new double[]{2.0, 4.0, 6.0, 8.0};
        Assertions.assertEquals((double)FastMath.exp((double)(0.25 * StatUtils.sumLog((double[])test))), (double)StatUtils.geometricMean((double[])test), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)FastMath.exp((double)(0.5 * StatUtils.sumLog((double[])test, (int)0, (int)2))), (double)StatUtils.geometricMean((double[])test, (int)0, (int)2), (double)Double.MIN_VALUE);
    }

    @Test
    void testNormalize1() {
        double[] sample = new double[]{50.0, 100.0};
        double[] expectedSample = new double[]{-25.0 / FastMath.sqrt((double)1250.0), 25.0 / FastMath.sqrt((double)1250.0)};
        double[] out = StatUtils.normalize((double[])sample);
        for (int i = 0; i < out.length; ++i) {
            Assertions.assertTrue((boolean)Precision.equals((double)out[i], (double)expectedSample[i], (int)1));
        }
    }

    @Test
    void testNormalize2() {
        int length = 77;
        double[] sample = new double[length];
        for (int i = 0; i < length; ++i) {
            sample[i] = FastMath.random();
        }
        double[] standardizedSample = StatUtils.normalize((double[])sample);
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < length; ++i) {
            stats.addValue(standardizedSample[i]);
        }
        double distance = 1.0E-10;
        Assertions.assertEquals((double)0.0, (double)stats.getMean(), (double)distance);
        Assertions.assertEquals((double)1.0, (double)stats.getStandardDeviation(), (double)distance);
    }

    @Test
    void testMode() {
        double[] singleMode = new double[]{0.0, 1.0, 0.0, 2.0, 7.0, 11.0, 12.0};
        double[] modeSingle = StatUtils.mode((double[])singleMode);
        Assertions.assertEquals((double)0.0, (double)modeSingle[0], (double)Double.MIN_VALUE);
        Assertions.assertEquals((int)1, (int)modeSingle.length);
        double[] twoMode = new double[]{0.0, 1.0, 2.0, 0.0, 2.0, 3.0, 7.0, 11.0};
        double[] modeDouble = StatUtils.mode((double[])twoMode);
        Assertions.assertEquals((double)0.0, (double)modeDouble[0], (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)2.0, (double)modeDouble[1], (double)Double.MIN_VALUE);
        Assertions.assertEquals((int)2, (int)modeDouble.length);
        double[] nanInfested = new double[]{0.0, 0.0, 0.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, 2.0, 2.0, 2.0, 3.0, 5.0};
        double[] modeNan = StatUtils.mode((double[])nanInfested);
        Assertions.assertEquals((double)0.0, (double)modeNan[0], (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)2.0, (double)modeNan[1], (double)Double.MIN_VALUE);
        Assertions.assertEquals((int)2, (int)modeNan.length);
        double[] infInfested = new double[]{0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, 2.0, 2.0, 3.0, 5.0};
        double[] modeInf = StatUtils.mode((double[])infInfested);
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)modeInf[0], (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)0.0, (double)modeInf[1], (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)2.0, (double)modeInf[2], (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)modeInf[3], (double)Double.MIN_VALUE);
        Assertions.assertEquals((int)4, (int)modeInf.length);
        double[] noData = new double[]{};
        double[] modeNodata = StatUtils.mode((double[])noData);
        Assertions.assertEquals((int)0, (int)modeNodata.length);
        double[] nansOnly = new double[]{Double.NaN, Double.NaN};
        double[] modeNansOnly = StatUtils.mode((double[])nansOnly);
        Assertions.assertEquals((int)0, (int)modeNansOnly.length);
        double[] nullArray = null;
        try {
            StatUtils.mode(nullArray);
            Assertions.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }
}

