/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.correlation;

import java.util.Arrays;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.random.Well1024a;
import org.hipparchus.stat.correlation.KendallsCorrelation;
import org.hipparchus.stat.correlation.PearsonsCorrelationTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class KendallsCorrelationTest
extends PearsonsCorrelationTest {
    private KendallsCorrelation correlation;

    KendallsCorrelationTest() {
    }

    @BeforeEach
    void setUp() {
        this.correlation = new KendallsCorrelation();
    }

    @Override
    @Test
    public void testLongly() {
        RealMatrix matrix = this.createRealMatrix(this.longleyData, 16, 7);
        KendallsCorrelation corrInstance = new KendallsCorrelation(matrix);
        RealMatrix correlationMatrix = corrInstance.getCorrelationMatrix();
        double[] rData = new double[]{1.0, 0.9166666666666666, 0.9333333333333332, 0.3666666666666666, 0.05, 0.8999999999999999, 0.8999999999999999, 0.9166666666666666, 1.0, 0.9833333333333333, 0.45, 0.03333333333333333, 0.9833333333333333, 0.9833333333333333, 0.9333333333333332, 0.9833333333333333, 1.0, 0.4333333333333333, 0.05, 0.9666666666666666, 0.9666666666666666, 0.3666666666666666, 0.45, 0.4333333333333333, 1.0, -0.2166666666666666, 0.4666666666666666, 0.4666666666666666, 0.05, 0.03333333333333333, 0.05, -0.2166666666666666, 1.0, 0.05, 0.05, 0.8999999999999999, 0.9833333333333333, 0.9666666666666666, 0.4666666666666666, 0.05, 1.0, 0.9999999999999999, 0.8999999999999999, 0.9833333333333333, 0.9666666666666666, 0.4666666666666666, 0.05, 0.9999999999999999, 1.0};
        UnitTestUtils.customAssertEquals((String)"Kendall's correlation matrix", (RealMatrix)this.createRealMatrix(rData, 7, 7), (RealMatrix)correlationMatrix, (double)1.0E-14);
    }

    @Test
    void testSwiss() {
        RealMatrix matrix = this.createRealMatrix(this.swissData, 47, 5);
        KendallsCorrelation corrInstance = new KendallsCorrelation(matrix);
        RealMatrix correlationMatrix = corrInstance.getCorrelationMatrix();
        double[] rData = new double[]{1.0, 0.1795465254708308, -0.4762437404200669, -0.3306111613580587, 0.2453703703703704, 0.1795465254708308, 1.0, -0.4505221560842292, -0.4761645631778491, 0.2054604569820847, -0.4762437404200669, -0.4505221560842292, 1.0, 0.528943683925829, -0.3212755391722673, -0.3306111613580587, -0.4761645631778491, 0.528943683925829, 1.0, -0.08479652265379604, 0.2453703703703704, 0.2054604569820847, -0.3212755391722673, -0.08479652265379604, 1.0};
        UnitTestUtils.customAssertEquals((String)"Kendall's correlation matrix", (RealMatrix)this.createRealMatrix(rData, 5, 5), (RealMatrix)correlationMatrix, (double)1.0E-14);
    }

    @Test
    void testSimpleOrdered() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            xArray[i] = i;
            yArray[i] = i;
        }
        Assertions.assertEquals((double)1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    void testSimpleReversed() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            xArray[10 - i - 1] = i;
            yArray[i] = i;
        }
        Assertions.assertEquals((double)-1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    void testSimpleOrderedPowerOf2() {
        int length = 16;
        double[] xArray = new double[16];
        double[] yArray = new double[16];
        for (int i = 0; i < 16; ++i) {
            xArray[i] = i;
            yArray[i] = i;
        }
        Assertions.assertEquals((double)1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    void testSimpleReversedPowerOf2() {
        int length = 16;
        double[] xArray = new double[16];
        double[] yArray = new double[16];
        for (int i = 0; i < 16; ++i) {
            xArray[16 - i - 1] = i;
            yArray[i] = i;
        }
        Assertions.assertEquals((double)-1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    void testSimpleJumble() {
        double[] xArray = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] yArray = new double[]{1.0, 3.0, 2.0, 4.0};
        Assertions.assertEquals((double)0.6666666666666666, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    void testBalancedJumble() {
        double[] xArray = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] yArray = new double[]{1.0, 4.0, 3.0, 2.0};
        Assertions.assertEquals((double)0.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    void testOrderedTies() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            xArray[i] = i / 2;
            yArray[i] = i / 2;
        }
        Assertions.assertEquals((double)1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    void testAllTiesInBoth() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        Assertions.assertEquals((double)Double.NaN, (double)this.correlation.correlation(xArray, yArray), (double)0.0);
    }

    @Test
    void testAllTiesInX() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            xArray[i] = i;
        }
        Assertions.assertEquals((double)Double.NaN, (double)this.correlation.correlation(xArray, yArray), (double)0.0);
    }

    @Test
    void testAllTiesInY() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            yArray[i] = i;
        }
        Assertions.assertEquals((double)Double.NaN, (double)this.correlation.correlation(xArray, yArray), (double)0.0);
    }

    @Test
    void testSingleElement() {
        boolean length = true;
        double[] xArray = new double[1];
        double[] yArray = new double[1];
        Assertions.assertEquals((double)Double.NaN, (double)this.correlation.correlation(xArray, yArray), (double)0.0);
    }

    @Test
    void testTwoElements() {
        double[] xArray = new double[]{2.0, 1.0};
        double[] yArray = new double[]{1.0, 2.0};
        Assertions.assertEquals((double)-1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    void test2dDoubleArray() {
        double[][] input = new double[][]{{2.0, 1.0, 2.0}, {1.0, 2.0, 1.0}, {0.0, 0.0, 0.0}};
        double[][] expected = new double[][]{{1.0, 0.3333333333333333, 1.0}, {0.3333333333333333, 1.0, 0.3333333333333333}, {1.0, 0.3333333333333333, 1.0}};
        Assertions.assertEquals((Object)this.correlation.computeCorrelationMatrix((double[][])input), (Object)new BlockRealMatrix((double[][])expected));
    }

    @Test
    void testBlockMatrix() {
        double[][] input = new double[][]{{2.0, 1.0, 2.0}, {1.0, 2.0, 1.0}, {0.0, 0.0, 0.0}};
        double[][] expected = new double[][]{{1.0, 0.3333333333333333, 1.0}, {0.3333333333333333, 1.0, 0.3333333333333333}, {1.0, 0.3333333333333333, 1.0}};
        Assertions.assertEquals((Object)this.correlation.computeCorrelationMatrix((RealMatrix)new BlockRealMatrix((double[][])input)), (Object)new BlockRealMatrix((double[][])expected));
    }

    @Test
    void testLargeArray() {
        double[] xArray = new double[100000];
        Arrays.fill(xArray, 0, 2500, 1.0);
        Assertions.assertEquals((double)1.0, (double)this.correlation.correlation(xArray, xArray), (double)1.0E-6);
    }

    @Test
    void testMath1277() {
        int i;
        Well1024a rng = new Well1024a(0);
        double[] xArray = new double[120000];
        double[] yArray = new double[120000];
        for (i = 0; i < xArray.length; ++i) {
            xArray[i] = rng.nextDouble();
        }
        for (i = 0; i < yArray.length; ++i) {
            yArray[i] = rng.nextDouble();
        }
        double coefficient = this.correlation.correlation(xArray, yArray);
        Assertions.assertTrue((1.0 >= coefficient && -1.0 <= coefficient ? 1 : 0) != 0);
    }
}

