/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.rank.Max;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MaxTest
extends StorelessUnivariateStatisticAbstractTest {
    public Max getUnivariateStatistic() {
        return new Max();
    }

    @Override
    public double expectedValue() {
        return this.max;
    }

    @Test
    void testSpecialValues() {
        double[] testArray = new double[]{0.0, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        Max max = this.getUnivariateStatistic();
        Assertions.assertTrue((boolean)Double.isNaN(max.getResult()));
        max.increment(testArray[0]);
        Assertions.assertEquals((double)0.0, (double)max.getResult(), (double)0.0);
        max.increment(testArray[1]);
        Assertions.assertEquals((double)0.0, (double)max.getResult(), (double)0.0);
        max.increment(testArray[2]);
        Assertions.assertEquals((double)0.0, (double)max.getResult(), (double)0.0);
        max.increment(testArray[3]);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)max.getResult(), (double)0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)max.evaluate(testArray), (double)0.0);
    }

    @Test
    void testNaNs() {
        Max max = this.getUnivariateStatistic();
        double nan = Double.NaN;
        Assertions.assertEquals((double)3.0, (double)max.evaluate(new double[]{nan, 2.0, 3.0}), (double)0.0);
        Assertions.assertEquals((double)3.0, (double)max.evaluate(new double[]{1.0, nan, 3.0}), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)max.evaluate(new double[]{1.0, 2.0, nan}), (double)0.0);
        Assertions.assertTrue((boolean)Double.isNaN(max.evaluate(new double[]{nan, nan, nan})));
    }
}

