/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.summary;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SumTest
extends StorelessUnivariateStatisticAbstractTest {
    public Sum getUnivariateStatistic() {
        return new Sum();
    }

    @Override
    public double expectedValue() {
        return this.sum;
    }

    public double expectedWeightedValue() {
        return this.weightedSum;
    }

    @Test
    void testSpecialValues() {
        Sum sum = this.getUnivariateStatistic();
        Assertions.assertEquals((double)0.0, (double)sum.getResult(), (double)0.0);
        sum.increment(1.0);
        Assertions.assertEquals((double)1.0, (double)sum.getResult(), (double)0.0);
        sum.increment(Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)sum.getResult(), (double)0.0);
        sum.increment(Double.NEGATIVE_INFINITY);
        Assertions.assertTrue((boolean)Double.isNaN(sum.getResult()));
        sum.increment(1.0);
        Assertions.assertTrue((boolean)Double.isNaN(sum.getResult()));
    }

    @Test
    void testWeightedSum() {
        Sum sum = new Sum();
        Assertions.assertEquals((double)this.expectedWeightedValue(), (double)sum.evaluate(this.testArray, this.testWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assertions.assertEquals((double)this.expectedValue(), (double)sum.evaluate(this.testArray, this.unitWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
    }

    @Override
    protected void checkClearValue(StorelessUnivariateStatistic statistic) {
        Assertions.assertEquals((double)0.0, (double)statistic.getResult(), (double)0.0);
    }
}

