/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.inference.ChiSquareTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ChiSquareTestTest {
    protected ChiSquareTest testStatistic = new ChiSquareTest();

    ChiSquareTestTest() {
    }

    @Test
    void testChiSquare() {
        long[] observed = new long[]{10L, 9L, 11L};
        double[] expected = new double[]{10.0, 10.0, 10.0};
        Assertions.assertEquals((double)0.2, (double)this.testStatistic.chiSquare(expected, observed), (double)1.0E-11, (String)"chi-square statistic");
        Assertions.assertEquals((double)0.904837418036, (double)this.testStatistic.chiSquareTest(expected, observed), (double)1.0E-10, (String)"chi-square p-value");
        long[] observed1 = new long[]{500L, 623L, 72L, 70L, 31L};
        double[] expected1 = new double[]{485.0, 541.0, 82.0, 61.0, 37.0};
        Assertions.assertEquals((double)9.023307936427388, (double)this.testStatistic.chiSquare(expected1, observed1), (double)1.0E-10, (String)"chi-square test statistic");
        Assertions.assertEquals((double)0.06051952647453607, (double)this.testStatistic.chiSquareTest(expected1, observed1), (double)1.0E-9, (String)"chi-square p-value");
        Assertions.assertTrue((boolean)this.testStatistic.chiSquareTest(expected1, observed1, 0.08), (String)"chi-square test reject");
        Assertions.assertFalse((boolean)this.testStatistic.chiSquareTest(expected1, observed1, 0.05), (String)"chi-square test accept");
        try {
            this.testStatistic.chiSquareTest(expected1, observed1, 95.0);
            Assertions.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[] tooShortObs = new long[]{0L};
        double[] tooShortEx = new double[]{1.0};
        try {
            this.testStatistic.chiSquare(tooShortEx, tooShortObs);
            Assertions.fail((String)"arguments too short, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[] unMatchedObs = new long[]{0L, 1L, 2L, 3L};
        double[] unMatchedEx = new double[]{1.0, 1.0, 2.0};
        try {
            this.testStatistic.chiSquare(unMatchedEx, unMatchedObs);
            Assertions.fail((String)"arrays have different lengths, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        expected[0] = 0.0;
        try {
            this.testStatistic.chiSquareTest(expected, observed, 0.01);
            Assertions.fail((String)"bad expected count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        expected[0] = 1.0;
        observed[0] = -1L;
        try {
            this.testStatistic.chiSquareTest(expected, observed, 0.01);
            Assertions.fail((String)"bad expected count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testChiSquareIndependence() {
        long[][] counts = new long[][]{{40L, 22L, 43L}, {91L, 21L, 28L}, {60L, 10L, 22L}};
        Assertions.assertEquals((double)22.709027688, (double)this.testStatistic.chiSquare((long[][])counts), (double)1.0E-9, (String)"chi-square test statistic");
        Assertions.assertEquals((double)1.44751460134E-4, (double)this.testStatistic.chiSquareTest((long[][])counts), (double)1.0E-9, (String)"chi-square p-value");
        Assertions.assertTrue((boolean)this.testStatistic.chiSquareTest((long[][])counts, 2.0E-4), (String)"chi-square test reject");
        Assertions.assertFalse((boolean)this.testStatistic.chiSquareTest((long[][])counts, 1.0E-4), (String)"chi-square test accept");
        long[][] counts2 = new long[][]{{10L, 15L}, {30L, 40L}, {60L, 90L}};
        Assertions.assertEquals((double)0.168965517241, (double)this.testStatistic.chiSquare((long[][])counts2), (double)1.0E-9, (String)"chi-square test statistic");
        Assertions.assertEquals((double)0.918987499852, (double)this.testStatistic.chiSquareTest((long[][])counts2), (double)1.0E-9, (String)"chi-square p-value");
        Assertions.assertFalse((boolean)this.testStatistic.chiSquareTest((long[][])counts2, 0.1), (String)"chi-square test accept");
        long[][] counts3 = new long[][]{{40L, 22L, 43L}, {91L, 21L, 28L}, {60L, 10L}};
        try {
            this.testStatistic.chiSquare((long[][])counts3);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[][] counts4 = new long[][]{{40L, 22L, 43L}};
        try {
            this.testStatistic.chiSquare((long[][])counts4);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[][] counts5 = new long[][]{{40L}, {40L}, {30L}, {10L}};
        try {
            this.testStatistic.chiSquare((long[][])counts5);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[][] counts6 = new long[][]{{10L, -2L}, {30L, 40L}, {60L, 90L}};
        try {
            this.testStatistic.chiSquare((long[][])counts6);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.chiSquareTest((long[][])counts, 0.0);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testChiSquareLargeTestStatistic() {
        double[] exp = new double[]{3389119.5, 649136.6, 285745.4, 2.535736476E7, 1.129118978E7, 543628.0, 232921.0, 437665.75};
        long[] obs = new long[]{2372383L, 584222L, 257170L, 17750155L, 7903832L, 489265L, 209628L, 393899L};
        ChiSquareTest csti = new ChiSquareTest();
        double cst = csti.chiSquareTest(exp, obs);
        Assertions.assertEquals((double)0.0, (double)cst, (double)0.001, (String)"chi-square p-value");
        Assertions.assertEquals((double)114875.90421929007, (double)this.testStatistic.chiSquare(exp, obs), (double)1.0E-9, (String)"chi-square test statistic");
    }

    @Test
    void testChiSquareZeroCount() {
        long[][] counts = new long[][]{{40L, 0L, 4L}, {91L, 1L, 2L}, {60L, 2L, 0L}};
        Assertions.assertEquals((double)9.67444662263, (double)this.testStatistic.chiSquare((long[][])counts), (double)1.0E-9, (String)"chi-square test statistic");
        Assertions.assertEquals((double)0.0462835770603, (double)this.testStatistic.chiSquareTest((long[][])counts), (double)1.0E-9, (String)"chi-square p-value");
    }

    @Test
    void testChiSquareDataSetsComparisonEqualCounts() {
        long[] observed1 = new long[]{10L, 12L, 12L, 10L};
        long[] observed2 = new long[]{5L, 15L, 14L, 10L};
        Assertions.assertEquals((double)0.541096, (double)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2), (double)1.0E-6, (String)"chi-square p value");
        Assertions.assertEquals((double)2.153846, (double)this.testStatistic.chiSquareDataSetsComparison(observed1, observed2), (double)1.0E-6, (String)"chi-square test statistic");
        Assertions.assertFalse((boolean)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2, 0.4), (String)"chi-square test result");
    }

    @Test
    void testChiSquareDataSetsComparisonUnEqualCounts() {
        long[] observed1 = new long[]{10L, 12L, 12L, 10L, 15L};
        long[] observed2 = new long[]{15L, 10L, 10L, 15L, 5L};
        Assertions.assertEquals((double)0.124115, (double)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2), (double)1.0E-6, (String)"chi-square p value");
        Assertions.assertEquals((double)7.232189, (double)this.testStatistic.chiSquareDataSetsComparison(observed1, observed2), (double)1.0E-6, (String)"chi-square test statistic");
        Assertions.assertTrue((boolean)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2, 0.13), (String)"chi-square test result");
        Assertions.assertFalse((boolean)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2, 0.12), (String)"chi-square test result");
    }

    @Test
    void testChiSquareDataSetsComparisonBadCounts() {
        long[] observed1 = new long[]{10L, -1L, 12L, 10L, 15L};
        long[] observed2 = new long[]{15L, 10L, 10L, 15L, 5L};
        try {
            this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2);
            Assertions.fail((String)"Expecting MathIllegalArgumentException - negative count");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[] observed3 = new long[]{10L, 0L, 12L, 10L, 15L};
        long[] observed4 = new long[]{15L, 0L, 10L, 15L, 5L};
        try {
            this.testStatistic.chiSquareTestDataSetsComparison(observed3, observed4);
            Assertions.fail((String)"Expecting MathIllegalArgumentException - double 0's");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[] observed5 = new long[]{10L, 10L, 12L, 10L, 15L};
        long[] observed6 = new long[]{0L, 0L, 0L, 0L, 0L};
        try {
            this.testStatistic.chiSquareTestDataSetsComparison(observed5, observed6);
            Assertions.fail((String)"Expecting MathIllegalArgumentException - vanishing counts");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }
}

