/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import java.util.ArrayList;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.stat.inference.OneWayAnova;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OneWayAnovaTest {
    protected OneWayAnova testStatistic = new OneWayAnova();
    private double[] emptyArray = new double[0];
    private double[] classA = new double[]{93.0, 103.0, 95.0, 101.0, 91.0, 105.0, 96.0, 94.0, 101.0};
    private double[] classB = new double[]{99.0, 92.0, 102.0, 100.0, 102.0, 89.0};
    private double[] classC = new double[]{110.0, 115.0, 111.0, 117.0, 128.0, 117.0};

    OneWayAnovaTest() {
    }

    @Test
    void testAnovaFValue() {
        ArrayList<double[]> threeClasses = new ArrayList<double[]>();
        threeClasses.add(this.classA);
        threeClasses.add(this.classB);
        threeClasses.add(this.classC);
        Assertions.assertEquals((double)24.67361709460624, (double)this.testStatistic.anovaFValue(threeClasses), (double)1.0E-12, (String)"ANOVA F-value");
        ArrayList<double[]> twoClasses = new ArrayList<double[]>();
        twoClasses.add(this.classA);
        twoClasses.add(this.classB);
        Assertions.assertEquals((double)0.0150579150579, (double)this.testStatistic.anovaFValue(twoClasses), (double)1.0E-12, (String)"ANOVA F-value");
        ArrayList<double[]> emptyContents = new ArrayList<double[]>();
        emptyContents.add(this.emptyArray);
        emptyContents.add(this.classC);
        try {
            this.testStatistic.anovaFValue(emptyContents);
            Assertions.fail((String)"empty array for key classX, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        ArrayList<double[]> tooFew = new ArrayList<double[]>();
        tooFew.add(this.classA);
        try {
            this.testStatistic.anovaFValue(tooFew);
            Assertions.fail((String)"less than two classes, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testAnovaPValue() {
        ArrayList<double[]> threeClasses = new ArrayList<double[]>();
        threeClasses.add(this.classA);
        threeClasses.add(this.classB);
        threeClasses.add(this.classC);
        Assertions.assertEquals((double)6.959446E-6, (double)this.testStatistic.anovaPValue(threeClasses), (double)1.0E-12, (String)"ANOVA P-value");
        ArrayList<double[]> twoClasses = new ArrayList<double[]>();
        twoClasses.add(this.classA);
        twoClasses.add(this.classB);
        Assertions.assertEquals((double)0.904212960464, (double)this.testStatistic.anovaPValue(twoClasses), (double)1.0E-12, (String)"ANOVA P-value");
    }

    @Test
    void testAnovaPValueSummaryStatistics() {
        ArrayList<StreamingStatistics> threeClasses = new ArrayList<StreamingStatistics>();
        StreamingStatistics statsA = new StreamingStatistics();
        for (double a : this.classA) {
            statsA.addValue(a);
        }
        threeClasses.add(statsA);
        StreamingStatistics statsB = new StreamingStatistics();
        for (double b : this.classB) {
            statsB.addValue(b);
        }
        threeClasses.add(statsB);
        StreamingStatistics statsC = new StreamingStatistics();
        for (double c : this.classC) {
            statsC.addValue(c);
        }
        threeClasses.add(statsC);
        Assertions.assertEquals((double)6.959446E-6, (double)this.testStatistic.anovaPValue(threeClasses, true), (double)1.0E-12, (String)"ANOVA P-value");
        ArrayList<StreamingStatistics> twoClasses = new ArrayList<StreamingStatistics>();
        twoClasses.add(statsA);
        twoClasses.add(statsB);
        Assertions.assertEquals((double)0.904212960464, (double)this.testStatistic.anovaPValue(twoClasses, false), (double)1.0E-12, (String)"ANOVA P-value");
    }

    @Test
    void testAnovaTest() {
        ArrayList<double[]> threeClasses = new ArrayList<double[]>();
        threeClasses.add(this.classA);
        threeClasses.add(this.classB);
        threeClasses.add(this.classC);
        Assertions.assertTrue((boolean)this.testStatistic.anovaTest(threeClasses, 0.01), (String)"ANOVA Test P<0.01");
        ArrayList<double[]> twoClasses = new ArrayList<double[]>();
        twoClasses.add(this.classA);
        twoClasses.add(this.classB);
        Assertions.assertFalse((boolean)this.testStatistic.anovaTest(twoClasses, 0.01), (String)"ANOVA Test P>0.01");
    }
}

