/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.inference.WilcoxonSignedRankTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WilcoxonSignedRankTestTest {
    protected WilcoxonSignedRankTest testStatistic = new WilcoxonSignedRankTest();

    WilcoxonSignedRankTestTest() {
    }

    @Test
    void testWilcoxonSignedRankSimple() {
        double[] x = new double[]{1.83, 0.5, 1.62, 2.48, 1.68, 1.88, 1.55, 3.06, 1.3};
        double[] y = new double[]{0.878, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29};
        Assertions.assertEquals((double)40.0, (double)this.testStatistic.wilcoxonSignedRank(x, y), (double)1.0E-10);
        Assertions.assertEquals((double)0.03906, (double)this.testStatistic.wilcoxonSignedRankTest(x, y, true), (double)1.0E-5);
        Assertions.assertEquals((double)40.0, (double)this.testStatistic.wilcoxonSignedRank(x, y), (double)1.0E-10);
        Assertions.assertEquals((double)0.044010984013, (double)this.testStatistic.wilcoxonSignedRankTest(x, y, false), (double)1.0E-10);
    }

    @Test
    void testWilcoxonSignedRankSimple2() {
        double[] x = new double[]{0.8, 0.83, 1.89, 1.04, 1.45, 1.38, 1.91};
        double[] y = new double[]{1.15, 0.88, 0.9, 0.74, 1.21, 2.0, 1.72};
        Assertions.assertEquals((double)16.0, (double)this.testStatistic.wilcoxonSignedRank(x, y), (double)0.0);
        Assertions.assertEquals((double)0.8125, (double)this.testStatistic.wilcoxonSignedRankTest(x, y, true), (double)1.0E-10);
        Assertions.assertEquals((double)0.79984610566, (double)this.testStatistic.wilcoxonSignedRankTest(x, y, false), (double)1.0E-10);
    }

    @Test
    void testWilcoxonSignedRankTiesDiscarded() {
        double[] x = new double[]{1.83, 0.5, 1.62, 2.48, 1.68, 1.88, 1.55, 3.06, 1.3};
        double[] y = new double[]{1.83, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29};
        double[] xp = new double[]{0.5, 1.62, 2.48, 1.68, 1.88, 1.55, 3.06, 1.3};
        double[] yp = new double[]{0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29};
        Assertions.assertEquals((double)this.testStatistic.wilcoxonSignedRank(xp, yp), (double)this.testStatistic.wilcoxonSignedRank(x, y), (double)0.0);
        Assertions.assertEquals((double)this.testStatistic.wilcoxonSignedRankTest(xp, yp, true), (double)this.testStatistic.wilcoxonSignedRankTest(x, y, true), (double)0.0);
        Assertions.assertEquals((double)this.testStatistic.wilcoxonSignedRankTest(xp, yp, false), (double)this.testStatistic.wilcoxonSignedRankTest(x, y, false), (double)0.0);
    }

    @Test
    void testWilcoxonSignedRankInputValidation() {
        double[] x1 = new double[30];
        double[] x2 = new double[31];
        double[] y1 = new double[30];
        double[] y2 = new double[31];
        for (int i = 0; i < 30; ++i) {
            y1[i] = y2[i] = (double)i;
            x2[i] = y2[i];
            x1[i] = y2[i];
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(x2, y2, true);
            Assertions.fail((String)"More than 30 samples and exact chosen, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[0], new double[]{1.0}, true);
            Assertions.fail((String)"x does not contain samples (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[0], new double[]{1.0}, false);
            Assertions.fail((String)"x does not contain samples (asymptotic), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0}, new double[0], true);
            Assertions.fail((String)"y does not contain samples (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0}, new double[0], false);
            Assertions.fail((String)"y does not contain samples (asymptotic), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0, 2.0}, new double[]{3.0}, true);
            Assertions.fail((String)"x and y not same size (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0, 2.0}, new double[]{3.0}, false);
            Assertions.fail((String)"x and y not same size (asymptotic), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(null, null, true);
            Assertions.fail((String)"x and y is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(null, null, false);
            Assertions.fail((String)"x and y is null (asymptotic), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(null, new double[]{1.0}, true);
            Assertions.fail((String)"x is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(null, new double[]{1.0}, false);
            Assertions.fail((String)"x is null (asymptotic), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0}, null, true);
            Assertions.fail((String)"y is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0}, null, false);
            Assertions.fail((String)"y is null (asymptotic), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testBadInputAllTies() {
        Assertions.assertThrows(MathIllegalArgumentException.class, () -> this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0, 2.0, 3.0}, new double[]{1.0, 2.0, 3.0}, true));
    }

    @Test
    void testDegenerateOnePair() {
        double[] x = new double[]{1.0};
        double[] y = new double[]{2.0};
        Assertions.assertEquals((double)1.0, (double)this.testStatistic.wilcoxonSignedRank(x, y), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)this.testStatistic.wilcoxonSignedRankTest(x, y, true), (double)0.0);
    }
}

