/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.stat.Frequency;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class FrequencyTest {
    private static final long ONE_LONG = 1L;
    private static final long TWO_LONG = 2L;
    private static final long THREE_LONG = 3L;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final char CHAR_A = 'a';
    private static final double TOLERANCE = 1.0E-14;

    FrequencyTest() {
    }

    @Test
    void testCounts() {
        Frequency f = new Frequency();
        Assertions.assertEquals((long)0L, (long)f.getSumFreq(), (String)"total count");
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(1L));
        Assertions.assertEquals((long)3L, (long)f.getCount((Comparable)Long.valueOf(1L)), (String)"one frequency count");
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(2L)), (String)"two frequency count");
        Assertions.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(3L)), (String)"three frequency count");
        Assertions.assertEquals((long)4L, (long)f.getSumFreq(), (String)"total count");
        Assertions.assertEquals((long)0L, (long)f.getCumFreq((Comparable)Long.valueOf(0L)), (String)"zero cumulative frequency");
        Assertions.assertEquals((long)3L, (long)f.getCumFreq((Comparable)Long.valueOf(1L)), (String)"one cumulative frequency");
        Assertions.assertEquals((long)4L, (long)f.getCumFreq((Comparable)Long.valueOf(2L)), (String)"two cumulative frequency");
        Assertions.assertEquals((long)4L, (long)f.getCumFreq((Comparable)Long.valueOf(5L)), (String)"five cumulative frequency");
        f.clear();
        Assertions.assertEquals((long)0L, (long)f.getSumFreq(), (String)"total count");
    }

    @Test
    void testCountsString() {
        Frequency f = new Frequency();
        f.addValue((Comparable)((Object)"one"));
        f.addValue((Comparable)((Object)"One"));
        f.addValue((Comparable)((Object)"oNe"));
        f.addValue((Comparable)((Object)"Z"));
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)((Object)"one")), (String)"one cumulative frequency");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct((Comparable)((Object)"Z")), (double)1.0E-14, (String)"Z cumulative pct");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)((Object)"z")), (double)1.0E-14, (String)"z cumulative pct");
        Assertions.assertEquals((double)0.25, (double)f.getCumPct((Comparable)((Object)"Ot")), (double)1.0E-14, (String)"Ot cumulative pct");
        f.clear();
    }

    @Test
    void testCountsInteger() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Integer.valueOf(1));
        f.addValue((Comparable)Integer.valueOf(1));
        f.addValue((Comparable)Integer.valueOf(Long.valueOf(1L).intValue()));
        f.addValue((Comparable)Integer.valueOf(2));
        f.addValue((Comparable)Integer.valueOf(-1));
        Assertions.assertEquals((long)3L, (long)f.getCount((Comparable)Integer.valueOf(1)), (String)"1 count");
        Assertions.assertEquals((long)3L, (long)f.getCount((Comparable)Integer.valueOf(1)), (String)"1 count");
        Assertions.assertEquals((double)0.2, (double)f.getCumPct((Comparable)Integer.valueOf(0)), (double)1.0E-14, (String)"0 cum pct");
        Assertions.assertEquals((double)0.6, (double)f.getPct((Comparable)Integer.valueOf(1)), (double)1.0E-14, (String)"1 pct");
        Assertions.assertEquals((double)0.0, (double)f.getCumPct((Comparable)Integer.valueOf(-2)), (double)1.0E-14, (String)"-2 cum pct");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Integer.valueOf(10)), (double)1.0E-14, (String)"10 cum pct");
    }

    @Test
    void testCountsComparator() {
        Frequency f = new Frequency(String.CASE_INSENSITIVE_ORDER);
        f.addValue((Comparable)((Object)"one"));
        f.addValue((Comparable)((Object)"One"));
        f.addValue((Comparable)((Object)"oNe"));
        f.addValue((Comparable)((Object)"Z"));
        Assertions.assertEquals((long)3L, (long)f.getCount((Comparable)((Object)"one")), (String)"one count");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)((Object)"Z")), (double)1.0E-14, (String)"Z cumulative pct -- case insensitive");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)((Object)"z")), (double)1.0E-14, (String)"z cumulative pct -- case insensitive");
    }

    @Test
    void testCountsCharacter() {
        Frequency f = new Frequency();
        Assertions.assertEquals((long)0L, (long)f.getCount((Comparable)Character.valueOf('a')));
        Assertions.assertEquals((long)0L, (long)f.getCumFreq((Comparable)Character.valueOf('b')));
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)f.getPct((Comparable)Character.valueOf('a')), (double)0.0);
        UnitTestUtils.customAssertEquals((double)Double.NaN, (double)f.getCumPct((Comparable)Character.valueOf('b')), (double)0.0);
        f.addValue((Comparable)Character.valueOf('a'));
        f.addValue((Comparable)Character.valueOf('b'));
        f.addValue((Comparable)Character.valueOf('c'));
        f.addValue((Comparable)Character.valueOf('d'));
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Character.valueOf('a')));
        Assertions.assertEquals((long)2L, (long)f.getCumFreq((Comparable)Character.valueOf('b')));
        Assertions.assertEquals((double)0.25, (double)f.getPct((Comparable)Character.valueOf('a')), (double)0.0);
        Assertions.assertEquals((double)0.5, (double)f.getCumPct((Comparable)Character.valueOf('b')), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Character.valueOf('e')), (double)0.0);
    }

    @Test
    void testPcts() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        Assertions.assertEquals((double)0.25, (double)f.getPct((Comparable)Long.valueOf(1L)), (double)1.0E-14, (String)"one pct");
        Assertions.assertEquals((double)0.25, (double)f.getPct((Comparable)Long.valueOf(2L)), (double)1.0E-14, (String)"two pct");
        Assertions.assertEquals((double)0.5, (double)f.getPct((Comparable)Long.valueOf(3L)), (double)1.0E-14, (String)"three pct");
        Assertions.assertEquals((double)0.0, (double)f.getPct((Comparable)Long.valueOf(5L)), (double)1.0E-14, (String)"five pct");
        Assertions.assertEquals((double)0.25, (double)f.getCumPct((Comparable)Long.valueOf(1L)), (double)1.0E-14, (String)"one cum pct");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct((Comparable)Long.valueOf(2L)), (double)1.0E-14, (String)"two cum pct");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Long.valueOf(3L)), (double)1.0E-14, (String)"three cum pct");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Long.valueOf(5L)), (double)1.0E-14, (String)"five cum pct");
        Assertions.assertEquals((double)0.0, (double)f.getCumPct((Comparable)Long.valueOf(0L)), (double)1.0E-14, (String)"zero cum pct");
    }

    @Test
    void testEmptyTable() {
        Frequency freq = new Frequency();
        Assertions.assertEquals((long)0L, (long)freq.getSumFreq(), (String)"freq sum, empty table");
        Assertions.assertEquals((long)0L, (long)freq.getCount((Comparable)Integer.valueOf(0)), (String)"count, empty table");
        Assertions.assertEquals((long)0L, (long)freq.getCount((Comparable)Integer.valueOf(0)), (String)"count, empty table");
        Assertions.assertEquals((long)0L, (long)freq.getCumFreq((Comparable)Integer.valueOf(0)), (String)"cum freq, empty table");
        Assertions.assertEquals((long)0L, (long)freq.getCumFreq((Comparable)Integer.valueOf(2)), (String)"cum freq, empty table");
        Assertions.assertTrue((boolean)Double.isNaN(freq.getPct((Comparable)Integer.valueOf(0))), (String)"pct, empty table");
        Assertions.assertTrue((boolean)Double.isNaN(freq.getPct((Comparable)Integer.valueOf(0))), (String)"pct, empty table");
        Assertions.assertTrue((boolean)Double.isNaN(freq.getCumPct((Comparable)Integer.valueOf(0))), (String)"cum pct, empty table");
        Assertions.assertTrue((boolean)Double.isNaN(freq.getCumPct((Comparable)Integer.valueOf(0))), (String)"cum pct, empty table");
    }

    @Test
    void testCumPct() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Integer.valueOf(3));
        f.addValue((Comparable)Integer.valueOf(4));
        f.addValue((Comparable)Integer.valueOf(5));
        f.addValue((Comparable)Integer.valueOf(6));
        Assertions.assertEquals((double)0.25, (double)f.getCumPct((Comparable)Integer.valueOf(3)), (double)1.0E-14, (String)"cum freq, single entry");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Integer.valueOf(6)), (double)1.0E-14, (String)"cum freq, single entry");
        Assertions.assertEquals((double)0.0, (double)f.getCumPct((Comparable)Integer.valueOf(1)), (double)1.0E-14, (String)"cum freq, single entry");
        Assertions.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Integer.valueOf(10)), (double)1.0E-14, (String)"cum freq, single entry");
    }

    @Test
    void testToString() throws Exception {
        Frequency f = new Frequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        String s = f.toString();
        Assertions.assertNotNull((Object)s);
        BufferedReader reader = new BufferedReader(new StringReader(s));
        String line = reader.readLine();
        Assertions.assertNotNull((Object)line);
        line = reader.readLine();
        Assertions.assertNotNull((Object)line);
        line = reader.readLine();
        Assertions.assertNotNull((Object)line);
        line = reader.readLine();
        Assertions.assertNull((Object)line);
    }

    @Test
    void testIntegerValues() {
        Frequency f = new Frequency();
        Integer obj1 = null;
        obj1 = 1;
        Integer int1 = 1;
        f.addValue((Comparable)obj1);
        f.addValue((Comparable)int1);
        f.addValue((Comparable)Integer.valueOf(2));
        f.addValue((Comparable)Integer.valueOf(Long.valueOf(2L).intValue()));
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Integer.valueOf(1)), (String)"Integer 1 count");
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Integer.valueOf(1)), (String)"Integer 1 count");
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Integer.valueOf(Long.valueOf(1L).intValue())), (String)"Integer 1 count");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct((Comparable)Integer.valueOf(1)), (double)1.0E-14, (String)"Integer 1 cumPct");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct((Comparable)Integer.valueOf(Long.valueOf(1L).intValue())), (double)1.0E-14, (String)"Integer 1 cumPct");
        Assertions.assertEquals((double)0.5, (double)f.getCumPct((Comparable)Integer.valueOf(1)), (double)1.0E-14, (String)"Integer 1 cumPct");
        f.incrementValue((Comparable)Integer.valueOf(1), -2L);
        f.incrementValue((Comparable)Integer.valueOf(3), 5L);
        Assertions.assertEquals((long)0L, (long)f.getCount((Comparable)Integer.valueOf(1)), (String)"Integer 1 count");
        Assertions.assertEquals((long)5L, (long)f.getCount((Comparable)Integer.valueOf(3)), (String)"Integer 3 count");
        Iterator it = f.valuesIterator();
        while (it.hasNext()) {
            Assertions.assertTrue((boolean)(it.next() instanceof Integer));
        }
    }

    @Test
    void testSerial() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        Assertions.assertEquals((Object)f, (Object)UnitTestUtils.serializeAndRecover((Object)f));
    }

    @Test
    void testGetUniqueCount() {
        Frequency f = new Frequency();
        Assertions.assertEquals((int)0, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assertions.assertEquals((int)1, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assertions.assertEquals((int)1, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(2L));
        Assertions.assertEquals((int)2, (int)f.getUniqueCount());
    }

    @Test
    void testIncrement() {
        Frequency f = new Frequency();
        Assertions.assertEquals((int)0, (int)f.getUniqueCount());
        f.incrementValue((Comparable)Long.valueOf(1L), 1L);
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        f.incrementValue((Comparable)Long.valueOf(1L), 4L);
        Assertions.assertEquals((long)5L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        f.incrementValue((Comparable)Long.valueOf(1L), -5L);
        Assertions.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Frequency f2 = new Frequency();
        f2.incrementValue((Comparable)Character.valueOf('a'), 2L);
        Assertions.assertEquals((long)2L, (long)f2.getCount((Comparable)Character.valueOf('a')));
        f2.incrementValue((Comparable)Character.valueOf('a'), 3L);
        Assertions.assertEquals((long)5L, (long)f2.getCount((Comparable)Character.valueOf('a')));
    }

    @Test
    void testMerge() {
        Frequency f = new Frequency();
        Assertions.assertEquals((int)0, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        Assertions.assertEquals((int)2, (int)f.getUniqueCount());
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Frequency g = new Frequency();
        g.addValue((Comparable)Long.valueOf(1L));
        g.addValue((Comparable)Long.valueOf(3L));
        g.addValue((Comparable)Long.valueOf(3L));
        Assertions.assertEquals((int)2, (int)g.getUniqueCount());
        Assertions.assertEquals((long)1L, (long)g.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)2L, (long)g.getCount((Comparable)Long.valueOf(3L)));
        f.merge(g);
        Assertions.assertEquals((int)3, (int)f.getUniqueCount());
        Assertions.assertEquals((long)3L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assertions.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(3L)));
    }

    @Test
    void testMergeCollection() {
        Frequency f = new Frequency();
        Assertions.assertEquals((int)0, (int)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assertions.assertEquals((int)1, (int)f.getUniqueCount());
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Frequency g = new Frequency();
        g.addValue((Comparable)Long.valueOf(2L));
        Frequency h = new Frequency();
        h.addValue((Comparable)Long.valueOf(3L));
        ArrayList<Frequency> coll = new ArrayList<Frequency>();
        coll.add(g);
        coll.add(h);
        f.merge(coll);
        Assertions.assertEquals((int)3, (int)f.getUniqueCount());
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assertions.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(3L)));
    }

    @Test
    void testMode() {
        Frequency f = new Frequency();
        List mode = f.getMode();
        Assertions.assertEquals((int)0, (int)mode.size());
        f.addValue((Comparable)((Object)"3"));
        mode = f.getMode();
        Assertions.assertEquals((int)1, (int)mode.size());
        Assertions.assertEquals((Object)"3", mode.get(0));
        f.addValue((Comparable)((Object)"2"));
        mode = f.getMode();
        Assertions.assertEquals((int)2, (int)mode.size());
        Assertions.assertEquals((Object)"2", mode.get(0));
        Assertions.assertEquals((Object)"3", mode.get(1));
        f.addValue((Comparable)((Object)"2"));
        mode = f.getMode();
        Assertions.assertEquals((int)1, (int)mode.size());
        Assertions.assertEquals((Object)"2", mode.get(0));
        Assertions.assertFalse((boolean)mode.contains("1"));
        Assertions.assertTrue((boolean)mode.contains("2"));
    }

    @Test
    void testModeDoubleNan() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Double.valueOf(Double.NaN));
        f.addValue((Comparable)Double.valueOf(Double.NaN));
        f.addValue((Comparable)Double.valueOf(Double.NaN));
        f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        List mode = f.getMode();
        Assertions.assertEquals((int)3, (int)mode.size());
        Assertions.assertEquals((Double)Double.NEGATIVE_INFINITY, (Double)((Double)mode.get(0)));
        Assertions.assertEquals((Double)Double.POSITIVE_INFINITY, (Double)((Double)mode.get(1)));
        Assertions.assertEquals((Double)Double.NaN, (Double)((Double)mode.get(2)));
    }

    @Test
    void testModeFloatNan() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Float.valueOf(Float.NaN));
        f.addValue((Comparable)Float.valueOf(Float.NaN));
        f.addValue((Comparable)Float.valueOf(Float.NaN));
        f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        List mode = f.getMode();
        Assertions.assertEquals((int)3, (int)mode.size());
        Assertions.assertEquals((Float)Float.valueOf(Float.NEGATIVE_INFINITY), (Float)((Float)mode.get(0)));
        Assertions.assertEquals((Float)Float.valueOf(Float.POSITIVE_INFINITY), (Float)((Float)mode.get(1)));
        Assertions.assertEquals((Float)Float.valueOf(Float.NaN), (Float)((Float)mode.get(2)));
    }
}

