/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.stat.descriptive.DescriptiveStatistics;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class CertifiedDataAbstractTest {
    private DescriptiveStatistics descriptives;
    private StreamingStatistics summaries;
    private Map<String, Double> certifiedValues;

    @BeforeEach
    public void setUp() throws IOException {
        this.descriptives = new DescriptiveStatistics();
        this.summaries = new StreamingStatistics();
        this.certifiedValues = new HashMap<String, Double>();
        this.loadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() throws IOException {
        try (BufferedReader in = null;){
            URL resourceURL = this.getClass().getClassLoader().getResource(this.getResourceName());
            in = new BufferedReader(new InputStreamReader(resourceURL.openStream()));
            String line = in.readLine();
            while (line != null) {
                if (!"".equals(line = line.trim()) && !line.startsWith("#")) {
                    int n = line.indexOf(61);
                    if (n == -1) {
                        double value = Double.parseDouble(line);
                        this.descriptives.addValue(value);
                        this.summaries.addValue(value);
                    } else {
                        String name = line.substring(0, n).trim();
                        String valueString = line.substring(n + 1).trim();
                        Double value = Double.valueOf(valueString);
                        this.certifiedValues.put(name, value);
                    }
                }
                line = in.readLine();
            }
        }
    }

    protected abstract String getResourceName();

    protected double getMaximumAbsoluteError() {
        return 1.0E-5;
    }

    @AfterEach
    public void tearDown() {
        this.descriptives.clear();
        this.descriptives = null;
        this.summaries.clear();
        this.summaries = null;
        this.certifiedValues.clear();
        this.certifiedValues = null;
    }

    @Test
    public void testCertifiedValues() {
        for (String name : this.certifiedValues.keySet()) {
            Double descriptivesValue;
            Double expectedValue = this.certifiedValues.get(name);
            Double summariesValue = this.getProperty(this.summaries, name);
            if (summariesValue != null) {
                UnitTestUtils.customAssertEquals((String)("summary value for " + name + " is incorrect."), (double)summariesValue, (double)expectedValue, (double)this.getMaximumAbsoluteError());
            }
            if ((descriptivesValue = this.getProperty(this.descriptives, name)) == null) continue;
            UnitTestUtils.customAssertEquals((String)("descriptive value for " + name + " is incorrect."), (double)descriptivesValue, (double)expectedValue, (double)this.getMaximumAbsoluteError());
        }
    }

    protected Double getProperty(Object bean, String name) {
        try {
            String prop = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            Method meth = bean.getClass().getMethod(prop, new Class[0]);
            meth.setAccessible(true);
            Object property = meth.invoke(bean, new Object[0]);
            if (meth.getReturnType().equals(Double.TYPE)) {
                return (Double)property;
            }
            if (meth.getReturnType().equals(Long.TYPE)) {
                return ((Long)property).doubleValue();
            }
            Assertions.fail((String)("wrong type: " + meth.getReturnType().getName()));
        }
        catch (NoSuchMethodException prop) {
        }
        catch (InvocationTargetException ite) {
            Assertions.fail((String)ite.getMessage());
        }
        catch (IllegalAccessException iae) {
            Assertions.fail((String)iae.getMessage());
        }
        return null;
    }
}

