/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.Locale;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.descriptive.MultivariateSummaryStatistics;
import org.hipparchus.util.FastMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MultivariateSummaryStatisticsTest {
    MultivariateSummaryStatisticsTest() {
    }

    protected MultivariateSummaryStatistics createMultivariateSummaryStatistics(int k, boolean covarianceBiasCorrected) {
        return new MultivariateSummaryStatistics(k, covarianceBiasCorrected);
    }

    @Test
    void testToString() {
        MultivariateSummaryStatistics stats = this.createMultivariateSummaryStatistics(2, true);
        stats.addValue(new double[]{1.0, 3.0});
        stats.addValue(new double[]{2.0, 2.0});
        stats.addValue(new double[]{3.0, 1.0});
        Locale d = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String suffix = System.getProperty("line.separator");
        Assertions.assertEquals((Object)("MultivariateSummaryStatistics:" + suffix + "n: 3" + suffix + "min: 1.0, 1.0" + suffix + "max: 3.0, 3.0" + suffix + "mean: 2.0, 2.0" + suffix + "geometric mean: 1.817..., 1.817..." + suffix + "sum of squares: 14.0, 14.0" + suffix + "sum of logarithms: 1.791..., 1.791..." + suffix + "standard deviation: 1.0, 1.0" + suffix + "covariance: Array2DRowRealMatrix{{1.0,-1.0},{-1.0,1.0}}" + suffix), (Object)stats.toString().replaceAll("([0-9]+\\.[0-9][0-9][0-9])[0-9]+", "$1..."));
        Locale.setDefault(d);
    }

    @Test
    void testDimension() {
        try {
            this.createMultivariateSummaryStatistics(2, true).addValue(new double[3]);
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testStats() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(2, true);
        Assertions.assertEquals((long)0L, (long)u.getN());
        u.addValue(new double[]{1.0, 2.0});
        u.addValue(new double[]{2.0, 3.0});
        u.addValue(new double[]{2.0, 3.0});
        u.addValue(new double[]{3.0, 4.0});
        Assertions.assertEquals((long)4L, (long)u.getN());
        Assertions.assertEquals((double)8.0, (double)u.getSum()[0], (double)1.0E-10);
        Assertions.assertEquals((double)12.0, (double)u.getSum()[1], (double)1.0E-10);
        Assertions.assertEquals((double)18.0, (double)u.getSumSq()[0], (double)1.0E-10);
        Assertions.assertEquals((double)38.0, (double)u.getSumSq()[1], (double)1.0E-10);
        Assertions.assertEquals((double)1.0, (double)u.getMin()[0], (double)1.0E-10);
        Assertions.assertEquals((double)2.0, (double)u.getMin()[1], (double)1.0E-10);
        Assertions.assertEquals((double)3.0, (double)u.getMax()[0], (double)1.0E-10);
        Assertions.assertEquals((double)4.0, (double)u.getMax()[1], (double)1.0E-10);
        Assertions.assertEquals((double)2.4849066497880004, (double)u.getSumLog()[0], (double)1.0E-10);
        Assertions.assertEquals((double)4.276666119016055, (double)u.getSumLog()[1], (double)1.0E-10);
        Assertions.assertEquals((double)1.8612097182041991, (double)u.getGeometricMean()[0], (double)1.0E-10);
        Assertions.assertEquals((double)2.9129506302439405, (double)u.getGeometricMean()[1], (double)1.0E-10);
        Assertions.assertEquals((double)2.0, (double)u.getMean()[0], (double)1.0E-10);
        Assertions.assertEquals((double)3.0, (double)u.getMean()[1], (double)1.0E-10);
        Assertions.assertEquals((double)FastMath.sqrt((double)0.6666666666666666), (double)u.getStandardDeviation()[0], (double)1.0E-10);
        Assertions.assertEquals((double)FastMath.sqrt((double)0.6666666666666666), (double)u.getStandardDeviation()[1], (double)1.0E-10);
        Assertions.assertEquals((double)0.6666666666666666, (double)u.getCovariance().getEntry(0, 0), (double)1.0E-10);
        Assertions.assertEquals((double)0.6666666666666666, (double)u.getCovariance().getEntry(0, 1), (double)1.0E-10);
        Assertions.assertEquals((double)0.6666666666666666, (double)u.getCovariance().getEntry(1, 0), (double)1.0E-10);
        Assertions.assertEquals((double)0.6666666666666666, (double)u.getCovariance().getEntry(1, 1), (double)1.0E-10);
        u.clear();
        Assertions.assertEquals((long)0L, (long)u.getN());
    }

    @Test
    void testN0andN1Conditions() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(1, true);
        Assertions.assertTrue((boolean)Double.isNaN(u.getMean()[0]));
        Assertions.assertTrue((boolean)Double.isNaN(u.getStandardDeviation()[0]));
        u.addValue(new double[]{1.0});
        Assertions.assertEquals((double)1.0, (double)u.getMean()[0], (double)1.0E-10);
        Assertions.assertEquals((double)1.0, (double)u.getGeometricMean()[0], (double)1.0E-10);
        Assertions.assertEquals((double)0.0, (double)u.getStandardDeviation()[0], (double)1.0E-10);
        u.addValue(new double[]{2.0});
        Assertions.assertTrue((u.getStandardDeviation()[0] > 0.0 ? 1 : 0) != 0);
    }

    @Test
    void testNaNContracts() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(1, true);
        Assertions.assertTrue((boolean)Double.isNaN(u.getMean()[0]));
        Assertions.assertTrue((boolean)Double.isNaN(u.getMin()[0]));
        Assertions.assertTrue((boolean)Double.isNaN(u.getStandardDeviation()[0]));
        Assertions.assertTrue((boolean)Double.isNaN(u.getGeometricMean()[0]));
        u.addValue(new double[]{1.0});
        Assertions.assertFalse((boolean)Double.isNaN(u.getMean()[0]));
        Assertions.assertFalse((boolean)Double.isNaN(u.getMin()[0]));
        Assertions.assertFalse((boolean)Double.isNaN(u.getStandardDeviation()[0]));
        Assertions.assertFalse((boolean)Double.isNaN(u.getGeometricMean()[0]));
    }

    @Test
    void testSerialization() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(2, true);
        UnitTestUtils.checkSerializedEquality((Object)u);
        MultivariateSummaryStatistics s = (MultivariateSummaryStatistics)UnitTestUtils.serializeAndRecover((Object)u);
        Assertions.assertEquals((Object)u, (Object)s);
        u.addValue(new double[]{2.0, 1.0});
        u.addValue(new double[]{1.0, 1.0});
        u.addValue(new double[]{3.0, 1.0});
        u.addValue(new double[]{4.0, 1.0});
        u.addValue(new double[]{5.0, 1.0});
        UnitTestUtils.checkSerializedEquality((Object)u);
        s = (MultivariateSummaryStatistics)UnitTestUtils.serializeAndRecover((Object)u);
        Assertions.assertEquals((Object)u, (Object)s);
    }

    @Test
    void testEqualsAndHashCode() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(2, true);
        MultivariateSummaryStatistics t = null;
        int emptyHash = u.hashCode();
        Assertions.assertEquals((Object)u, (Object)u);
        Assertions.assertNotEquals((Object)u, t);
        Assertions.assertNotEquals((Object)u, (Object)0.0);
        t = this.createMultivariateSummaryStatistics(2, true);
        Assertions.assertEquals((Object)t, (Object)u);
        Assertions.assertEquals((Object)u, (Object)t);
        Assertions.assertEquals((int)emptyHash, (int)t.hashCode());
        u.addValue(new double[]{2.0, 1.0});
        u.addValue(new double[]{1.0, 1.0});
        u.addValue(new double[]{3.0, 1.0});
        u.addValue(new double[]{4.0, 1.0});
        u.addValue(new double[]{5.0, 1.0});
        Assertions.assertNotEquals((Object)t, (Object)u);
        Assertions.assertNotEquals((Object)u, (Object)t);
        Assertions.assertTrue((u.hashCode() != t.hashCode() ? 1 : 0) != 0);
        t.addValue(new double[]{2.0, 1.0});
        t.addValue(new double[]{1.0, 1.0});
        t.addValue(new double[]{3.0, 1.0});
        t.addValue(new double[]{4.0, 1.0});
        t.addValue(new double[]{5.0, 1.0});
        Assertions.assertEquals((Object)t, (Object)u);
        Assertions.assertEquals((Object)u, (Object)t);
        Assertions.assertEquals((int)u.hashCode(), (int)t.hashCode());
        u.clear();
        t.clear();
        Assertions.assertEquals((Object)t, (Object)u);
        Assertions.assertEquals((Object)u, (Object)t);
        Assertions.assertEquals((int)emptyHash, (int)t.hashCode());
        Assertions.assertEquals((int)emptyHash, (int)u.hashCode());
    }
}

