/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.Arrays;
import java.util.function.DoubleConsumer;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.UniformRealDistribution;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.Well19937a;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.util.FastMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamingStatisticsTest {
    private final double[] testArray = new double[]{1.0, 2.0, 2.0, 3.0};
    private final double one = 1.0;
    private final float twoF = 2.0f;
    private final double mean = 2.0;
    private final double sumSq = 18.0;
    private final double sum = 8.0;
    private final double var = 0.6666666666666666;
    private final double popVar = 0.5;
    private final double std = FastMath.sqrt((double)0.6666666666666666);
    private final double n = 4.0;
    private final double min = 1.0;
    private final double max = 3.0;
    private final double tolerance = 1.0E-14;

    StreamingStatisticsTest() {
    }

    protected StreamingStatistics createStreamingStatistics() {
        return new StreamingStatistics();
    }

    @Test
    void testStats() {
        StreamingStatistics u = this.createStreamingStatistics();
        Assertions.assertEquals((double)0.0, (double)u.getN(), (double)1.0E-14, (String)"total count");
        u.addValue(1.0);
        u.addValue(2.0);
        long twoL = 2L;
        u.addValue((double)twoL);
        int three = 3;
        u.addValue((double)three);
        Assertions.assertEquals((double)4.0, (double)u.getN(), (double)1.0E-14, (String)"N");
        Assertions.assertEquals((double)8.0, (double)u.getSum(), (double)1.0E-14, (String)"sum");
        Assertions.assertEquals((double)18.0, (double)u.getSumOfSquares(), (double)1.0E-14, (String)"sumsq");
        Assertions.assertEquals((double)0.6666666666666666, (double)u.getVariance(), (double)1.0E-14, (String)"var");
        Assertions.assertEquals((double)0.5, (double)u.getPopulationVariance(), (double)1.0E-14, (String)"population var");
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"std");
        Assertions.assertEquals((double)2.0, (double)u.getMean(), (double)1.0E-14, (String)"mean");
        Assertions.assertEquals((double)1.0, (double)u.getMin(), (double)1.0E-14, (String)"min");
        Assertions.assertEquals((double)3.0, (double)u.getMax(), (double)1.0E-14, (String)"max");
        u.clear();
        Assertions.assertEquals((double)0.0, (double)u.getN(), (double)1.0E-14, (String)"total count");
    }

    @Test
    void testConsume() {
        StreamingStatistics u = this.createStreamingStatistics();
        Assertions.assertEquals((double)0.0, (double)u.getN(), (double)1.0E-14, (String)"total count");
        Arrays.stream(this.testArray).forEach((DoubleConsumer)u);
        Assertions.assertEquals((double)4.0, (double)u.getN(), (double)1.0E-14, (String)"N");
        Assertions.assertEquals((double)8.0, (double)u.getSum(), (double)1.0E-14, (String)"sum");
        Assertions.assertEquals((double)18.0, (double)u.getSumOfSquares(), (double)1.0E-14, (String)"sumsq");
        Assertions.assertEquals((double)0.6666666666666666, (double)u.getVariance(), (double)1.0E-14, (String)"var");
        Assertions.assertEquals((double)0.5, (double)u.getPopulationVariance(), (double)1.0E-14, (String)"population var");
        Assertions.assertEquals((double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14, (String)"std");
        Assertions.assertEquals((double)2.0, (double)u.getMean(), (double)1.0E-14, (String)"mean");
        Assertions.assertEquals((double)1.0, (double)u.getMin(), (double)1.0E-14, (String)"min");
        Assertions.assertEquals((double)3.0, (double)u.getMax(), (double)1.0E-14, (String)"max");
        u.clear();
        Assertions.assertEquals((double)0.0, (double)u.getN(), (double)1.0E-14, (String)"total count");
    }

    @Test
    void testN0andN1Conditions() {
        StreamingStatistics u = this.createStreamingStatistics();
        Assertions.assertTrue((boolean)Double.isNaN(u.getMean()), (String)"Mean of n = 0 set should be NaN");
        Assertions.assertTrue((boolean)Double.isNaN(u.getStandardDeviation()), (String)"Standard Deviation of n = 0 set should be NaN");
        Assertions.assertTrue((boolean)Double.isNaN(u.getVariance()), (String)"Variance of n = 0 set should be NaN");
        u.addValue(1.0);
        Assertions.assertEquals((double)u.getMean(), (double)1.0, (String)"mean should be one (n = 1)");
        Assertions.assertEquals((double)u.getGeometricMean(), (double)1.0, (String)("geometric should be one (n = 1) instead it is " + u.getGeometricMean()));
        Assertions.assertEquals((double)0.0, (double)u.getStandardDeviation(), (String)"Std should be zero (n = 1)");
        Assertions.assertEquals((double)0.0, (double)u.getVariance(), (String)"variance should be zero (n = 1)");
        u.addValue(2.0);
        Assertions.assertTrue((u.getStandardDeviation() != 0.0 ? 1 : 0) != 0, (String)"Std should not be zero (n = 2)");
        Assertions.assertTrue((u.getVariance() != 0.0 ? 1 : 0) != 0, (String)"variance should not be zero (n = 2)");
    }

    @Test
    void testProductAndGeometricMean() {
        StreamingStatistics u = this.createStreamingStatistics();
        u.addValue(1.0);
        u.addValue(2.0);
        u.addValue(3.0);
        u.addValue(4.0);
        Assertions.assertEquals((double)2.213364, (double)u.getGeometricMean(), (double)1.0E-5, (String)"Geometric mean not expected");
    }

    @Test
    void testNaNContracts() {
        StreamingStatistics u = this.createStreamingStatistics();
        Assertions.assertTrue((boolean)Double.isNaN(u.getMean()), (String)"mean not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(u.getMin()), (String)"min not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(u.getStandardDeviation()), (String)"std dev not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(u.getVariance()), (String)"var not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(u.getGeometricMean()), (String)"geom mean not NaN");
        u.addValue(1.0);
        Assertions.assertEquals((double)1.0, (double)u.getMean(), (double)Double.MIN_VALUE, (String)"mean");
        Assertions.assertEquals((double)0.0, (double)u.getVariance(), (double)Double.MIN_VALUE, (String)"variance");
        Assertions.assertEquals((double)1.0, (double)u.getGeometricMean(), (double)Double.MIN_VALUE, (String)"geometric mean");
        u.addValue(-1.0);
        Assertions.assertTrue((boolean)Double.isNaN(u.getGeometricMean()), (String)"geom mean not NaN");
        u.addValue(0.0);
        Assertions.assertTrue((boolean)Double.isNaN(u.getGeometricMean()), (String)"geom mean not NaN");
    }

    @Test
    void testGetSummary() {
        StreamingStatistics u = this.createStreamingStatistics();
        StatisticalSummary summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(1.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        summary = u.getSummary();
        this.verifySummary(u, summary);
    }

    @Test
    void testSerialization() {
        StreamingStatistics u = this.createStreamingStatistics();
        UnitTestUtils.checkSerializedEquality((Object)u);
        StreamingStatistics s = (StreamingStatistics)UnitTestUtils.serializeAndRecover((Object)u);
        StatisticalSummary summary = s.getSummary();
        this.verifySummary(u, summary);
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        u.addValue(5.0);
        UnitTestUtils.checkSerializedEquality((Object)u);
        s = (StreamingStatistics)UnitTestUtils.serializeAndRecover((Object)u);
        summary = s.getSummary();
        this.verifySummary(u, summary);
    }

    @Test
    void testEqualsAndHashCode() {
        StreamingStatistics u = this.createStreamingStatistics();
        StreamingStatistics t = null;
        int emptyHash = u.hashCode();
        Assertions.assertEquals((Object)u, (Object)u, (String)"reflexive");
        Assertions.assertNotEquals((Object)u, t, (String)"non-null compared to null");
        Assertions.assertNotEquals((Object)u, (Object)0.0, (String)"wrong type");
        t = this.createStreamingStatistics();
        Assertions.assertEquals((Object)t, (Object)u, (String)"empty instances should be equal");
        Assertions.assertEquals((Object)u, (Object)t, (String)"empty instances should be equal");
        Assertions.assertEquals((int)emptyHash, (int)t.hashCode(), (String)"empty hash code");
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        Assertions.assertNotEquals((Object)t, (Object)u, (String)"different n's should make instances not equal");
        Assertions.assertNotEquals((Object)u, (Object)t, (String)"different n's should make instances not equal");
        Assertions.assertTrue((u.hashCode() != t.hashCode() ? 1 : 0) != 0, (String)"different n's should make hashcodes different");
        t.addValue(2.0);
        t.addValue(1.0);
        t.addValue(3.0);
        t.addValue(4.0);
        Assertions.assertEquals((Object)t, (Object)u, (String)"summaries based on same data should be equal");
        Assertions.assertEquals((Object)u, (Object)t, (String)"summaries based on same data should be equal");
        Assertions.assertEquals((int)u.hashCode(), (int)t.hashCode(), (String)"summaries based on same data should have same hashcodes");
        u.clear();
        t.clear();
        Assertions.assertEquals((Object)t, (Object)u, (String)"empty instances should be equal");
        Assertions.assertEquals((Object)u, (Object)t, (String)"empty instances should be equal");
        Assertions.assertEquals((int)emptyHash, (int)t.hashCode(), (String)"empty hash code");
        Assertions.assertEquals((int)emptyHash, (int)u.hashCode(), (String)"empty hash code");
    }

    @Test
    void testCopy() {
        StreamingStatistics u = this.createStreamingStatistics();
        u.addValue(2.0);
        u.addValue(1.0);
        u.addValue(3.0);
        u.addValue(4.0);
        StreamingStatistics v = u.copy();
        Assertions.assertEquals((Object)u, (Object)v);
        Assertions.assertEquals((Object)v, (Object)u);
        u.addValue(7.0);
        u.addValue(9.0);
        u.addValue(11.0);
        u.addValue(23.0);
        v.addValue(7.0);
        v.addValue(9.0);
        v.addValue(11.0);
        v.addValue(23.0);
        Assertions.assertEquals((Object)u, (Object)v);
        Assertions.assertEquals((Object)v, (Object)u);
    }

    private void verifySummary(StreamingStatistics u, StatisticalSummary s) {
        Assertions.assertEquals((long)s.getN(), (long)u.getN(), (String)"N");
        UnitTestUtils.customAssertEquals((String)"sum", (double)s.getSum(), (double)u.getSum(), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((String)"var", (double)s.getVariance(), (double)u.getVariance(), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((String)"std", (double)s.getStandardDeviation(), (double)u.getStandardDeviation(), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((String)"mean", (double)s.getMean(), (double)u.getMean(), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((String)"min", (double)s.getMin(), (double)u.getMin(), (double)1.0E-14);
        UnitTestUtils.customAssertEquals((String)"max", (double)s.getMax(), (double)u.getMax(), (double)1.0E-14);
    }

    @Test
    void testQuadraticMean() {
        double[] values = new double[]{1.2, 3.4, 5.6, 7.89};
        StreamingStatistics stats = this.createStreamingStatistics();
        int len = values.length;
        double expected = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = values[i];
            expected += v * v / (double)len;
            stats.addValue(v);
        }
        expected = Math.sqrt(expected);
        Assertions.assertEquals((double)expected, (double)stats.getQuadraticMean(), (double)Math.ulp(expected));
    }

    @Test
    void testToString() {
        StreamingStatistics u = this.createStreamingStatistics();
        for (int i = 0; i < 5; ++i) {
            u.addValue((double)i);
        }
        String[] labels = new String[]{"min", "max", "sum", "geometric mean", "variance", "population variance", "second moment", "sum of squares", "standard deviation", "sum of logs"};
        double[] values = new double[]{u.getMin(), u.getMax(), u.getSum(), u.getGeometricMean(), u.getVariance(), u.getPopulationVariance(), u.getSecondMoment(), u.getSumOfSquares(), u.getStandardDeviation(), u.getSumOfLogs()};
        String toString = u.toString();
        Assertions.assertTrue((toString.indexOf("n: " + u.getN()) > 0 ? 1 : 0) != 0);
        for (int i = 0; i < values.length; ++i) {
            Assertions.assertTrue((toString.indexOf(labels[i] + ": " + String.valueOf(values[i])) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    void testAggregationConsistency() {
        int i;
        double[] totalSample = this.generateSample();
        double[][] subSamples = this.generatePartition(totalSample);
        int nSamples = subSamples.length;
        StreamingStatistics aggregate = new StreamingStatistics();
        StreamingStatistics totalStats = new StreamingStatistics();
        Object[] componentStats = new StreamingStatistics[nSamples];
        for (i = 0; i < nSamples; ++i) {
            componentStats[i] = new StreamingStatistics();
            for (int j = 0; j < subSamples[i].length; ++j) {
                componentStats[i].addValue(subSamples[i][j]);
            }
        }
        aggregate.aggregate(componentStats);
        for (i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        StreamingStatisticsTest.customAssertSummaryStatisticsEquals(totalStats, aggregate, 1.0E-10);
        double tol = 1.0E-13;
        Assertions.assertEquals((double)totalStats.getPercentile(10.0), (double)aggregate.getPercentile(10.0), (double)1.0E-13);
        Assertions.assertEquals((double)totalStats.getPercentile(25.0), (double)aggregate.getPercentile(25.0), (double)1.0E-13);
        Assertions.assertEquals((double)totalStats.getPercentile(50.0), (double)aggregate.getPercentile(50.0), (double)1.0E-13);
        Assertions.assertEquals((double)totalStats.getPercentile(75.0), (double)aggregate.getPercentile(75.0), (double)1.0E-13);
        Assertions.assertEquals((double)totalStats.getPercentile(90.0), (double)aggregate.getPercentile(90.0), (double)1.0E-13);
        Assertions.assertEquals((double)totalStats.getPercentile(99.0), (double)aggregate.getPercentile(99.0), (double)1.0E-13);
    }

    @Test
    void testAggregateDegenerate() {
        int i;
        double[] totalSample = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[][] subSamples = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}, {5.0}};
        StreamingStatistics totalStats = new StreamingStatistics();
        for (int i2 = 0; i2 < totalSample.length; ++i2) {
            totalStats.addValue(totalSample[i2]);
        }
        Object[] subSampleStats = new StreamingStatistics[5];
        for (i = 0; i < 5; ++i) {
            subSampleStats[i] = new StreamingStatistics();
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
        }
        StreamingStatistics aggregatedStats = new StreamingStatistics();
        aggregatedStats.aggregate(subSampleStats);
        StreamingStatisticsTest.customAssertSummaryStatisticsEquals(totalStats, aggregatedStats, 1.0E-9);
    }

    @Test
    void testAggregateSpecialValues() {
        int i;
        double[] totalSample = new double[]{Double.POSITIVE_INFINITY, 2.0, 3.0, Double.NaN, 5.0};
        double[][] subSamples = new double[][]{{Double.POSITIVE_INFINITY, 2.0}, {3.0}, {Double.NaN}, {5.0}};
        StreamingStatistics totalStats = new StreamingStatistics();
        for (int i2 = 0; i2 < totalSample.length; ++i2) {
            totalStats.addValue(totalSample[i2]);
        }
        Object[] subSampleStats = new StreamingStatistics[4];
        for (i = 0; i < 4; ++i) {
            subSampleStats[i] = new StreamingStatistics();
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
        }
        StreamingStatistics aggregatedStats = new StreamingStatistics();
        aggregatedStats.aggregate(subSampleStats);
        StreamingStatisticsTest.customAssertSummaryStatisticsEquals(totalStats, aggregatedStats, 1.0E-9);
    }

    @Test
    void testBuilderDefault() {
        StreamingStatistics stats = StreamingStatistics.builder().build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    void testBuilderPercentilesOn() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertEquals((double)0.0, (double)stats.getSum(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertEquals((double)0.0, (double)stats.getSumOfSquares(), (double)1.0E-15);
        Assertions.assertEquals((double)0.0, (double)stats.getSumOfLogs(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    void testBuilderMomentsOff() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).moments(false).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getSum()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getSum()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertEquals((double)0.0, (double)stats.getSumOfSquares(), (double)1.0E-15);
        Assertions.assertEquals((double)0.0, (double)stats.getSumOfLogs(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    void testBuilderSumOfLogsOff() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).sumOfLogs(false).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertEquals((double)0.0, (double)stats.getSum(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertEquals((double)0.0, (double)stats.getSumOfSquares(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    void testBuilderExtremaOff() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).extrema(false).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertEquals((double)0.0, (double)stats.getSum(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertEquals((double)0.0, (double)stats.getSumOfSquares(), (double)1.0E-15);
        Assertions.assertEquals((double)0.0, (double)stats.getSumOfLogs(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    @Test
    void testBuilderSumOfSquares() {
        StreamingStatistics stats = StreamingStatistics.builder().percentiles(1.0E-6, (RandomGenerator)new Well19937a(-7268900213636067286L)).sumOfSquares(false).build();
        stats.addValue(10.0);
        stats.addValue(20.0);
        stats.addValue(30.0);
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSum()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getSumOfLogs()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertFalse((boolean)Double.isNaN(stats.getPercentile(10.0)));
        stats.clear();
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMax()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMin()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMean()));
        Assertions.assertEquals((double)0.0, (double)stats.getSum(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPopulationVariance()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getStandardDeviation()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getGeometricMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getQuadraticMean()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getSumOfSquares()));
        Assertions.assertEquals((double)0.0, (double)stats.getSumOfLogs(), (double)1.0E-15);
        Assertions.assertTrue((boolean)Double.isNaN(stats.getMedian()));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
        Assertions.assertTrue((boolean)Double.isNaN(stats.getPercentile(10.0)));
    }

    protected static void customAssertSummaryStatisticsEquals(StreamingStatistics expected, StreamingStatistics observed, double delta) {
        UnitTestUtils.customAssertEquals((double)expected.getMax(), (double)observed.getMax(), (double)0.0);
        UnitTestUtils.customAssertEquals((double)expected.getMin(), (double)observed.getMin(), (double)0.0);
        Assertions.assertEquals((long)expected.getN(), (long)observed.getN());
        UnitTestUtils.customAssertEquals((double)expected.getSum(), (double)observed.getSum(), (double)delta);
        UnitTestUtils.customAssertEquals((double)expected.getMean(), (double)observed.getMean(), (double)delta);
        UnitTestUtils.customAssertEquals((double)expected.getStandardDeviation(), (double)observed.getStandardDeviation(), (double)delta);
        UnitTestUtils.customAssertEquals((double)expected.getVariance(), (double)observed.getVariance(), (double)delta);
    }

    private double[] generateSample() {
        UniformRealDistribution uniformDist = new UniformRealDistribution(-100.0, 100.0);
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        int sampleSize = randomDataGenerator.nextInt(10, 100);
        double[] out = randomDataGenerator.nextDeviates((RealDistribution)uniformDist, sampleSize);
        return out;
    }

    private double[][] generatePartition(double[] sample) {
        int subLength;
        int length = sample.length;
        double[][] out = new double[5][];
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        int cur = 0;
        int offset = 0;
        int sampleCount = 0;
        for (int i = 0; i < 5 && cur != length && offset != length; offset += subLength, ++i) {
            int next = i == 4 || cur == length - 1 ? length - 1 : randomDataGenerator.nextInt(cur, length - 1);
            subLength = next - cur + 1;
            out[i] = new double[subLength];
            System.arraycopy(sample, offset, out[i], 0, subLength);
            cur = next + 1;
            ++sampleCount;
        }
        if (sampleCount < 5) {
            double[][] out2 = new double[sampleCount][];
            for (int j = 0; j < sampleCount; ++j) {
                int curSize = out[j].length;
                out2[j] = new double[curSize];
                System.arraycopy(out[j], 0, out2[j], 0, curSize);
            }
            return out2;
        }
        return out;
    }
}

