/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MeanTest
extends StorelessUnivariateStatisticAbstractTest {
    public Mean getUnivariateStatistic() {
        return new Mean();
    }

    @Override
    public double expectedValue() {
        return this.mean;
    }

    public double expectedWeightedValue() {
        return this.weightedMean;
    }

    @Test
    void testSmallSamples() {
        Mean mean = this.getUnivariateStatistic();
        Assertions.assertTrue((boolean)Double.isNaN(mean.getResult()));
        mean.increment(1.0);
        Assertions.assertEquals((double)1.0, (double)mean.getResult(), (double)0.0);
    }

    @Test
    void testWeightedMean() {
        Mean mean = this.getUnivariateStatistic();
        Assertions.assertEquals((double)this.expectedWeightedValue(), (double)mean.evaluate(this.testArray, this.testWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assertions.assertEquals((double)this.expectedValue(), (double)mean.evaluate(this.testArray, this.identicalWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
    }
}

