/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import org.hipparchus.stat.descriptive.UnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.rank.Median;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.hipparchus.stat.ranking.NaNStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MedianTest
extends UnivariateStatisticAbstractTest {
    private final Percentile.EstimationType estimationType = Percentile.EstimationType.LEGACY;

    public Median getUnivariateStatistic() {
        return new Median().withEstimationType(this.estimationType);
    }

    private Median getTestMedian(Percentile.EstimationType type) {
        NaNStrategy strategy = type == Percentile.EstimationType.LEGACY ? NaNStrategy.FIXED : NaNStrategy.REMOVED;
        return new Median().withEstimationType(type).withNaNStrategy(strategy);
    }

    @Override
    public double expectedValue() {
        return this.median;
    }

    @Test
    void testAllTechniquesSingleton() {
        double[] singletonArray = new double[]{1.0};
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            Median percentile = this.getTestMedian(e);
            Assertions.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray), (double)0.0);
            Assertions.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1), (double)0.0);
            Assertions.assertTrue((boolean)Double.isNaN(percentile.evaluate(singletonArray, 0, 0)));
        }
    }

    @Test
    void testAllTechniquesMedian() {
        double[] d = new double[]{1.0, 3.0, 2.0, 4.0};
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 2.5}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.5}, {Percentile.EstimationType.R_3, 2.0}, {Percentile.EstimationType.R_4, 2.0}, {Percentile.EstimationType.R_5, 2.5}, {Percentile.EstimationType.R_6, 2.5}, {Percentile.EstimationType.R_7, 2.5}, {Percentile.EstimationType.R_8, 2.5}, {Percentile.EstimationType.R_9, 2.5}}, 1.0E-5);
    }

    protected void testAssertMappedValues(double[] d, Object[][] map, Double tolerance) {
        for (Object[] o : map) {
            Percentile.EstimationType e = (Percentile.EstimationType)o[0];
            double expected = (Double)o[1];
            double result = this.getTestMedian(e).evaluate(d);
            Assertions.assertEquals((double)expected, (double)result, (double)tolerance, (String)("expected[" + e + "] = " + expected + " but was = " + result));
        }
    }
}

