/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.vector;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.stat.descriptive.vector.VectorialCovariance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VectorialCovarianceTest {
    private double[][] points = new double[][]{{1.2, 2.3, 4.5}, {-0.7, 2.3, 5.0}, {3.1, 0.0, -3.1}, {6.0, 1.2, 4.2}, {-0.7, 2.3, 5.0}};

    @Test
    void testMismatch() {
        try {
            new VectorialCovariance(8, true).increment(new double[5]);
            Assertions.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException dme) {
            Assertions.assertEquals((int)5, (int)((Integer)dme.getParts()[0]));
            Assertions.assertEquals((int)8, (int)((Integer)dme.getParts()[1]));
        }
    }

    @Test
    void testSimplistic() {
        VectorialCovariance stat = new VectorialCovariance(2, true);
        stat.increment(new double[]{-1.0, 1.0});
        stat.increment(new double[]{1.0, -1.0});
        RealMatrix c = stat.getResult();
        Assertions.assertEquals((double)2.0, (double)c.getEntry(0, 0), (double)1.0E-12);
        Assertions.assertEquals((double)-2.0, (double)c.getEntry(1, 0), (double)1.0E-12);
        Assertions.assertEquals((double)2.0, (double)c.getEntry(1, 1), (double)1.0E-12);
    }

    @Test
    void testBasicStats() {
        VectorialCovariance stat = new VectorialCovariance(this.points[0].length, true);
        for (int i = 0; i < this.points.length; ++i) {
            stat.increment(this.points[i]);
        }
        Assertions.assertEquals((long)this.points.length, (long)stat.getN());
        RealMatrix c = stat.getResult();
        double[][] refC = new double[][]{{8.047, -1.9195, -3.4445}, {-1.9195, 1.047, 3.2795}, {-3.4445, 3.2795, 12.207}};
        for (int i = 0; i < c.getRowDimension(); ++i) {
            for (int j = 0; j <= i; ++j) {
                Assertions.assertEquals((double)refC[i][j], (double)c.getEntry(i, j), (double)1.0E-12);
            }
        }
    }

    @Test
    void testSerial() {
        VectorialCovariance stat = new VectorialCovariance(this.points[0].length, true);
        Assertions.assertEquals((Object)stat, (Object)UnitTestUtils.serializeAndRecover((Object)stat));
    }
}

