/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.inference.GTest;
import org.hipparchus.util.FastMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GTestTest {
    protected GTest testStatistic = new GTest();

    GTestTest() {
    }

    @Test
    void testGTestGoodnesOfFit1() throws Exception {
        double[] exp = new double[]{3.0, 1.0};
        long[] obs = new long[]{423L, 133L};
        Assertions.assertEquals((double)0.348721, (double)this.testStatistic.g(exp, obs), (double)1.0E-6, (String)"G test statistic");
        double p_gtgf = this.testStatistic.gTest(exp, obs);
        Assertions.assertEquals((double)0.55483, (double)p_gtgf, (double)1.0E-5, (String)"g-Test p-value");
        Assertions.assertFalse((boolean)this.testStatistic.gTest(exp, obs, 0.05));
    }

    @Test
    void testGTestGoodnesOfFit2() throws Exception {
        double[] exp = new double[]{0.54, 0.4, 0.05, 0.01};
        long[] obs = new long[]{70L, 79L, 3L, 4L};
        Assertions.assertEquals((double)13.144799, (double)this.testStatistic.g(exp, obs), (double)1.0E-6, (String)"G test statistic");
        double p_gtgf = this.testStatistic.gTest(exp, obs);
        Assertions.assertEquals((double)0.004333, (double)p_gtgf, (double)1.0E-5, (String)"g-Test p-value");
        Assertions.assertTrue((boolean)this.testStatistic.gTest(exp, obs, 0.05));
    }

    @Test
    void testGTestGoodnesOfFit3() throws Exception {
        double[] exp = new double[]{0.167, 0.483, 0.35};
        long[] obs = new long[]{14L, 21L, 25L};
        Assertions.assertEquals((double)4.5554, (double)this.testStatistic.g(exp, obs), (double)1.0E-4, (String)"G test statistic");
        double p_gtgf = this.testStatistic.gTestIntrinsic(exp, obs);
        Assertions.assertEquals((double)0.0328, (double)p_gtgf, (double)1.0E-4, (String)"g-Test p-value");
        Assertions.assertFalse((boolean)this.testStatistic.gTest(exp, obs, 0.05));
    }

    @Test
    void testGTestIndependance1() throws Exception {
        long[] obs1 = new long[]{268L, 199L, 42L};
        long[] obs2 = new long[]{807L, 759L, 184L};
        double g = this.testStatistic.gDataSetsComparison(obs1, obs2);
        Assertions.assertEquals((double)7.300817, (double)g, (double)1.0E-6, (String)"G test statistic");
        double p_gti = this.testStatistic.gTestDataSetsComparison(obs1, obs2);
        Assertions.assertEquals((double)0.0259805, (double)p_gti, (double)1.0E-6, (String)"g-Test p-value");
        Assertions.assertTrue((boolean)this.testStatistic.gTestDataSetsComparison(obs1, obs2, 0.05));
    }

    @Test
    void testGTestIndependance2() throws Exception {
        long[] obs1 = new long[]{127L, 99L, 264L};
        long[] obs2 = new long[]{116L, 67L, 161L};
        double g = this.testStatistic.gDataSetsComparison(obs1, obs2);
        Assertions.assertEquals((double)6.227288, (double)g, (double)1.0E-6, (String)"G test statistic");
        double p_gti = this.testStatistic.gTestDataSetsComparison(obs1, obs2);
        Assertions.assertEquals((double)0.04443, (double)p_gti, (double)1.0E-5, (String)"g-Test p-value");
        Assertions.assertTrue((boolean)this.testStatistic.gTestDataSetsComparison(obs1, obs2, 0.05));
    }

    @Test
    void testGTestIndependance3() throws Exception {
        long[] obs1 = new long[]{190L, 149L};
        long[] obs2 = new long[]{42L, 49L};
        double g = this.testStatistic.gDataSetsComparison(obs1, obs2);
        Assertions.assertEquals((double)2.8187, (double)g, (double)1.0E-4, (String)"G test statistic");
        double p_gti = this.testStatistic.gTestDataSetsComparison(obs1, obs2);
        Assertions.assertEquals((double)0.09317325, (double)p_gti, (double)1.0E-6, (String)"g-Test p-value");
        Assertions.assertFalse((boolean)this.testStatistic.gTestDataSetsComparison(obs1, obs2, 0.05));
    }

    @Test
    void testGTestSetsComparisonBadCounts() {
        long[] observed1 = new long[]{10L, -1L, 12L, 10L, 15L};
        long[] observed2 = new long[]{15L, 10L, 10L, 15L, 5L};
        try {
            this.testStatistic.gTestDataSetsComparison(observed1, observed2);
            Assertions.fail((String)"Expecting MathIllegalArgumentException - negative count");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[] observed3 = new long[]{10L, 0L, 12L, 10L, 15L};
        long[] observed4 = new long[]{15L, 0L, 10L, 15L, 5L};
        try {
            this.testStatistic.gTestDataSetsComparison(observed3, observed4);
            Assertions.fail((String)"Expecting MathIllegalArgumentException - double 0's");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        long[] observed5 = new long[]{10L, 10L, 12L, 10L, 15L};
        long[] observed6 = new long[]{0L, 0L, 0L, 0L, 0L};
        try {
            this.testStatistic.gTestDataSetsComparison(observed5, observed6);
            Assertions.fail((String)"Expecting MathIllegalArgumentException - vanishing counts");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testUnmatchedArrays() {
        long[] observed = new long[]{0L, 1L, 2L, 3L};
        double[] expected = new double[]{1.0, 1.0, 2.0};
        long[] observed2 = new long[]{3L, 4L};
        try {
            this.testStatistic.gTest(expected, observed);
            Assertions.fail((String)"arrays have different lengths, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.gTestDataSetsComparison(observed, observed2);
            Assertions.fail((String)"arrays have different lengths, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testNegativeObservedCounts() {
        long[] observed = new long[]{0L, 1L, 2L, -3L};
        double[] expected = new double[]{1.0, 1.0, 2.0, 3.0};
        long[] observed2 = new long[]{3L, 4L, 5L, 0L};
        try {
            this.testStatistic.gTest(expected, observed);
            Assertions.fail((String)"negative observed count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.gTestDataSetsComparison(observed, observed2);
            Assertions.fail((String)"negative observed count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testZeroExpectedCounts() {
        long[] observed = new long[]{0L, 1L, 2L, -3L};
        double[] expected = new double[]{1.0, 0.0, 2.0, 3.0};
        try {
            this.testStatistic.gTest(expected, observed);
            Assertions.fail((String)"zero expected count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testBadAlpha() {
        long[] observed = new long[]{0L, 1L, 2L, 3L};
        double[] expected = new double[]{1.0, 2.0, 2.0, 3.0};
        long[] observed2 = new long[]{0L, 2L, 2L, 3L};
        try {
            this.testStatistic.gTest(expected, observed, 0.8);
            Assertions.fail((String)"zero expected count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.gTestDataSetsComparison(observed, observed2, -0.5);
            Assertions.fail((String)"zero expected count, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testScaling() {
        long[] observed = new long[]{9L, 11L, 10L, 8L, 12L};
        double[] expected1 = new double[]{10.0, 10.0, 10.0, 10.0, 10.0};
        double[] expected2 = new double[]{1000.0, 1000.0, 1000.0, 1000.0, 1000.0};
        double[] expected3 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        double tol = 1.0E-15;
        Assertions.assertEquals((double)this.testStatistic.gTest(expected1, observed), (double)this.testStatistic.gTest(expected2, observed), (double)1.0E-15);
        Assertions.assertEquals((double)this.testStatistic.gTest(expected1, observed), (double)this.testStatistic.gTest(expected3, observed), (double)1.0E-15);
    }

    @Test
    void testRootLogLikelihood() {
        Assertions.assertTrue((this.testStatistic.rootLogLikelihoodRatio(904L, 21060L, 1144L, 283012L) > 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testStatistic.rootLogLikelihoodRatio(36L, 21928L, 60280L, 623876L) < 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)FastMath.sqrt((double)2.772589), (double)this.testStatistic.rootLogLikelihoodRatio(1L, 0L, 0L, 1L), (double)1.0E-6);
        Assertions.assertEquals((double)(-FastMath.sqrt((double)2.772589)), (double)this.testStatistic.rootLogLikelihoodRatio(0L, 1L, 1L, 0L), (double)1.0E-6);
        Assertions.assertEquals((double)FastMath.sqrt((double)27.72589), (double)this.testStatistic.rootLogLikelihoodRatio(10L, 0L, 0L, 10L), (double)1.0E-5);
        Assertions.assertEquals((double)FastMath.sqrt((double)39.33052), (double)this.testStatistic.rootLogLikelihoodRatio(5L, 1995L, 0L, 100000L), (double)1.0E-5);
        Assertions.assertEquals((double)(-FastMath.sqrt((double)39.33052)), (double)this.testStatistic.rootLogLikelihoodRatio(0L, 100000L, 5L, 1995L), (double)1.0E-5);
        Assertions.assertEquals((double)FastMath.sqrt((double)4730.737), (double)this.testStatistic.rootLogLikelihoodRatio(1000L, 1995L, 1000L, 100000L), (double)0.001);
        Assertions.assertEquals((double)(-FastMath.sqrt((double)4730.737)), (double)this.testStatistic.rootLogLikelihoodRatio(1000L, 100000L, 1000L, 1995L), (double)0.001);
        Assertions.assertEquals((double)FastMath.sqrt((double)5734.343), (double)this.testStatistic.rootLogLikelihoodRatio(1000L, 1000L, 1000L, 100000L), (double)0.001);
        Assertions.assertEquals((double)FastMath.sqrt((double)5714.932), (double)this.testStatistic.rootLogLikelihoodRatio(1000L, 1000L, 1000L, 99000L), (double)0.001);
    }
}

