/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.stat.inference.TTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TTestTest {
    protected TTest testStatistic = new TTest();
    private double[] tooShortObs = new double[]{1.0};
    private double[] emptyObs = new double[0];
    private StreamingStatistics emptyStats = new StreamingStatistics();
    StreamingStatistics tooShortStats = null;

    TTestTest() {
    }

    @BeforeEach
    void setUp() {
        this.tooShortStats = new StreamingStatistics();
        this.tooShortStats.addValue(0.0);
    }

    @Test
    void testOneSampleT() {
        double[] observed = new double[]{93.0, 103.0, 95.0, 101.0, 91.0, 105.0, 96.0, 94.0, 101.0, 88.0, 98.0, 94.0, 101.0, 92.0, 95.0};
        double mu = 100.0;
        StreamingStatistics sampleStats = null;
        sampleStats = new StreamingStatistics();
        for (int i = 0; i < observed.length; ++i) {
            sampleStats.addValue(observed[i]);
        }
        Assertions.assertEquals((double)-2.81976445346, (double)this.testStatistic.t(mu, observed), (double)1.0E-9, (String)"t statistic");
        Assertions.assertEquals((double)-2.81976445346, (double)this.testStatistic.t(mu, (StatisticalSummary)sampleStats), (double)1.0E-9, (String)"t statistic");
        Assertions.assertEquals((double)0.0136390585873, (double)this.testStatistic.tTest(mu, observed), (double)1.0E-9, (String)"p value");
        Assertions.assertEquals((double)0.0136390585873, (double)this.testStatistic.tTest(mu, (StatisticalSummary)sampleStats), (double)1.0E-9, (String)"p value");
        try {
            this.testStatistic.t(mu, (double[])null);
            Assertions.fail((String)"arguments too short, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, (StatisticalSummary)((StreamingStatistics)null));
            Assertions.fail((String)"arguments too short, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, this.emptyObs);
            Assertions.fail((String)"arguments too short, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, (StatisticalSummary)this.emptyStats);
            Assertions.fail((String)"arguments too short, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, this.tooShortObs);
            Assertions.fail((String)"insufficient data to compute t statistic, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(mu, this.tooShortObs);
            Assertions.fail((String)"insufficient data to perform t test, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, (StatisticalSummary)this.tooShortStats);
            Assertions.fail((String)"insufficient data to compute t statistic, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(mu, (StatisticalSummary)this.tooShortStats);
            Assertions.fail((String)"insufficient data to perform t test, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testOneSampleTTest() {
        double[] oneSidedP = new double[]{2.0, 0.0, 6.0, 6.0, 3.0, 3.0, 2.0, 3.0, -6.0, 6.0, 6.0, 6.0, 3.0, 0.0, 1.0, 1.0, 0.0, 2.0, 3.0, 3.0};
        StreamingStatistics oneSidedPStats = new StreamingStatistics();
        for (int i = 0; i < oneSidedP.length; ++i) {
            oneSidedPStats.addValue(oneSidedP[i]);
        }
        Assertions.assertEquals((double)3.86485535541, (double)this.testStatistic.t(0.0, oneSidedP), (double)1.0E-9, (String)"one sample t stat");
        Assertions.assertEquals((double)3.86485535541, (double)this.testStatistic.t(0.0, (StatisticalSummary)oneSidedPStats), (double)1.0E-10, (String)"one sample t stat");
        Assertions.assertEquals((double)5.21637019637E-4, (double)(this.testStatistic.tTest(0.0, oneSidedP) / 2.0), (double)1.0E-9, (String)"one sample p value");
        Assertions.assertEquals((double)5.21637019637E-4, (double)(this.testStatistic.tTest(0.0, (StatisticalSummary)oneSidedPStats) / 2.0), (double)1.0E-4, (String)"one sample p value");
        Assertions.assertTrue((boolean)this.testStatistic.tTest(0.0, oneSidedP, 0.01), (String)"one sample t-test reject");
        Assertions.assertTrue((boolean)this.testStatistic.tTest(0.0, (StatisticalSummary)oneSidedPStats, 0.01), (String)"one sample t-test reject");
        Assertions.assertFalse((boolean)this.testStatistic.tTest(0.0, oneSidedP, 1.0E-4), (String)"one sample t-test accept");
        Assertions.assertFalse((boolean)this.testStatistic.tTest(0.0, (StatisticalSummary)oneSidedPStats, 1.0E-4), (String)"one sample t-test accept");
        try {
            this.testStatistic.tTest(0.0, oneSidedP, 95.0);
            Assertions.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(0.0, (StatisticalSummary)oneSidedPStats, 95.0);
            Assertions.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testTwoSampleTHeterscedastic() {
        double[] sample1 = new double[]{7.0, -4.0, 18.0, 17.0, -3.0, -5.0, 1.0, 10.0, 11.0, -2.0};
        double[] sample2 = new double[]{-1.0, 12.0, -1.0, -3.0, 3.0, -5.0, 5.0, 2.0, -11.0, -1.0, -3.0};
        StreamingStatistics sampleStats1 = new StreamingStatistics();
        for (int i = 0; i < sample1.length; ++i) {
            sampleStats1.addValue(sample1[i]);
        }
        StreamingStatistics sampleStats2 = new StreamingStatistics();
        for (int i = 0; i < sample2.length; ++i) {
            sampleStats2.addValue(sample2[i]);
        }
        Assertions.assertEquals((double)1.60371728768, (double)this.testStatistic.t(sample1, sample2), (double)1.0E-10, (String)"two sample heteroscedastic t stat");
        Assertions.assertEquals((double)1.60371728768, (double)this.testStatistic.t((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10, (String)"two sample heteroscedastic t stat");
        Assertions.assertEquals((double)0.128839369622, (double)this.testStatistic.tTest(sample1, sample2), (double)1.0E-10, (String)"two sample heteroscedastic p value");
        Assertions.assertEquals((double)0.128839369622, (double)this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10, (String)"two sample heteroscedastic p value");
        Assertions.assertTrue((boolean)this.testStatistic.tTest(sample1, sample2, 0.2), (String)"two sample heteroscedastic t-test reject");
        Assertions.assertTrue((boolean)this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, 0.2), (String)"two sample heteroscedastic t-test reject");
        Assertions.assertFalse((boolean)this.testStatistic.tTest(sample1, sample2, 0.1), (String)"two sample heteroscedastic t-test accept");
        Assertions.assertFalse((boolean)this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, 0.1), (String)"two sample heteroscedastic t-test accept");
        try {
            this.testStatistic.tTest(sample1, sample2, 0.95);
            Assertions.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, 0.95);
            Assertions.fail((String)"alpha out of range, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(sample1, this.tooShortObs, 0.01);
            Assertions.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)this.tooShortStats, 0.01);
            Assertions.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(sample1, this.tooShortObs);
            Assertions.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)this.tooShortStats);
            Assertions.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(sample1, this.tooShortObs);
            Assertions.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t((StatisticalSummary)sampleStats1, (StatisticalSummary)this.tooShortStats);
            Assertions.fail((String)"insufficient data, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testTwoSampleTHomoscedastic() {
        double[] sample1 = new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 97.0};
        double[] sample2 = new double[]{4.0, 6.0, 8.0, 10.0, 16.0};
        StreamingStatistics sampleStats1 = new StreamingStatistics();
        for (int i = 0; i < sample1.length; ++i) {
            sampleStats1.addValue(sample1[i]);
        }
        StreamingStatistics sampleStats2 = new StreamingStatistics();
        for (int i = 0; i < sample2.length; ++i) {
            sampleStats2.addValue(sample2[i]);
        }
        Assertions.assertEquals((double)0.73096310086, (double)this.testStatistic.homoscedasticT(sample1, sample2), (double)1.0E-10, (String)"two sample homoscedastic t stat");
        Assertions.assertEquals((double)0.4833963785, (double)this.testStatistic.homoscedasticTTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10, (String)"two sample homoscedastic p value");
        Assertions.assertTrue((boolean)this.testStatistic.homoscedasticTTest(sample1, sample2, 0.49), (String)"two sample homoscedastic t-test reject");
        Assertions.assertFalse((boolean)this.testStatistic.homoscedasticTTest(sample1, sample2, 0.48), (String)"two sample homoscedastic t-test accept");
    }

    @Test
    void testSmallSamples() {
        double[] sample1 = new double[]{1.0, 3.0};
        double[] sample2 = new double[]{4.0, 5.0};
        Assertions.assertEquals((double)-2.2360679775, (double)this.testStatistic.t(sample1, sample2), (double)1.0E-10);
        Assertions.assertEquals((double)0.198727388935, (double)this.testStatistic.tTest(sample1, sample2), (double)1.0E-10);
    }

    @Test
    void testPaired() {
        double[] sample1 = new double[]{1.0, 3.0, 5.0, 7.0};
        double[] sample2 = new double[]{0.0, 6.0, 11.0, 2.0};
        double[] sample3 = new double[]{5.0, 7.0, 8.0, 10.0};
        Assertions.assertEquals((double)-0.3133, (double)this.testStatistic.pairedT(sample1, sample2), (double)1.0E-4);
        Assertions.assertEquals((double)0.774544295819, (double)this.testStatistic.pairedTTest(sample1, sample2), (double)1.0E-10);
        Assertions.assertEquals((double)0.001208, (double)this.testStatistic.pairedTTest(sample1, sample3), (double)1.0E-6);
        Assertions.assertFalse((boolean)this.testStatistic.pairedTTest(sample1, sample3, 0.001));
        Assertions.assertTrue((boolean)this.testStatistic.pairedTTest(sample1, sample3, 0.002));
    }
}

