/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.regression;

import java.util.Random;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.ISAACRandom;
import org.hipparchus.stat.LocalizedStatFormats;
import org.hipparchus.stat.regression.RegressionResults;
import org.hipparchus.stat.regression.SimpleRegression;
import org.hipparchus.util.FastMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class SimpleRegressionTest {
    private double[][] data = new double[][]{{0.1, 0.2}, {338.8, 337.4}, {118.1, 118.2}, {888.0, 884.6}, {9.2, 10.1}, {228.1, 226.5}, {668.5, 666.3}, {998.5, 996.3}, {449.1, 448.6}, {778.9, 777.0}, {559.2, 558.2}, {0.3, 0.4}, {0.1, 0.6}, {778.1, 775.5}, {668.8, 666.9}, {339.3, 338.0}, {448.9, 447.5}, {10.8, 11.6}, {557.7, 556.0}, {228.3, 228.1}, {998.0, 995.8}, {888.8, 887.6}, {119.6, 120.2}, {0.3, 0.3}, {0.6, 0.3}, {557.6, 556.8}, {339.3, 339.1}, {888.0, 887.2}, {998.5, 999.0}, {778.9, 779.0}, {10.2, 11.1}, {117.6, 118.3}, {228.9, 229.2}, {668.4, 669.1}, {449.2, 448.9}, {0.2, 0.5}};
    private double[][] corrData = new double[][]{{101.0, 99.2}, {100.1, 99.0}, {100.0, 100.0}, {90.6, 111.6}, {86.5, 122.2}, {89.7, 117.6}, {90.6, 121.1}, {82.8, 136.0}, {70.1, 154.2}, {65.4, 153.6}, {61.3, 158.5}, {62.5, 140.6}, {63.6, 136.2}, {52.6, 168.0}, {59.7, 154.3}, {59.5, 149.0}, {61.3, 165.5}};
    private double[][] infData = new double[][]{{15.6, 5.2}, {26.8, 6.1}, {37.8, 8.7}, {36.4, 8.5}, {35.5, 8.8}, {18.6, 4.9}, {15.3, 4.5}, {7.9, 2.5}, {0.0, 1.1}};
    private double[][] removeSingle = new double[][]{this.infData[1]};
    private double[][] removeMultiple = new double[][]{this.infData[1], this.infData[2]};
    private double removeX = this.infData[0][0];
    private double removeY = this.infData[0][1];
    private double[][] infData2 = new double[][]{{1.0, 1.0}, {2.0, 0.0}, {3.0, 5.0}, {4.0, 2.0}, {5.0, -1.0}, {6.0, 12.0}};
    private double[][] noint1 = new double[][]{{130.0, 60.0}, {131.0, 61.0}, {132.0, 62.0}, {133.0, 63.0}, {134.0, 64.0}, {135.0, 65.0}, {136.0, 66.0}, {137.0, 67.0}, {138.0, 68.0}, {139.0, 69.0}, {140.0, 70.0}};
    private double[][] noint2 = new double[][]{{3.0, 4.0}, {4.0, 5.0}, {4.0, 6.0}};

    SimpleRegressionTest() {
    }

    @Test
    void testAppend() {
        this.check(false);
        this.check(true);
    }

    private void check(boolean includeIntercept) {
        int sets = 2;
        ISAACRandom rand = new ISAACRandom(10L);
        SimpleRegression whole = new SimpleRegression(includeIntercept);
        SimpleRegression parts = new SimpleRegression(includeIntercept);
        for (int s = 0; s < 2; ++s) {
            double coef = rand.nextDouble();
            SimpleRegression sub = new SimpleRegression(includeIntercept);
            for (int i = 0; i < 5; ++i) {
                double x = rand.nextDouble();
                double y = x * coef + rand.nextDouble();
                sub.addData(x, y);
                whole.addData(x, y);
            }
            parts.append(sub);
            Assertions.assertTrue((boolean)this.equals(parts, whole, 1.0E-6));
        }
    }

    private boolean equals(SimpleRegression model1, SimpleRegression model2, double tol) {
        if (model1.getN() != model2.getN()) {
            return false;
        }
        if (FastMath.abs((double)(model1.getIntercept() - model2.getIntercept())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getInterceptStdErr() - model2.getInterceptStdErr())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getMeanSquareError() - model2.getMeanSquareError())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getR() - model2.getR())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getRegressionSumSquares() - model2.getRegressionSumSquares())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getRSquare() - model2.getRSquare())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSignificance() - model2.getSignificance())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSlope() - model2.getSlope())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSlopeConfidenceInterval() - model2.getSlopeConfidenceInterval())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSlopeStdErr() - model2.getSlopeStdErr())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSumOfCrossProducts() - model2.getSumOfCrossProducts())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getSumSquaredErrors() - model2.getSumSquaredErrors())) > tol) {
            return false;
        }
        if (FastMath.abs((double)(model1.getTotalSumSquares() - model2.getTotalSumSquares())) > tol) {
            return false;
        }
        return !(FastMath.abs((double)(model1.getXSumSquares() - model2.getXSumSquares())) > tol);
    }

    @Test
    void testRegressIfaceMethod() {
        SimpleRegression regression;
        SimpleRegression iface = regression = new SimpleRegression(true);
        SimpleRegression regressionNoint = new SimpleRegression(false);
        SimpleRegression regressionIntOnly = new SimpleRegression(false);
        for (int i = 0; i < this.data.length; ++i) {
            iface.addObservation(new double[]{this.data[i][1]}, this.data[i][0]);
            regressionNoint.addData(this.data[i][1], this.data[i][0]);
            regressionIntOnly.addData(1.0, this.data[i][0]);
        }
        RegressionResults fullReg = iface.regress();
        Assertions.assertNotNull((Object)fullReg);
        Assertions.assertEquals((double)regression.getIntercept(), (double)fullReg.getParameterEstimate(0), (double)1.0E-16, (String)"intercept");
        Assertions.assertEquals((double)regression.getInterceptStdErr(), (double)fullReg.getStdErrorOfEstimate(0), (double)1.0E-16, (String)"intercept std err");
        Assertions.assertEquals((double)regression.getSlope(), (double)fullReg.getParameterEstimate(1), (double)1.0E-16, (String)"slope");
        Assertions.assertEquals((double)regression.getSlopeStdErr(), (double)fullReg.getStdErrorOfEstimate(1), (double)1.0E-16, (String)"slope std err");
        Assertions.assertEquals((long)regression.getN(), (long)fullReg.getN(), (String)"number of observations");
        Assertions.assertEquals((double)regression.getRSquare(), (double)fullReg.getRSquared(), (double)1.0E-16, (String)"r-square");
        Assertions.assertEquals((double)regression.getRegressionSumSquares(), (double)fullReg.getRegressionSumSquares(), (double)1.0E-16, (String)"SSR");
        Assertions.assertEquals((double)regression.getMeanSquareError(), (double)fullReg.getMeanSquareError(), (double)1.0E-16, (String)"MSE");
        Assertions.assertEquals((double)regression.getSumSquaredErrors(), (double)fullReg.getErrorSumSquares(), (double)1.0E-16, (String)"SSE");
        RegressionResults noInt = iface.regress(new int[]{1});
        Assertions.assertNotNull((Object)noInt);
        Assertions.assertEquals((double)regressionNoint.getSlope(), (double)noInt.getParameterEstimate(0), (double)1.0E-12, (String)"slope");
        Assertions.assertEquals((double)regressionNoint.getSlopeStdErr(), (double)noInt.getStdErrorOfEstimate(0), (double)1.0E-16, (String)"slope std err");
        Assertions.assertEquals((long)regressionNoint.getN(), (long)noInt.getN(), (String)"number of observations");
        Assertions.assertEquals((double)regressionNoint.getRSquare(), (double)noInt.getRSquared(), (double)1.0E-16, (String)"r-square");
        Assertions.assertEquals((double)regressionNoint.getRegressionSumSquares(), (double)noInt.getRegressionSumSquares(), (double)1.0E-8, (String)"SSR");
        Assertions.assertEquals((double)regressionNoint.getMeanSquareError(), (double)noInt.getMeanSquareError(), (double)1.0E-16, (String)"MSE");
        Assertions.assertEquals((double)regressionNoint.getSumSquaredErrors(), (double)noInt.getErrorSumSquares(), (double)1.0E-16, (String)"SSE");
        RegressionResults onlyInt = iface.regress(new int[]{0});
        Assertions.assertNotNull((Object)onlyInt);
        Assertions.assertEquals((double)regressionIntOnly.getSlope(), (double)onlyInt.getParameterEstimate(0), (double)1.0E-12, (String)"slope");
        Assertions.assertEquals((double)regressionIntOnly.getSlopeStdErr(), (double)onlyInt.getStdErrorOfEstimate(0), (double)1.0E-12, (String)"slope std err");
        Assertions.assertEquals((long)regressionIntOnly.getN(), (long)onlyInt.getN(), (String)"number of observations");
        Assertions.assertEquals((double)regressionIntOnly.getRSquare(), (double)onlyInt.getRSquared(), (double)1.0E-14, (String)"r-square");
        Assertions.assertEquals((double)regressionIntOnly.getSumSquaredErrors(), (double)onlyInt.getErrorSumSquares(), (double)1.0E-8, (String)"SSE");
        Assertions.assertEquals((double)regressionIntOnly.getRegressionSumSquares(), (double)onlyInt.getRegressionSumSquares(), (double)1.0E-8, (String)"SSR");
        Assertions.assertEquals((double)regressionIntOnly.getMeanSquareError(), (double)onlyInt.getMeanSquareError(), (double)1.0E-8, (String)"MSE");
    }

    @Test
    void testRegressExceptions() {
        SimpleRegression noIntRegression = new SimpleRegression(false);
        noIntRegression.addData(this.noint2[0][1], this.noint2[0][0]);
        noIntRegression.addData(this.noint2[1][1], this.noint2[1][0]);
        noIntRegression.addData(this.noint2[2][1], this.noint2[2][0]);
        try {
            noIntRegression.regress(null);
            Assertions.fail((String)"Expecting MathIllegalArgumentException for null array");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            noIntRegression.regress(new int[0]);
            Assertions.fail((String)"Expecting MathIllegalArgumentException for empty array");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            noIntRegression.regress(new int[]{0, 1});
            Assertions.fail((String)"Expecting MathIllegalArgumentException - too many regressors");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            noIntRegression.regress(new int[]{1});
            Assertions.fail((String)"Expecting MathIllegalArgumentException - invalid regression");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        SimpleRegression regression = new SimpleRegression(true);
        regression.addData(this.noint2[0][1], this.noint2[0][0]);
        regression.addData(this.noint2[1][1], this.noint2[1][0]);
        regression.addData(this.noint2[2][1], this.noint2[2][0]);
        try {
            regression.regress(null);
            Assertions.fail((String)"Expecting MathIllegalArgumentException for null array");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            regression.regress(new int[0]);
            Assertions.fail((String)"Expecting MathIllegalArgumentException for empty array");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{0, 1, 2});
            Assertions.fail((String)"Expecting MathIllegalArgumentException - too many regressors");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{1, 0});
            Assertions.fail((String)"Expecting MathIllegalArgumentException - invalid regression");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{3, 4});
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{0, 2});
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            regression.regress(new int[]{2});
            Assertions.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testNoInterceot_noint2() {
        SimpleRegression regression = new SimpleRegression(false);
        regression.addData(this.noint2[0][1], this.noint2[0][0]);
        regression.addData(this.noint2[1][1], this.noint2[1][0]);
        regression.addData(this.noint2[2][1], this.noint2[2][0]);
        Assertions.assertEquals((double)0.0, (double)regression.getIntercept(), (double)0.0, (String)"intercept");
        Assertions.assertEquals((double)0.727272727272727, (double)regression.getSlope(), (double)1.0E-11, (String)"slope");
        Assertions.assertEquals((double)0.0420827318078432, (double)regression.getSlopeStdErr(), (double)1.0E-11, (String)"slope std err");
        Assertions.assertEquals((long)3L, (long)regression.getN(), (String)"number of observations");
        Assertions.assertEquals((double)0.993348115299335, (double)regression.getRSquare(), (double)1.0E-11, (String)"r-square");
        Assertions.assertEquals((double)40.7272727272727, (double)regression.getRegressionSumSquares(), (double)1.0E-8, (String)"SSR");
        Assertions.assertEquals((double)0.136363636363636, (double)regression.getMeanSquareError(), (double)1.0E-9, (String)"MSE");
        Assertions.assertEquals((double)0.272727272727273, (double)regression.getSumSquaredErrors(), (double)1.0E-8, (String)"SSE");
    }

    @Test
    void testNoIntercept_noint1() {
        SimpleRegression regression = new SimpleRegression(false);
        for (int i = 0; i < this.noint1.length; ++i) {
            regression.addData(this.noint1[i][1], this.noint1[i][0]);
        }
        Assertions.assertEquals((double)0.0, (double)regression.getIntercept(), (double)0.0, (String)"intercept");
        Assertions.assertEquals((double)2.07438016528926, (double)regression.getSlope(), (double)1.0E-11, (String)"slope");
        Assertions.assertEquals((double)0.0165289256198347, (double)regression.getSlopeStdErr(), (double)1.0E-11, (String)"slope std err");
        Assertions.assertEquals((long)11L, (long)regression.getN(), (String)"number of observations");
        Assertions.assertEquals((double)0.999365492298663, (double)regression.getRSquare(), (double)1.0E-11, (String)"r-square");
        Assertions.assertEquals((double)200457.727272727, (double)regression.getRegressionSumSquares(), (double)1.0E-8, (String)"SSR");
        Assertions.assertEquals((double)12.7272727272727, (double)regression.getMeanSquareError(), (double)1.0E-9, (String)"MSE");
        Assertions.assertEquals((double)127.272727272727, (double)regression.getSumSquaredErrors(), (double)1.0E-8, (String)"SSE");
    }

    @Test
    void testNorris() {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < this.data.length; ++i) {
            regression.addData(this.data[i][1], this.data[i][0]);
        }
        Assertions.assertEquals((double)1.00211681802045, (double)regression.getSlope(), (double)1.0E-11, (String)"slope");
        Assertions.assertEquals((double)4.29796848199937E-4, (double)regression.getSlopeStdErr(), (double)1.0E-11, (String)"slope std err");
        Assertions.assertEquals((long)36L, (long)regression.getN(), (String)"number of observations");
        Assertions.assertEquals((double)-0.262323073774029, (double)regression.getIntercept(), (double)1.0E-11, (String)"intercept");
        Assertions.assertEquals((double)0.232818234301152, (double)regression.getInterceptStdErr(), (double)1.0E-11, (String)"std err intercept");
        Assertions.assertEquals((double)0.999993745883712, (double)regression.getRSquare(), (double)1.0E-11, (String)"r-square");
        Assertions.assertEquals((double)4255954.13232369, (double)regression.getRegressionSumSquares(), (double)1.0E-8, (String)"SSR");
        Assertions.assertEquals((double)0.782864662630069, (double)regression.getMeanSquareError(), (double)1.0E-9, (String)"MSE");
        Assertions.assertEquals((double)26.6173985294224, (double)regression.getSumSquaredErrors(), (double)1.0E-8, (String)"SSE");
        Assertions.assertEquals((double)-0.262323073774029, (double)regression.predict(0.0), (double)1.0E-11, (String)"predict(0)");
        Assertions.assertEquals((double)0.7397937442464211, (double)regression.predict(1.0), (double)1.0E-11, (String)"predict(1)");
    }

    @Test
    void testCorr() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.corrData);
        Assertions.assertEquals((long)17L, (long)regression.getN(), (String)"number of observations");
        Assertions.assertEquals((double)0.896123, (double)regression.getRSquare(), (double)1.0E-5, (String)"r-square");
        Assertions.assertEquals((double)-0.94663767742, (double)regression.getR(), (double)1.0E-10, (String)"r");
    }

    @Test
    void testNaNs() {
        SimpleRegression regression = new SimpleRegression();
        Assertions.assertTrue((boolean)Double.isNaN(regression.getIntercept()), (String)"intercept not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getSlope()), (String)"slope not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getSlopeStdErr()), (String)"slope std err not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getInterceptStdErr()), (String)"intercept std err not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getMeanSquareError()), (String)"MSE not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getR()), (String)"e not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getRSquare()), (String)"r-square not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getRegressionSumSquares()), (String)"RSS not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getSumSquaredErrors()), (String)"SSE not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getTotalSumSquares()), (String)"SSTO not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.predict(0.0)), (String)"predict not NaN");
        regression.addData(1.0, 2.0);
        regression.addData(1.0, 3.0);
        Assertions.assertTrue((boolean)Double.isNaN(regression.getIntercept()), (String)"intercept not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getSlope()), (String)"slope not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getSlopeStdErr()), (String)"slope std err not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getInterceptStdErr()), (String)"intercept std err not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getMeanSquareError()), (String)"MSE not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getR()), (String)"e not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getRSquare()), (String)"r-square not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getRegressionSumSquares()), (String)"RSS not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getSumSquaredErrors()), (String)"SSE not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.predict(0.0)), (String)"predict not NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getTotalSumSquares()), (String)"SSTO NaN");
        regression = new SimpleRegression();
        regression.addData(1.0, 2.0);
        regression.addData(3.0, 3.0);
        Assertions.assertFalse((boolean)Double.isNaN(regression.getIntercept()), (String)"interceptNaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getSlope()), (String)"slope NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getSlopeStdErr()), (String)"slope std err not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getInterceptStdErr()), (String)"intercept std err not NaN");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getMeanSquareError()), (String)"MSE not NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getR()), (String)"r NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getRSquare()), (String)"r-square NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getRegressionSumSquares()), (String)"RSS NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getSumSquaredErrors()), (String)"SSE NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getTotalSumSquares()), (String)"SSTO NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.predict(0.0)), (String)"predict NaN");
        regression.addData(1.0, 4.0);
        Assertions.assertFalse((boolean)Double.isNaN(regression.getMeanSquareError()), (String)"MSE NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getSlopeStdErr()), (String)"slope std err NaN");
        Assertions.assertFalse((boolean)Double.isNaN(regression.getInterceptStdErr()), (String)"intercept std err NaN");
    }

    @Test
    void testClear() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.corrData);
        Assertions.assertEquals((long)17L, (long)regression.getN(), (String)"number of observations");
        regression.clear();
        Assertions.assertEquals((long)0L, (long)regression.getN(), (String)"number of observations");
        regression.addData(this.corrData);
        Assertions.assertEquals((double)0.896123, (double)regression.getRSquare(), (double)1.0E-5, (String)"r-square");
        regression.addData(this.data);
        Assertions.assertEquals((long)53L, (long)regression.getN(), (String)"number of observations");
    }

    @Test
    void testInference() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.infData);
        Assertions.assertEquals((double)0.011448491, (double)regression.getSlopeStdErr(), (double)1.0E-10, (String)"slope std err");
        Assertions.assertEquals((double)0.286036932, (double)regression.getInterceptStdErr(), (double)1.0E-8, (String)"std err intercept");
        Assertions.assertEquals((double)4.596E-7, (double)regression.getSignificance(), (double)1.0E-8, (String)"significance");
        Assertions.assertEquals((double)0.0270713794287, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8, (String)"slope conf interval half-width");
        regression = new SimpleRegression();
        regression.addData(this.infData2);
        Assertions.assertEquals((double)1.07260253, (double)regression.getSlopeStdErr(), (double)1.0E-8, (String)"slope std err");
        Assertions.assertEquals((double)4.17718672, (double)regression.getInterceptStdErr(), (double)1.0E-8, (String)"std err intercept");
        Assertions.assertEquals((double)0.261829133982, (double)regression.getSignificance(), (double)1.0E-11, (String)"significance");
        Assertions.assertEquals((double)2.97802204827, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8, (String)"slope conf interval half-width");
        Assertions.assertTrue((regression.getSlopeConfidenceInterval() < regression.getSlopeConfidenceInterval(0.01) ? 1 : 0) != 0, (String)"tighter means wider");
        try {
            regression.getSlopeConfidenceInterval(1.0);
            Assertions.fail((String)"expecting MathIllegalArgumentException for alpha = 1");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testPerfect() {
        SimpleRegression regression = new SimpleRegression();
        int n = 100;
        for (int i = 0; i < n; ++i) {
            regression.addData((double)i / (double)(n - 1), (double)i);
        }
        Assertions.assertEquals((double)0.0, (double)regression.getSignificance(), (double)1.0E-5);
        Assertions.assertTrue((regression.getSlope() > 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((regression.getSumSquaredErrors() >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    void testPerfect2() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(0.0, 0.0);
        regression.addData(1.0, 1.0);
        regression.addData(2.0, 2.0);
        Assertions.assertEquals((double)0.0, (double)regression.getSlopeStdErr(), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)regression.getSignificance(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)1.0, (double)regression.getRSquare(), (double)Double.MIN_VALUE);
    }

    @Test
    void testPerfectNegative() {
        SimpleRegression regression = new SimpleRegression();
        int n = 100;
        for (int i = 0; i < n; ++i) {
            regression.addData(-((double)i) / (double)(n - 1), (double)i);
        }
        Assertions.assertEquals((double)0.0, (double)regression.getSignificance(), (double)1.0E-5);
        Assertions.assertTrue((regression.getSlope() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    void testRandom() {
        SimpleRegression regression = new SimpleRegression();
        Random random = new Random(1L);
        int n = 100;
        for (int i = 0; i < n; ++i) {
            regression.addData((double)i / (double)(n - 1), random.nextDouble());
        }
        Assertions.assertTrue((0.0 < regression.getSignificance() && regression.getSignificance() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    void testSSENonNegative() {
        double[] y = new double[]{8915.102, 8919.302, 8923.502};
        double[] x = new double[]{110.7178495, 110.7264895, 110.7351295};
        SimpleRegression reg = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            reg.addData(x[i], y[i]);
        }
        Assertions.assertTrue((reg.getSumSquaredErrors() >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    void testRemoveXY() {
        SimpleRegression regression = new SimpleRegression();
        Assertions.assertTrue((boolean)regression.hasIntercept());
        regression.addData(this.infData);
        regression.removeData(this.removeX, this.removeY);
        regression.addData(this.removeX, this.removeY);
        Assertions.assertEquals((double)0.011448491, (double)regression.getSlopeStdErr(), (double)1.0E-10, (String)"slope std err");
        Assertions.assertEquals((double)0.286036932, (double)regression.getInterceptStdErr(), (double)1.0E-8, (String)"std err intercept");
        Assertions.assertEquals((double)4.596E-7, (double)regression.getSignificance(), (double)1.0E-8, (String)"significance");
        Assertions.assertEquals((double)0.0270713794287, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8, (String)"slope conf interval half-width");
    }

    @Test
    void testRemoveSingle() {
        SimpleRegression regression = new SimpleRegression();
        Assertions.assertTrue((boolean)regression.hasIntercept());
        regression.addData(this.infData);
        regression.removeData(this.removeSingle);
        regression.addData(this.removeSingle);
        Assertions.assertEquals((double)0.011448491, (double)regression.getSlopeStdErr(), (double)1.0E-10, (String)"slope std err");
        Assertions.assertEquals((double)0.286036932, (double)regression.getInterceptStdErr(), (double)1.0E-8, (String)"std err intercept");
        Assertions.assertEquals((double)4.596E-7, (double)regression.getSignificance(), (double)1.0E-8, (String)"significance");
        Assertions.assertEquals((double)0.0270713794287, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8, (String)"slope conf interval half-width");
    }

    @Test
    void testRemoveMultiple() {
        SimpleRegression regression = new SimpleRegression();
        Assertions.assertTrue((boolean)regression.hasIntercept());
        regression.addData(this.infData);
        regression.removeData(this.removeMultiple);
        regression.addData(this.removeMultiple);
        Assertions.assertEquals((double)0.011448491, (double)regression.getSlopeStdErr(), (double)1.0E-10, (String)"slope std err");
        Assertions.assertEquals((double)0.286036932, (double)regression.getInterceptStdErr(), (double)1.0E-8, (String)"std err intercept");
        Assertions.assertEquals((double)4.596E-7, (double)regression.getSignificance(), (double)1.0E-8, (String)"significance");
        Assertions.assertEquals((double)0.0270713794287, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8, (String)"slope conf interval half-width");
    }

    @Test
    void testRemoveMultipleNoIntercept() {
        SimpleRegression regression = new SimpleRegression(false);
        Assertions.assertFalse((boolean)regression.hasIntercept());
        Assertions.assertEquals((double)0.0, (double)regression.getIntercept(), (double)1.0E-15);
        regression.addData(this.infData);
        Assertions.assertEquals((double)0.30593, (double)regression.predict(1.25), (double)1.0E-5);
        regression.removeData(this.removeMultiple);
        regression.addData(this.removeMultiple);
        Assertions.assertEquals((double)0.0103629732, (double)regression.getSlopeStdErr(), (double)1.0E-10, (String)"slope std err");
        Assertions.assertTrue((boolean)Double.isNaN(regression.getInterceptStdErr()), (String)"std err intercept");
        Assertions.assertEquals((double)6.199E-8, (double)regression.getSignificance(), (double)1.0E-10, (String)"significance");
        Assertions.assertEquals((double)0.02450454, (double)regression.getSlopeConfidenceInterval(), (double)1.0E-8, (String)"slope conf interval half-width");
    }

    @Test
    void testRemoveObsFromEmpty() {
        SimpleRegression regression = new SimpleRegression();
        regression.removeData(this.removeX, this.removeY);
        Assertions.assertEquals((long)0L, (long)regression.getN());
    }

    @Test
    void testRemoveObsFromSingle() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.removeX, this.removeY);
        regression.removeData(this.removeX, this.removeY);
        Assertions.assertEquals((long)0L, (long)regression.getN());
    }

    @Test
    void testRemoveMultipleToEmpty() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.removeMultiple);
        regression.removeData(this.removeMultiple);
        Assertions.assertEquals((long)0L, (long)regression.getN());
    }

    @Test
    void testRemoveMultiplePastEmpty() {
        SimpleRegression regression = new SimpleRegression();
        regression.addData(this.removeX, this.removeY);
        regression.removeData(this.removeMultiple);
        Assertions.assertEquals((long)0L, (long)regression.getN());
    }

    @Test
    void testWrongDimensions() {
        try {
            new SimpleRegression().addData(new double[1][1]);
            Assertions.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assertions.assertEquals((Object)LocalizedStatFormats.INVALID_REGRESSION_OBSERVATION, (Object)miae.getSpecifier());
        }
        try {
            new SimpleRegression().addObservation(null, 0.0);
            Assertions.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assertions.assertEquals((Object)LocalizedStatFormats.INVALID_REGRESSION_OBSERVATION, (Object)miae.getSpecifier());
        }
        try {
            new SimpleRegression().addObservation(new double[0], 0.0);
            Assertions.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assertions.assertEquals((Object)LocalizedStatFormats.INVALID_REGRESSION_OBSERVATION, (Object)miae.getSpecifier());
        }
        try {
            new SimpleRegression().addObservations((double[][])new double[][]{null, null}, new double[2]);
            Assertions.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assertions.assertEquals((Object)LocalizedStatFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, (Object)miae.getSpecifier());
        }
        try {
            new SimpleRegression().addObservations((double[][])new double[][]{new double[0], new double[0]}, new double[2]);
            Assertions.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assertions.assertEquals((Object)LocalizedStatFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, (Object)miae.getSpecifier());
        }
    }

    @Test
    void testFewPoints() {
        SimpleRegression sr = new SimpleRegression();
        sr.addObservations((double[][])new double[][]{{1.0, 1.5}}, new double[]{1.0});
        Assertions.assertEquals((long)1L, (long)sr.getN());
        Assertions.assertTrue((boolean)Double.isNaN(sr.getXSumSquares()));
        sr.addObservations((double[][])new double[][]{{1.0, 1.5}}, new double[]{1.0});
        Assertions.assertEquals((long)2L, (long)sr.getN());
        Assertions.assertFalse((boolean)Double.isNaN(sr.getXSumSquares()));
        Assertions.assertTrue((boolean)Double.isNaN(sr.getSlopeConfidenceInterval()));
        Assertions.assertTrue((boolean)Double.isNaN(sr.getSignificance()));
        try {
            sr.regress();
            Assertions.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assertions.assertEquals((Object)LocalizedStatFormats.NOT_ENOUGH_DATA_REGRESSION, (Object)miae.getSpecifier());
        }
        sr.addObservations((double[][])new double[][]{{1.0, 1.5}}, new double[]{1.0});
        RegressionResults results = sr.regress();
        Assertions.assertTrue((boolean)Double.isNaN(results.getParameterEstimate(1)));
        results = sr.regress(new int[]{1});
        Assertions.assertEquals((double)1.0, (double)results.getParameterEstimate(0), (double)1.0E-15);
        sr.addObservations((double[][])new double[][]{{2.0, 2.5}}, new double[]{2.0});
        results = sr.regress();
        Assertions.assertFalse((boolean)Double.isNaN(results.getParameterEstimate(1)));
        sr.addObservations((double[][])new double[][]{{Double.NaN, Double.NaN}}, new double[]{Double.NaN});
        results = sr.regress(new int[]{1});
        Assertions.assertTrue((boolean)Double.isNaN(results.getParameterEstimate(0)));
    }

    @Test
    void testFewPointsWithoutIntercept() {
        SimpleRegression sr = new SimpleRegression(false);
        sr.addObservations((double[][])new double[][]{{1.0, 1.5}}, new double[]{1.0});
        Assertions.assertEquals((long)1L, (long)sr.getN());
        Assertions.assertTrue((boolean)Double.isNaN(sr.getXSumSquares()));
        try {
            sr.regress();
            Assertions.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assertions.assertEquals((Object)LocalizedStatFormats.NOT_ENOUGH_DATA_REGRESSION, (Object)miae.getSpecifier());
        }
        sr.addObservations((double[][])new double[][]{{1.0, 1.5}}, new double[]{1.0});
        RegressionResults results = sr.regress();
        Assertions.assertFalse((boolean)Double.isNaN(results.getParameterEstimate(0)));
        sr.addObservations((double[][])new double[][]{{Double.NaN, 1.0}}, new double[]{2.0});
        results = sr.regress();
        Assertions.assertTrue((boolean)Double.isNaN(results.getParameterEstimate(0)));
    }
}

