/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashSet;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.fraction.BigFractionField;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.stat.LocalizedStatFormats;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class KolmogorovSmirnovTest {
    protected static final int MAXIMUM_PARTIAL_SUM_COUNT = 100000;
    protected static final double KS_SUM_CAUCHY_CRITERION = 1.0E-20;
    protected static final double PG_SUM_RELATIVE_ERROR = 1.0E-10;
    protected static final int LARGE_SAMPLE_PRODUCT = 10000;
    private final RandomDataGenerator gen = new RandomDataGenerator();

    public KolmogorovSmirnovTest() {
    }

    public KolmogorovSmirnovTest(long seed) {
        this.gen.setSeed(seed);
    }

    public double kolmogorovSmirnovTest(RealDistribution distribution, double[] data, boolean exact) {
        return 1.0 - this.cdf(this.kolmogorovSmirnovStatistic(distribution, data), data.length, exact);
    }

    public double kolmogorovSmirnovStatistic(RealDistribution distribution, double[] data) {
        this.checkArray(data);
        int n = data.length;
        double nd = n;
        double[] dataCopy = new double[n];
        System.arraycopy(data, 0, dataCopy, 0, n);
        Arrays.sort(dataCopy);
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            double yi = distribution.cumulativeProbability(dataCopy[i - 1]);
            double currD = FastMath.max((double)(yi - (double)(i - 1) / nd), (double)((double)i / nd - yi));
            if (!(currD > d)) continue;
            d = currD;
        }
        return d;
    }

    public double kolmogorovSmirnovTest(double[] x, double[] y, boolean strict) {
        double[] ya;
        double[] xa;
        long lengthProduct = (long)x.length * (long)y.length;
        if (lengthProduct < 10000L && KolmogorovSmirnovTest.hasTies(x, y)) {
            xa = (double[])x.clone();
            ya = (double[])y.clone();
            this.fixTies(xa, ya);
        } else {
            xa = x;
            ya = y;
        }
        if (lengthProduct < 10000L) {
            return this.exactP(this.kolmogorovSmirnovStatistic(xa, ya), x.length, y.length, strict);
        }
        return this.approximateP(this.kolmogorovSmirnovStatistic(x, y), x.length, y.length);
    }

    public double kolmogorovSmirnovTest(double[] x, double[] y) {
        return this.kolmogorovSmirnovTest(x, y, true);
    }

    public double kolmogorovSmirnovStatistic(double[] x, double[] y) {
        return (double)this.integralKolmogorovSmirnovStatistic(x, y) / (double)((long)x.length * (long)y.length);
    }

    private long integralKolmogorovSmirnovStatistic(double[] x, double[] y) {
        this.checkArray(x);
        this.checkArray(y);
        double[] sx = (double[])x.clone();
        double[] sy = (double[])y.clone();
        Arrays.sort(sx);
        Arrays.sort(sy);
        int n = sx.length;
        int m = sy.length;
        int rankX = 0;
        int rankY = 0;
        long curD = 0L;
        long supD = 0L;
        do {
            double z;
            double d = z = Double.compare(sx[rankX], sy[rankY]) <= 0 ? sx[rankX] : sy[rankY];
            while (rankX < n && Double.compare(sx[rankX], z) == 0) {
                ++rankX;
                curD += (long)m;
            }
            while (rankY < m && Double.compare(sy[rankY], z) == 0) {
                ++rankY;
                curD -= (long)n;
            }
            if (curD > supD) {
                supD = curD;
                continue;
            }
            if (-curD <= supD) continue;
            supD = -curD;
        } while (rankX < n && rankY < m);
        return supD;
    }

    public double kolmogorovSmirnovTest(RealDistribution distribution, double[] data) {
        return this.kolmogorovSmirnovTest(distribution, data, false);
    }

    public boolean kolmogorovSmirnovTest(RealDistribution distribution, double[] data, double alpha) {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new MathIllegalArgumentException((Localizable)LocalizedStatFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, new Object[]{alpha, 0, 0.5});
        }
        return this.kolmogorovSmirnovTest(distribution, data) < alpha;
    }

    public double bootstrap(double[] x, double[] y, int iterations, boolean strict) {
        int xLength = x.length;
        int yLength = y.length;
        double[] combined = new double[xLength + yLength];
        System.arraycopy(x, 0, combined, 0, xLength);
        System.arraycopy(y, 0, combined, xLength, yLength);
        long d = this.integralKolmogorovSmirnovStatistic(x, y);
        int greaterCount = 0;
        int equalCount = 0;
        for (int i = 0; i < iterations; ++i) {
            double[] curY;
            double[] curX = this.resample(combined, xLength);
            long curD = this.integralKolmogorovSmirnovStatistic(curX, curY = this.resample(combined, yLength));
            if (curD > d) {
                ++greaterCount;
                continue;
            }
            if (curD != d) continue;
            ++equalCount;
        }
        return strict ? (double)greaterCount / (double)iterations : (double)(greaterCount + equalCount) / (double)iterations;
    }

    public double bootstrap(double[] x, double[] y, int iterations) {
        return this.bootstrap(x, y, iterations, true);
    }

    private double[] resample(double[] sample, int k) {
        int len = sample.length;
        double[] out = new double[k];
        for (int i = 0; i < k; ++i) {
            out[i] = this.gen.nextInt(len);
        }
        return out;
    }

    public double cdf(double d, int n) throws MathRuntimeException {
        return this.cdf(d, n, false);
    }

    public double cdfExact(double d, int n) throws MathRuntimeException {
        return this.cdf(d, n, true);
    }

    public double cdf(double d, int n, boolean exact) throws MathRuntimeException {
        double ninv = 1.0 / (double)n;
        double ninvhalf = 0.5 * ninv;
        if (d <= ninvhalf) {
            return 0.0;
        }
        if (ninvhalf < d && d <= ninv) {
            double res = 1.0;
            double f = 2.0 * d - ninv;
            for (int i = 1; i <= n; ++i) {
                res *= (double)i * f;
            }
            return res;
        }
        if (1.0 - ninv <= d && d < 1.0) {
            return 1.0 - 2.0 * Math.pow(1.0 - d, n);
        }
        if (1.0 <= d) {
            return 1.0;
        }
        if (exact) {
            return this.exactK(d, n);
        }
        if (n <= 140) {
            return this.roundedK(d, n);
        }
        return this.pelzGood(d, n);
    }

    private double exactK(double d, int n) throws MathRuntimeException {
        int k = (int)Math.ceil((double)n * d);
        FieldMatrix<BigFraction> H = this.createExactH(d, n);
        FieldMatrix Hpower = H.power(n);
        BigFraction pFrac = (BigFraction)Hpower.getEntry(k - 1, k - 1);
        for (int i = 1; i <= n; ++i) {
            pFrac = pFrac.multiply(i).divide(n);
        }
        return pFrac.bigDecimalValue(20, RoundingMode.HALF_UP).doubleValue();
    }

    private double roundedK(double d, int n) {
        int k = (int)Math.ceil((double)n * d);
        RealMatrix H = this.createRoundedH(d, n);
        RealMatrix Hpower = H.power(n);
        double pFrac = Hpower.getEntry(k - 1, k - 1);
        for (int i = 1; i <= n; ++i) {
            pFrac *= (double)i / (double)n;
        }
        return pFrac;
    }

    public double pelzGood(double d, int n) {
        double increment;
        double kTerm2;
        double kTerm;
        double increment2;
        int k;
        double sqrtN = FastMath.sqrt((double)n);
        double z = d * sqrtN;
        double z2 = d * d * (double)n;
        double z4 = z2 * z2;
        double z6 = z4 * z2;
        double z8 = z4 * z4;
        double sum = 0.0;
        double z2Term = Math.PI * Math.PI / (8.0 * z2);
        for (k = 1; k < 100000 && !((increment2 = FastMath.exp((double)(-z2Term * (kTerm = (double)(2 * k - 1)) * kTerm))) <= 1.0E-10 * (sum += increment2)); ++k) {
        }
        if (k == 100000) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.MAX_COUNT_EXCEEDED, new Object[]{100000});
        }
        double ret = sum * FastMath.sqrt((double)(Math.PI * 2)) / z;
        double twoZ2 = 2.0 * z2;
        sum = 0.0;
        for (k = 0; k < 100000; ++k) {
            double kTerm3 = (double)k + 0.5;
            double kTerm22 = kTerm3 * kTerm3;
            double increment3 = (Math.PI * Math.PI * kTerm22 - z2) * FastMath.exp((double)(-9.869604401089358 * kTerm22 / twoZ2));
            if (FastMath.abs((double)increment3) < 1.0E-10 * FastMath.abs((double)(sum += increment3))) break;
        }
        if (k == 100000) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.MAX_COUNT_EXCEEDED, new Object[]{100000});
        }
        double sqrtHalfPi = FastMath.sqrt((double)1.5707963267948966);
        ret += sum * sqrtHalfPi / (3.0 * z4 * sqrtN);
        double z4Term = 2.0 * z4;
        double z6Term = 6.0 * z6;
        z2Term = 5.0 * z2;
        double pi4 = 97.40909103400243;
        sum = 0.0;
        for (k = 0; k < 100000; ++k) {
            double kTerm4 = (double)k + 0.5;
            kTerm2 = kTerm4 * kTerm4;
            increment = (z6Term + z4Term + Math.PI * Math.PI * (z4Term - z2Term) * kTerm2 + 97.40909103400243 * (1.0 - twoZ2) * kTerm2 * kTerm2) * FastMath.exp((double)(-9.869604401089358 * kTerm2 / twoZ2));
            if (FastMath.abs((double)increment) < 1.0E-10 * FastMath.abs((double)(sum += increment))) break;
        }
        if (k == 100000) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.MAX_COUNT_EXCEEDED, new Object[]{100000});
        }
        double sum2 = 0.0;
        for (k = 1; k < 100000; ++k) {
            kTerm2 = k * k;
            increment = Math.PI * Math.PI * kTerm2 * FastMath.exp((double)(-9.869604401089358 * kTerm2 / twoZ2));
            if (FastMath.abs((double)increment) < 1.0E-10 * FastMath.abs((double)(sum2 += increment))) break;
        }
        if (k == 100000) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.MAX_COUNT_EXCEEDED, new Object[]{100000});
        }
        ret += sqrtHalfPi / (double)n * (sum / (36.0 * z2 * z2 * z2 * z) - sum2 / (18.0 * z2 * z));
        double pi6 = 961.3891935753043;
        sum = 0.0;
        for (k = 0; k < 100000; ++k) {
            double kTerm5 = (double)k + 0.5;
            double kTerm23 = kTerm5 * kTerm5;
            double kTerm4 = kTerm23 * kTerm23;
            double kTerm6 = kTerm4 * kTerm23;
            double increment4 = (961.3891935753043 * kTerm6 * (5.0 - 30.0 * z2) + 97.40909103400243 * kTerm4 * (-60.0 * z2 + 212.0 * z4) + Math.PI * Math.PI * kTerm23 * (135.0 * z4 - 96.0 * z6) - 30.0 * z6 - 90.0 * z8) * FastMath.exp((double)(-9.869604401089358 * kTerm23 / twoZ2));
            if (FastMath.abs((double)increment4) < 1.0E-10 * FastMath.abs((double)(sum += increment4))) break;
        }
        if (k == 100000) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.MAX_COUNT_EXCEEDED, new Object[]{100000});
        }
        sum2 = 0.0;
        for (k = 1; k < 100000; ++k) {
            double kTerm24 = k * k;
            double kTerm4 = kTerm24 * kTerm24;
            double increment5 = (-97.40909103400243 * kTerm4 + 29.608813203268074 * kTerm24 * z2) * FastMath.exp((double)(-9.869604401089358 * kTerm24 / twoZ2));
            if (FastMath.abs((double)increment5) < 1.0E-10 * FastMath.abs((double)(sum2 += increment5))) break;
        }
        if (k == 100000) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.MAX_COUNT_EXCEEDED, new Object[]{100000});
        }
        return ret + sqrtHalfPi / (sqrtN * (double)n) * (sum / (3240.0 * z6 * z4) + sum2 / (108.0 * z6));
    }

    private FieldMatrix<BigFraction> createExactH(double d, int n) throws MathIllegalArgumentException, MathIllegalStateException {
        int i;
        BigFraction h;
        int k = (int)Math.ceil((double)n * d);
        int m = 2 * k - 1;
        double hDouble = (double)k - (double)n * d;
        if (hDouble >= 1.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, new Object[]{hDouble, 1.0});
        }
        try {
            h = new BigFraction(hDouble, 1.0E-20, 10000);
        }
        catch (MathIllegalStateException e1) {
            try {
                h = new BigFraction(hDouble, 1.0E-10, 10000);
            }
            catch (MathIllegalStateException e2) {
                h = new BigFraction(hDouble, 1.0E-5, 10000);
            }
        }
        BigFraction[][] Hdata = new BigFraction[m][m];
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < m; ++j) {
                Hdata[i2][j] = i2 - j + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] hPowers = new BigFraction[m];
        hPowers[0] = h;
        for (i = 1; i < m; ++i) {
            hPowers[i] = h.multiply(hPowers[i - 1]);
        }
        for (i = 0; i < m; ++i) {
            Hdata[i][0] = Hdata[i][0].subtract(hPowers[i]);
            Hdata[m - 1][i] = Hdata[m - 1][i].subtract(hPowers[m - i - 1]);
        }
        if (h.compareTo(BigFraction.ONE_HALF) == 1) {
            Hdata[m - 1][0] = Hdata[m - 1][0].add(h.multiply(2).subtract(1).pow(m));
        }
        for (i = 0; i < m; ++i) {
            for (int j = 0; j < i + 1; ++j) {
                if (i - j + 1 <= 0) continue;
                for (int g = 2; g <= i - j + 1; ++g) {
                    Hdata[i][j] = Hdata[i][j].divide(g);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), (FieldElement[][])Hdata);
    }

    private RealMatrix createRoundedH(double d, int n) throws MathIllegalArgumentException {
        int i;
        int k = (int)Math.ceil((double)n * d);
        int m = 2 * k - 1;
        double h = (double)k - (double)n * d;
        if (h >= 1.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, new Object[]{h, 1.0});
        }
        double[][] Hdata = new double[m][m];
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < m; ++j) {
                Hdata[i2][j] = i2 - j + 1 < 0 ? 0.0 : 1.0;
            }
        }
        double[] hPowers = new double[m];
        hPowers[0] = h;
        for (i = 1; i < m; ++i) {
            hPowers[i] = h * hPowers[i - 1];
        }
        for (i = 0; i < m; ++i) {
            Hdata[i][0] = Hdata[i][0] - hPowers[i];
            double[] dArray = Hdata[m - 1];
            int n2 = i;
            dArray[n2] = dArray[n2] - hPowers[m - i - 1];
        }
        if (Double.compare(h, 0.5) > 0) {
            double[] dArray = Hdata[m - 1];
            dArray[0] = dArray[0] + FastMath.pow((double)(2.0 * h - 1.0), (int)m);
        }
        for (i = 0; i < m; ++i) {
            for (int j = 0; j < i + 1; ++j) {
                if (i - j + 1 <= 0) continue;
                for (int g = 2; g <= i - j + 1; ++g) {
                    double[] dArray = Hdata[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] / (double)g;
                }
            }
        }
        return MatrixUtils.createRealMatrix((double[][])Hdata);
    }

    private void checkArray(double[] array) {
        MathUtils.checkNotNull((Object)array);
        if (array.length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, new Object[]{array.length, 2});
        }
    }

    public double ksSum(double t, double tolerance, int maxIterations) {
        long i;
        if (t == 0.0) {
            return 0.0;
        }
        double x = -2.0 * t * t;
        int sign = -1;
        double partialSum = 0.5;
        double delta = 1.0;
        for (i = 1L; delta > tolerance && i < (long)maxIterations; ++i) {
            delta = FastMath.exp((double)(x * (double)i * (double)i));
            partialSum += (double)sign * delta;
            sign *= -1;
        }
        if (i == (long)maxIterations) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.MAX_COUNT_EXCEEDED, new Object[]{maxIterations});
        }
        return partialSum * 2.0;
    }

    public double exactP(double d, int n, int m, boolean strict) {
        if (d < 1.0 / (double)(m * n)) {
            return 1.0;
        }
        if (d >= 1.0) {
            return 0.0;
        }
        double normalizeD = this.normalizeD(d, n, m);
        if (!strict) {
            normalizeD -= 1.0 / ((double)n * (double)m);
        }
        return this.exactPAtMeshpoint(normalizeD, n, m);
    }

    private double normalizeD(double d, int n, int m) {
        double resolution = 1.0 / ((double)n * (double)m);
        double tol = 1.0E-12;
        if (d < resolution) {
            return 0.0;
        }
        if (d > 1.0) {
            return 1.0;
        }
        double resolutions = d / resolution;
        double ceil = FastMath.ceil((double)resolutions);
        if (ceil - resolutions < 1.0E-12) {
            return ceil * resolution;
        }
        return FastMath.floor((double)resolutions) * resolution;
    }

    private double exactPAtMeshpoint(double d, int n, int m) {
        int nn = FastMath.max((int)n, (int)m);
        int mm = FastMath.min((int)n, (int)m);
        double[] u = new double[nn + 2];
        double k = (double)(mm * nn) * d + 0.5;
        u[1] = 1.0;
        for (int j = 1; j < nn + 1; ++j) {
            u[j + 1] = 1.0;
            if (!((double)(mm * j) > k)) continue;
            u[j + 1] = 0.0;
        }
        for (int i = 1; i < mm + 1; ++i) {
            double w = (double)i / (double)(i + nn);
            u[1] = w * u[1];
            if ((double)(nn * i) > k) {
                u[1] = 0.0;
            }
            for (int j = 1; j < nn + 1; ++j) {
                u[j + 1] = u[j] + u[j + 1] * w;
                if (!((double)FastMath.abs((int)(nn * i - mm * j)) > k)) continue;
                u[j + 1] = 0.0;
            }
        }
        return 1.0 - u[nn + 1];
    }

    public double approximateP(double d, int n, int m) {
        double dm = m;
        double dn = n;
        return 1.0 - this.ksSum(d * FastMath.sqrt((double)(dm * dn / (dm + dn))), 1.0E-20, 100000);
    }

    static void fillBooleanArrayRandomlyWithFixedNumberTrueValues(boolean[] b, int numberOfTrueValues, RandomGenerator rng) {
        Arrays.fill(b, true);
        for (int k = numberOfTrueValues; k < b.length; ++k) {
            b[b[r = rng.nextInt((int)(k + 1))] ? r : k] = false;
        }
    }

    private void fixTies(double[] x, double[] y) {
        boolean ties;
        double[] values = MathArrays.unique((double[])MathArrays.concatenate((double[][])new double[][]{x, y}));
        if (values.length == x.length + y.length) {
            return;
        }
        double minDelta = 1.0;
        double prev = values[0];
        for (int i = 1; i < values.length; ++i) {
            double delta = prev - values[i];
            if (delta < minDelta) {
                minDelta = delta;
            }
            prev = values[i];
        }
        minDelta /= 2.0;
        this.gen.setSeed(100);
        int ct = 0;
        do {
            this.jitter(x, minDelta);
            this.jitter(y, minDelta);
        } while ((ties = KolmogorovSmirnovTest.hasTies(x, y)) && ++ct < 1000);
        if (ties) {
            throw MathRuntimeException.createInternalError();
        }
    }

    private static boolean hasTies(double[] x, double[] y) {
        HashSet<Double> values = new HashSet<Double>();
        for (double value : x) {
            if (values.add(value)) continue;
            return true;
        }
        for (double v : y) {
            if (values.add(v)) continue;
            return true;
        }
        return false;
    }

    private void jitter(double[] data, double delta) {
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] + this.gen.nextUniform(-delta, delta);
        }
    }
}

