/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.area;

import org.hiylo.components.commons.area.Gis;
import org.hiylo.components.commons.utils.NumberUtils;

public class DistanceUtils {
    private static final int THOUSAND = 1000;
    private Gis gis = new Gis();

    public final String getDistanceWithSuffix(int meter) {
        if (meter / 1000 > 0) {
            return NumberUtils.castDoubleKeepTwoDecimalPlaces((double)meter / 1000.0) + "km";
        }
        return meter + "m";
    }

    public final String getDistanceWithSuffix(double startLatitude, double startLongitude, double endLatitude, double endLongitude) {
        int distance = this.getDistance(startLatitude, startLongitude, endLatitude, endLongitude);
        return this.getDistanceWithSuffix(distance);
    }

    public final int getDistance(double startLatitude, double startLongitude, double endLatitude, double endLongitude) {
        return (int)((double)Math.round(2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((startLatitude * Math.PI / 180.0 - endLatitude * Math.PI / 180.0) / 2.0), 2.0) + Math.cos(startLatitude) * Math.cos(endLatitude) * Math.pow(Math.sin((startLongitude * Math.PI / 180.0 - endLongitude * Math.PI / 180.0) / 2.0), 2.0))) * 6378137.0 * 10000.0) / 10000.0);
    }

    private Double convertDegreesToRadians(Double degrees) {
        return degrees * Math.PI / 180.0;
    }
}

