/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.area;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.geom.Point2D;
import java.util.List;

public class Gis {
    private GeometryFactory geometryFactory = new GeometryFactory();

    public String castToMysqlPolygon(String ... lntlats) {
        StringBuilder sb = new StringBuilder(" POLYGONFROMTEXT('POLYGON((");
        for (int i = 0; i < lntlats.length; ++i) {
            String[] lntlat = lntlats[i].split(",");
            sb.append(lntlat[0]).append(" ").append(lntlat[1]).append(",");
            if (lntlats.length != i + 1) continue;
            sb.append(lntlats[0].split(",")[0]).append(" ").append(lntlats[0].split(",")[1]);
        }
        sb.append("))')");
        return sb.toString();
    }

    public String castToMysqlPoint(String lntlatStr) {
        StringBuilder sb = new StringBuilder(" ST_POINTFROMTEXT('POINT(");
        String[] lntlat = lntlatStr.split(",");
        sb.append(lntlat[0]).append(" ").append(lntlat[1]);
        sb.append(")')");
        return sb.toString();
    }

    public String castToMysqlLine(String ... lntlats) {
        StringBuilder sb = new StringBuilder(" LINESTRINGFROMTEXT('LINESTRING(");
        for (int i = 0; i < lntlats.length; ++i) {
            String[] lntlat = lntlats[i].split(",");
            sb.append(lntlat[0]).append(" ").append(lntlat[1]).append(",");
            if (lntlats.length != i + 1) continue;
            sb.append(lntlats[0].split(",")[0]).append(" ").append(lntlats[0].split(",")[1]);
        }
        sb.append(")')");
        return sb.toString();
    }

    public Polygon createPolygon(List<String> points) throws ParseException {
        WKTReader reader = new WKTReader(this.geometryFactory);
        StringBuilder pointsStr = new StringBuilder("POLYGON((");
        points.forEach(item -> {
            String[] items = item.split(",");
            pointsStr.append(items[0]).append(" ").append(items[1]);
            pointsStr.append(",");
        });
        String firstPoint = points.get(0);
        pointsStr.append(firstPoint.split(",")[0] + " " + firstPoint.split(",")[1]);
        pointsStr.append("))");
        System.out.println(pointsStr);
        return (Polygon)reader.read(pointsStr.toString());
    }

    public Point createPoint(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point point = this.geometryFactory.createPoint(coord);
        return point;
    }

    private Envelope createEnvelope() {
        Envelope envelope = new Envelope(0.0, 1.0, 0.0, 2.0);
        return envelope;
    }

    private Point createPointByWKT(double longitude, double latitude) throws ParseException {
        WKTReader reader = new WKTReader(this.geometryFactory);
        Point point = (Point)reader.read("POINT (" + longitude + " " + latitude + ")");
        return point;
    }

    private MultiPoint createMulPointByWKT() throws ParseException {
        WKTReader reader = new WKTReader(this.geometryFactory);
        MultiPoint mpoint = (MultiPoint)reader.read("MULTIPOINT(109.013388 32.715519,119.32488 31.435678)");
        return mpoint;
    }

    private LineString createLine() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(2.0, 2.0)};
        LineString line = this.geometryFactory.createLineString(coords);
        return line;
    }

    private LineString createLineByWKT() throws ParseException {
        WKTReader reader = new WKTReader(this.geometryFactory);
        LineString line = (LineString)reader.read("LINESTRING(0 0, 2 0)");
        return line;
    }

    private MultiLineString createMLine() {
        Coordinate[] coords1 = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(2.0, 2.0)};
        LineString line1 = this.geometryFactory.createLineString(coords1);
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(2.0, 2.0)};
        LineString line2 = this.geometryFactory.createLineString(coords2);
        LineString[] lineStrings = new LineString[]{line1, line2};
        MultiLineString ms = this.geometryFactory.createMultiLineString(lineStrings);
        return ms;
    }

    private MultiLineString createMLineByWKT() throws ParseException {
        WKTReader reader = new WKTReader(this.geometryFactory);
        MultiLineString line = (MultiLineString)reader.read("MULTILINESTRING((0 0, 2 0),(1 1,2 2))");
        return line;
    }

    private MultiPolygon createMulPolygonByWKT() throws ParseException {
        WKTReader reader = new WKTReader(this.geometryFactory);
        MultiPolygon mpolygon = (MultiPolygon)reader.read("MULTIPOLYGON(((40 10, 30 0, 40 10, 30 20, 40 10),(30 10, 30 0, 40 10, 30 20, 30 10)))");
        return mpolygon;
    }

    private Polygon createCircle(double x, double y, double RADIUS) {
        int SIDES = 32;
        Coordinate[] coords = new Coordinate[33];
        for (int i = 0; i < 32; ++i) {
            double angle = (double)i / 32.0 * Math.PI * 2.0;
            double dx = Math.cos(angle) * RADIUS;
            double dy = Math.sin(angle) * RADIUS;
            coords[i] = new Coordinate(x + dx, y + dy);
        }
        coords[32] = coords[0];
        LinearRing ring = this.geometryFactory.createLinearRing(coords);
        Polygon polygon = this.geometryFactory.createPolygon(ring, null);
        return polygon;
    }

    public static boolean isPtInPoly(Point2D.Double point, List<Point2D.Double> pts) {
        int N = pts.size();
        boolean boundOrVertex = true;
        int intersectCount = 0;
        double precision = 2.0E-10;
        Point2D.Double p = point;
        Point2D.Double p1 = pts.get(0);
        for (int i = 1; i <= N; ++i) {
            if (p.equals(p1)) {
                return boundOrVertex;
            }
            Point2D.Double p2 = pts.get(i % N);
            if (p.x < Math.min(p1.x, p2.x) || p.x > Math.max(p1.x, p2.x)) {
                p1 = p2;
                continue;
            }
            if (p.x > Math.min(p1.x, p2.x) && p.x < Math.max(p1.x, p2.x)) {
                if (p.y <= Math.max(p1.y, p2.y)) {
                    if (p1.x == p2.x && p.y >= Math.min(p1.y, p2.y)) {
                        return boundOrVertex;
                    }
                    if (p1.y == p2.y) {
                        if (p1.y == p.y) {
                            return boundOrVertex;
                        }
                        ++intersectCount;
                    } else {
                        double xinters = (p.x - p1.x) * (p2.y - p1.y) / (p2.x - p1.x) + p1.y;
                        if (Math.abs(p.y - xinters) < precision) {
                            return boundOrVertex;
                        }
                        if (p.y < xinters) {
                            ++intersectCount;
                        }
                    }
                }
            } else if (p.x == p2.x && p.y <= p2.y) {
                Point2D.Double p3 = pts.get((i + 1) % N);
                intersectCount = p.x >= Math.min(p1.x, p3.x) && p.x <= Math.max(p1.x, p3.x) ? ++intersectCount : (intersectCount += 2);
            }
            p1 = p2;
        }
        return intersectCount % 2 != 0;
    }

    private static void main(String[] args) throws ParseException {
        Gis gt = new Gis();
        Polygon p = gt.createCircle(0.0, 1.0, 2.0);
        Coordinate[] coords = p.getCoordinates();
        Envelope envelope = gt.createEnvelope();
    }
}

