/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.beanutils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.persistence.Column;
import org.hiylo.components.commons.beanutils.annotation.EnumMapper;
import org.hiylo.components.commons.beanutils.annotation.PropertyMapper;
import org.hiylo.components.commons.utils.DateUtils;
import org.hiylo.components.commons.utils.NumberUtils;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.exceptions.CommonsRuntimeException;
import org.hiylo.components.exceptions.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    private static final String MARK_ARGS_NOT_BE_EMPTY = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a {}";
    private Logger log = LoggerFactory.getLogger((String)BeanUtils.class.getName());

    public <T> T convert(Object src, T dest) {
        if (src == null || dest == null) {
            return null;
        }
        this.copyProperties(src, dest);
        this.copyEnum(src, dest);
        return this.convertBeans(src, dest);
    }

    private <T> T copyEnum(Object src, T dest) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = src.getClass().getDeclaredFields()) {
            EnumMapper annotation = declaredField.getAnnotation(EnumMapper.class);
            if (!Objects.nonNull(annotation)) continue;
            Object value = this.getValueFromObject(src, declaredField.getName());
            try {
                Class<?> enumClazz = Class.forName(annotation.refer());
                if (annotation.methodReturnObject()) {
                    value = enumClazz.getMethod(annotation.method(), this.getFieldType(src, declaredField.getName())).invoke(null, value);
                    if (!Objects.nonNull(value) && annotation.ignore()) continue;
                    if (StringUtils.isNotEmpty(annotation.to())) {
                        this.setFieldValue(dest, annotation.to(), value);
                        continue;
                    }
                    this.setFieldValue(dest, declaredField.getName(), value);
                    continue;
                }
                value = this.getFieldValue(value, annotation.referField());
                if (annotation.ignore() && !Objects.nonNull(value)) continue;
                if (StringUtils.isNotEmpty(annotation.to())) {
                    this.setFieldValue(dest, annotation.to(), value);
                    continue;
                }
                this.setFieldValue(dest, declaredField.getName(), value);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return dest;
    }

    public <T> T convertExclude(Object src, T dest, String ... fieldsArr) {
        if (src == null || dest == null) {
            return null;
        }
        this.copyPropertiesExclude(src, dest, fieldsArr);
        return this.convertBeansExclude(src, dest, fieldsArr);
    }

    private <T> T copyProperties(Object src, T dest) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = src.getClass().getDeclaredFields()) {
            if ("serialVersionUID".equals(declaredField.getName())) continue;
            this.copyProperties(src, dest, declaredField);
        }
        return dest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T copyProperties(Object src, T dest, Field declaredField) {
        PropertyMapper annotation = declaredField.getAnnotation(PropertyMapper.class);
        Class<?> fieldType = this.getFieldType(src, declaredField.getName());
        if (Objects.nonNull(fieldType) && fieldType.getName().startsWith("java.lang.") && (Objects.isNull(annotation) || !annotation.ignore())) {
            try {
                Object value = this.getValueFromObject(src, declaredField.getName());
                if (!Objects.nonNull(value)) return dest;
                if (!this.checkFieldExist(dest, declaredField.getName()) && "java.lang.Double".equals(this.getFieldType(dest, declaredField.getName()).getName()) && Objects.nonNull(declaredField.getAnnotation(Column.class))) {
                    if (declaredField.getAnnotation(Column.class).scale() != 0) {
                        double doubleValue = Double.parseDouble(String.valueOf(value));
                        doubleValue = NumberUtils.noRound(doubleValue, declaredField.getAnnotation(Column.class).scale());
                        org.apache.commons.beanutils.BeanUtils.copyProperty(dest, (String)declaredField.getName(), (Object)doubleValue);
                        return dest;
                    }
                    org.apache.commons.beanutils.BeanUtils.copyProperty(dest, (String)declaredField.getName(), (Object)value);
                    return dest;
                }
                if (!this.checkFieldExist(dest, declaredField.getName()) && "java.sql.Timestamp".equals(this.getFieldType(dest, declaredField.getName()).getName())) {
                    try {
                        Timestamp timestamp = DateUtils.parseDateStringToTimestamp(String.valueOf(value));
                        this.setFieldValue(dest, declaredField.getName(), (Object)timestamp);
                        return dest;
                    }
                    catch (ParseException timestamp) {}
                    return dest;
                }
                org.apache.commons.beanutils.BeanUtils.copyProperty(dest, (String)declaredField.getName(), (Object)value);
                return dest;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
        }
        if (Objects.nonNull(fieldType) && "java.sql.Timestamp".equals(fieldType.getName()) && (Objects.isNull(annotation) || !annotation.ignore())) {
            try {
                Object value = this.getValueFromObject(src, declaredField.getName());
                if (!Objects.nonNull(value)) return dest;
                if (!this.checkFieldExist(dest, declaredField.getName())) {
                    String date = DateUtils.formatTimestampToStandardDateString((Timestamp)value);
                    this.setFieldValue(dest, declaredField.getName(), (Object)date);
                    return dest;
                }
                org.apache.commons.beanutils.BeanUtils.copyProperty(dest, (String)declaredField.getName(), (Object)value);
                return dest;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
        }
        if (Objects.nonNull(fieldType) && "java.math.BigDecimal".equals(fieldType.getName()) && (Objects.isNull(annotation) || !annotation.ignore())) {
            try {
                Object value = this.getValueFromObject(src, declaredField.getName());
                if (!Objects.nonNull(value)) return dest;
                if (!this.checkFieldExist(dest, declaredField.getName())) {
                    this.setFieldValue(dest, declaredField.getName(), value);
                    return dest;
                }
                org.apache.commons.beanutils.BeanUtils.copyProperty(dest, (String)declaredField.getName(), (Object)value);
                return dest;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
        }
        if (!Objects.nonNull(fieldType) || !"java.time.LocalDateTime".equals(fieldType.getName()) && !"java.time.LocalTime".equals(fieldType.getName()) || !Objects.isNull(annotation) && annotation.ignore()) return dest;
        try {
            Object value = this.getValueFromObject(src, declaredField.getName());
            if (!Objects.nonNull(value)) return dest;
            if (!this.checkFieldExist(dest, declaredField.getName())) {
                this.setFieldValue(dest, declaredField.getName(), value);
                return dest;
            } else {
                org.apache.commons.beanutils.BeanUtils.copyProperty(dest, (String)declaredField.getName(), (Object)value);
            }
            return dest;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    private <T> T copyPropertiesExclude(Object src, T dest, String ... fieldsArr) {
        Field[] declaredFields;
        List<String> fields = Arrays.asList(fieldsArr);
        for (Field declaredField : declaredFields = src.getClass().getDeclaredFields()) {
            if (fields.contains(declaredField.getName())) continue;
            this.copyProperties(src, dest, declaredField);
        }
        return dest;
    }

    private <T> T convertBeans(Object src, T dest) {
        return this.convertBeansExclude(src, dest, new String[0]);
    }

    private <T> T convertBeansExclude(Object src, T dest, String ... fieldsArr) {
        Field[] fields;
        List<String> fieldsList = Arrays.asList(fieldsArr);
        for (Field field : fields = src.getClass().getDeclaredFields()) {
            PropertyMapper annotation;
            if (fieldsList.contains(field.getName()) || !Objects.nonNull(annotation = field.getAnnotation(PropertyMapper.class)) || annotation.ignore()) continue;
            String[] refer = annotation.refer();
            String[] to = annotation.to();
            Object o = this.getValueFromObject(src, field.getName());
            if (!Objects.nonNull(o) || o instanceof List) continue;
            for (int i = 0; i < refer.length; ++i) {
                this.getAndSetValue(o, dest, refer[i], to[i]);
            }
        }
        return dest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T getAndSetValue(Object src, T dest, String srcField, String destFirld) {
        Object value = this.getValueFromObject(src, srcField);
        if (!Objects.nonNull(value)) return dest;
        if (!this.checkFieldExist(dest, destFirld) && "java.sql.Timestamp".equals(this.getFieldType(dest, destFirld).getName())) {
            try {
                Timestamp timestamp = DateUtils.parseDateStringToTimestamp(String.valueOf(value));
                this.setFieldValue(dest, destFirld, (Object)timestamp);
                return dest;
            }
            catch (ParseException timestamp) {}
            return dest;
        } else if ("java.sql.Timestamp".equals(this.getFieldType(src, srcField).getName())) {
            try {
                if (!Objects.nonNull(value)) return dest;
                if (!this.checkFieldExist(dest, destFirld)) {
                    String date = DateUtils.formatTimestampToStandardDateString((Timestamp)value);
                    this.setFieldValue(dest, destFirld, (Object)date);
                    return dest;
                }
                org.apache.commons.beanutils.BeanUtils.copyProperty(dest, (String)destFirld, (Object)value);
                return dest;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
        } else {
            this.setFieldValue(dest, destFirld, value);
        }
        return dest;
    }

    public Object getValueFromObject(Object src, String field) {
        if (src == null) {
            return null;
        }
        if (!field.contains(".")) {
            return this.getFieldValue(src, field);
        }
        String[] childField = field.split("\\.");
        return this.getValueFromObject(src, childField);
    }

    private Object getValueFromObject(Object src, String[] childFields) {
        try {
            for (String field : childFields) {
                src = this.getValueFromObject(src, field);
            }
            return src;
        }
        catch (CommonsRuntimeException e) {
            return null;
        }
    }

    private Object getFieldValue(Object src, String field) {
        try {
            return src.getClass().getMethod("get" + this.firstCharToUpperCase(field), new Class[0]).invoke(src, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return src.getClass().getMethod("get" + this.secondCharToUpperCase(field), new Class[0]).invoke(src, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                e2.printStackTrace();
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
        }
    }

    public void setFieldValue(Object src, String field, Object obj) {
        if (src == null || obj == null) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        try {
            if (field.contains(".")) {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(field.split("\\.")));
                this.setFieldValue(src, list, obj);
            } else {
                try {
                    src.getClass().getMethod("set" + this.firstCharToUpperCase(field), obj.getClass()).invoke(src, obj);
                }
                catch (NoSuchMethodException e) {
                    src.getClass().getMethod("set" + this.secondCharToUpperCase(field), obj.getClass()).invoke(src, obj);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.error("{} {} {}", new Object[]{src, field, obj});
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    public void setFieldValue(Object src, String field, Object obj, Class objClass) {
        if (src == null || obj == null) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        try {
            if (field.contains(".")) {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(field.split("\\.")));
                this.setFieldValue(src, list, obj);
            } else {
                try {
                    src.getClass().getMethod("set" + this.firstCharToUpperCase(field), objClass).invoke(src, obj);
                }
                catch (NoSuchMethodException e) {
                    src.getClass().getMethod("set" + this.secondCharToUpperCase(field), objClass).invoke(src, obj);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    private void setFieldValue(Object src, List<String> childFields, Object obj) {
        if (src == null || obj == null) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        if (childFields.size() > 1) {
            Object o = this.getValueFromObject(src, childFields.get(0));
            if (o == null) {
                o = this.newInstanceWithEmpteConstruct(this.getFieldType(src, childFields.get(0)));
            }
            this.setFieldValue(src, childFields.get(0), o);
            childFields.remove(childFields.get(0));
            this.setFieldValue(o, childFields, obj);
        } else if (childFields.size() == 1) {
            this.setFieldValue(src, childFields.get(0), obj);
        }
    }

    private Object newInstanceWithEmpteConstruct(Class<?> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    public Class<?> getFieldType(Object obj, String field) {
        if (obj == null) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        if (!field.contains(".")) {
            try {
                if (!"$$_hibernate_interceptor".equals(field) && !field.startsWith("cachedValue$")) {
                    try {
                        return obj.getClass().getMethod("get" + this.firstCharToUpperCase(field), new Class[0]).getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        return obj.getClass().getMethod("get" + this.secondCharToUpperCase(field), new Class[0]).getReturnType();
                    }
                }
                return null;
            }
            catch (NoSuchMethodException e) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
        }
        String[] childField = field.split("\\.");
        return this.getFieldType(obj, childField);
    }

    private Class<?> getFieldType(Object src, String[] childFields) {
        try {
            for (int i = 0; i < childFields.length; ++i) {
                src = i + 1 != childFields.length ? this.getFieldValue(src, childFields[i]) : this.getFieldType(src, childFields[i]);
            }
            return (Class)src;
        }
        catch (CommonsRuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String firstCharToUpperCase(String src) {
        if (StringUtils.isEmpty(src)) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        switch (src.length()) {
            case 0: {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
            case 1: {
                return src.toUpperCase();
            }
        }
        return src.substring(0, 1).toUpperCase() + src.substring(1);
    }

    private String secondCharToUpperCase(String src) {
        if (StringUtils.isEmpty(src)) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        switch (src.length()) {
            case 0: {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
            case 1: {
                return src;
            }
        }
        return src.substring(0, 1) + src.substring(1, 2).toUpperCase() + src.substring(2);
    }

    public <T> List<T> convertList(List<?> srcs, Class<T> clazz) {
        if (srcs == null || clazz == null) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        try {
            ArrayList<T> result = new ArrayList<T>(srcs.size());
            for (Object src : srcs) {
                T dest = clazz.newInstance();
                result.add(this.convert(src, dest));
            }
            return result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    public <T> List<T> convertList(List<?> srcs, Class<T> clazz, Function<T, Optional<T>> consumer) {
        if (srcs == null || clazz == null) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        try {
            ArrayList result = new ArrayList(srcs.size());
            for (Object src : srcs) {
                T dest = clazz.newInstance();
                if (Objects.nonNull(consumer)) {
                    Object convert = this.convert(src, dest);
                    Optional.ofNullable(convert).ifPresent(t -> result.add(Optional.of(convert).flatMap(consumer).get()));
                    continue;
                }
                result.add(this.convert(src, dest));
            }
            return result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    public <T> List<T> convertListExclud(List<?> srcs, Class<T> clazz, String ... fields) {
        if (srcs == null || clazz == null) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
        try {
            ArrayList<T> result = new ArrayList<T>(srcs.size());
            for (Object src : srcs) {
                T dest = clazz.newInstance();
                result.add(this.convertExclude(src, dest, fields));
            }
            return result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    public boolean checkFieldExist(Object src, String field) {
        return Arrays.stream(src.getClass().getDeclaredFields()).filter(w -> field.equals(w.getName())).count() == 0L;
    }

    public List<Field> getFieldsWithAnnotaion(Field[] fields, Class annotation) {
        ArrayList<Field> result = new ArrayList<Field>();
        Arrays.stream(fields).forEach(item -> {
            if (Objects.nonNull(item.getAnnotation(annotation))) {
                result.add((Field)item);
            }
        });
        return result;
    }
}

