/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.email;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@ConditionalOnProperty(name={"spring.mail.enable"}, havingValue="true")
public class MailSenderTools {
    @Resource
    private JavaMailSender javaMailSender;
    @Value(value="${spring.mail.username}")
    private String from;

    public void sendMail(String to, String subject, String text) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.from);
        message.setTo(to);
        message.setSubject(subject);
        message.setText(text);
        this.javaMailSender.send(message);
    }

    public void sendMailWithMultipartFile(String to, String subject, String text, List<MultipartFile> multipartFiles) throws MessagingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
        helper.setFrom(this.from);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(text);
        for (MultipartFile multipartFile : multipartFiles) {
            helper.addAttachment(multipartFile.getName(), (InputStreamSource)multipartFile);
        }
        this.javaMailSender.send(mimeMessage);
    }

    public void sendMailWithFile(String to, String subject, String text, List<File> files) throws MessagingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
        helper.setFrom(this.from);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(text);
        for (File file : files) {
            helper.addAttachment(file.getName(), file);
        }
        this.javaMailSender.send(mimeMessage);
    }

    public void sendMailWithAttachment(String to, String subject, String text, List<String> filePaths) throws MessagingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
        helper.setFrom(this.from);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(text);
        for (String filePath : filePaths) {
            File attachment = new File(filePath);
            helper.addAttachment(attachment.getName(), attachment);
        }
        this.javaMailSender.send(mimeMessage);
    }

    public void sendRichMailWithAttachment(String to, String subject, String text, Map<String, String> filePaths) throws MessagingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
        helper.setFrom(this.from);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(text, true);
        for (String key : filePaths.keySet()) {
            helper.addInline(key, (org.springframework.core.io.Resource)new FileSystemResource(filePaths.get(key)));
        }
        this.javaMailSender.send(mimeMessage);
    }

    public void sendRichMailWithMultipartFile(String to, String subject, String text, Map<String, MultipartFile> multipartFiles) throws MessagingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
        helper.setFrom(this.from);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(text, true);
        for (String key : multipartFiles.keySet()) {
            helper.addInline(key, (InputStreamSource)multipartFiles.get(key), helper.getFileTypeMap().getContentType(key));
        }
        this.javaMailSender.send(mimeMessage);
    }
}

